/*
 * Decompiled with CFR 0.152.
 */
package me.andy.mobignoreme.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import me.andy.mobignoreme.config.ConfigManager;
import me.andy.mobignoreme.config.ModConfig;
import me.andy.mobignoreme.permissions.PermissionChecker;
import me.andy.mobignoreme.util.MessageHandler;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ListIgnoresCommand {
    public static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        class_2168 source = (class_2168)context.getSource();
        class_3222 sourcePlayer = source.method_43737() ? source.method_9207() : null;
        boolean isSelf = sourcePlayer != null && sourcePlayer.method_5667().equals(targetPlayer.method_5667());
        boolean isSinglePlayer = source.method_9211().method_3724();
        ModConfig.PermissionMode currentMode = ConfigManager.getConfig().getPermissionMode();
        if (!PermissionChecker.canViewList(source, isSelf)) {
            MessageHandler.sendError(source, "&cYou do not have permission to view this player's ignore list.");
            return 0;
        }
        boolean canUseToggles = PermissionChecker.canUseListToggles(source, isSelf);
        Set<Object> allMobIgnores = new TreeSet();
        HashMap<String, IgnoreSource> sourceMap = new HashMap<String, IgnoreSource>();
        if (isSinglePlayer) {
            allMobIgnores = ListIgnoresCommand.getAllHostileMobs();
        } else {
            List<String> configMobs;
            if ((currentMode == ModConfig.PermissionMode.FALSE || currentMode == ModConfig.PermissionMode.BOTH) && (configMobs = ConfigManager.getConfig().getPlayers().get(targetPlayer.method_5845())) != null) {
                for (String mob : configMobs) {
                    sourceMap.put(mob, IgnoreSource.CONFIG);
                    allMobIgnores.add(mob);
                }
            }
            if ((currentMode == ModConfig.PermissionMode.TRUE || currentMode == ModConfig.PermissionMode.BOTH) && PermissionChecker.IS_PERMISSIONS_API_LOADED) {
                boolean hasWildcard = PermissionChecker.hasPermission(targetPlayer, "mobs");
                for (String mobName : ListIgnoresCommand.getAllHostileMobs()) {
                    boolean hasSpecific = PermissionChecker.hasPermission(targetPlayer, mobName);
                    if (!hasSpecific && !hasWildcard) continue;
                    sourceMap.merge(mobName, IgnoreSource.PERM, (oldVal, newVal) -> IgnoreSource.BOTH);
                    allMobIgnores.add(mobName);
                }
            }
        }
        if (allMobIgnores.isEmpty()) {
            MessageHandler.sendMessage(source, "&cThis player %s is not ignored by any mobs.".formatted(targetPlayer.method_5477().getString()));
            return 1;
        }
        MessageHandler.sendMessage(source, "&eThis player %s is ignored by these mobs:".formatted(targetPlayer.method_5477().getString()));
        if (canUseToggles && allMobIgnores.size() > 1) {
            String command = String.format("/mobignoreinternal togglealldisable %s", targetPlayer.method_5477().getString());
            class_5250 class_52502 = class_2561.method_43470((String)"- All Your Mobs").method_27692(class_124.field_1065).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(command)));
            source.method_9226(() -> allMobsLine, false);
        }
        for (String string : allMobIgnores) {
            IgnoreSource sourceVal;
            boolean isDisabled = PermissionChecker.isPlayerDisabled(targetPlayer, string);
            class_5250 line = class_2561.method_43470((String)"- ").method_27692(class_124.field_1080);
            class_5250 mobText = class_2561.method_43470((String)string).method_27692(isDisabled ? class_124.field_1076 : class_124.field_1060);
            if (canUseToggles) {
                String command = String.format("/mobignoreinternal toggledisable %s %s", targetPlayer.method_5477().getString(), string);
                mobText.method_10862(mobText.method_10866().method_10958((class_2558)new class_2558.class_10609(command)));
            }
            line.method_10852((class_2561)mobText);
            if (!isSinglePlayer && currentMode == ModConfig.PermissionMode.BOTH && (sourceVal = (IgnoreSource)((Object)sourceMap.get(string))) != null) {
                switch (sourceVal.ordinal()) {
                    case 0: {
                        line.method_10852((class_2561)class_2561.method_43470((String)" (Config)").method_27692(class_124.field_1080));
                        break;
                    }
                    case 1: {
                        line.method_10852((class_2561)class_2561.method_43470((String)" (PermNode)").method_27692(class_124.field_1080));
                        break;
                    }
                    case 2: {
                        line.method_10852((class_2561)class_2561.method_43470((String)" (Config + PermNode)").method_27692(class_124.field_1080));
                    }
                }
            }
            source.method_9226(() -> line, false);
        }
        return 1;
    }

    private static Set<String> getAllHostileMobs() {
        return class_7923.field_41177.method_10235().stream().filter(id -> {
            class_1299 type = (class_1299)class_7923.field_41177.method_63535(id);
            return type != null && type.method_5891() == class_1311.field_6302;
        }).map(class_2960::method_12832).collect(Collectors.toCollection(TreeSet::new));
    }

    private static enum IgnoreSource {
        CONFIG,
        PERM,
        BOTH;

    }
}

