/*
 * Decompiled with CFR 0.152.
 */
package me.andy.mobignoreme.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import me.andy.mobignoreme.Mobignoreme;
import me.andy.mobignoreme.config.ModConfig;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    private static ModConfig config;

    public static void initialize() {
        configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "mobignoreme.json");
        ConfigManager.loadConfig();
    }

    public static void loadConfig() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (config == null) {
                    config = new ModConfig();
                }
            }
            catch (IOException e) {
                Mobignoreme.LOGGER.error("Failed to load config file!", (Throwable)e);
                config = new ModConfig();
            }
        } else {
            config = new ModConfig();
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            Mobignoreme.LOGGER.error("Failed to save config file!", (Throwable)e);
        }
    }

    public static ModConfig getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }

    public static void toggleMobIgnore(String playerUuid, String mobId) {
        List ignoredMobs = config.getPlayers().computeIfAbsent(playerUuid, k -> new ArrayList());
        if (ignoredMobs.contains(mobId)) {
            ignoredMobs.remove(mobId);
        } else {
            ignoredMobs.add(mobId);
        }
        ConfigManager.saveConfig();
    }

    public static void toggleMobDisable(String playerUuid, String mobId) {
        List disabledList = config.getDisabledMobs().computeIfAbsent(playerUuid, k -> new ArrayList());
        if (disabledList.contains(mobId)) {
            disabledList.remove(mobId);
        } else {
            disabledList.add(mobId);
        }
        ConfigManager.saveConfig();
    }
}

