/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.crabclaws;

import dev.architectury.event.events.common.LootEvent;
import dev.foxgirl.crabclaws.CrabClawItem;
import dev.foxgirl.crabclaws.CrabClawsConfig;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;

@Mod(value="crabclaws")
public final class CrabClaws {
    public static final String MOD_ID = "crabclaws";

    public static Identifier id(String path) {
        return Identifier.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void initialize(IEventBus modEventBus) {
        LootEvent.MODIFY_LOOT_TABLE.register(this::onModifyLootTable);
        modEventBus.addListener(event -> {
            if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                event.insertBefore(new ItemStack((ItemLike)Items.WOODEN_SHOVEL), new ItemStack((ItemLike)CrabClawItem.INSTANCE), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        });
    }

    public CrabClaws(IEventBus modEventBus) {
        this.initialize(modEventBus);
    }

    private void onModifyLootTable(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context, boolean builtIn) {
        Identifier underWaterRuinSmall = BuiltInLootTables.UNDERWATER_RUIN_SMALL.identifier();
        Identifier underWaterRuinBig = BuiltInLootTables.UNDERWATER_RUIN_BIG.identifier();
        if (CrabClawsConfig.getConfig().shouldSpawnClawsInRuins && (key.identifier().equals((Object)underWaterRuinSmall) || key.identifier().equals((Object)underWaterRuinBig))) {
            context.addPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(CrabClawsConfig.getConfig().probabilityOfClawsInRuins)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)CrabClawItem.INSTANCE).setWeight(1)));
        }
    }
}

