/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.crabclaws;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.architectury.platform.Platform;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrabClawsConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    private static final CrabClawsConfig CONFIG = CrabClawsConfig.loadConfig();
    public float clawExtraReachAmount = 3.0f;
    public boolean shouldSpawnClawsInRuins = true;
    public int probabilityOfClawsInRuins = 7;

    private static CrabClawsConfig loadConfig() {
        Path configPath = Platform.getConfigFolder().resolve("crabclaws.json");
        Path tempPath = Platform.getConfigFolder().resolve("crabclaws.json.tmp");
        try {
            return (CrabClawsConfig)GSON.fromJson((Reader)Files.newBufferedReader(configPath), CrabClawsConfig.class);
        }
        catch (NoSuchFileException cause) {
            LOGGER.warn("Config file not found, will be created");
        }
        catch (JsonParseException cause) {
            LOGGER.error("Failed to parse config file", (Throwable)cause);
        }
        catch (Exception cause) {
            LOGGER.error("Failed to load config file", (Throwable)cause);
        }
        CrabClawsConfig config = new CrabClawsConfig();
        try {
            Files.writeString(tempPath, (CharSequence)GSON.toJson((Object)config, CrabClawsConfig.class), new OpenOption[0]);
            Files.move(tempPath, configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception cause) {
            LOGGER.error("Failed to save new config file", (Throwable)cause);
        }
        return config;
    }

    public static CrabClawsConfig getConfig() {
        return CONFIG;
    }
}

