/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.immersiveoverlays.overlay;

import cc.cassian.immersiveoverlays.ModClient;
import cc.cassian.immersiveoverlays.config.ModConfig;
import cc.cassian.immersiveoverlays.overlay.ClockOverlay;
import cc.cassian.immersiveoverlays.overlay.OverlayHelpers;
import cc.cassian.immersiveoverlays.overlay.TemperatureOverlay;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeOverlay {
    public static boolean showBiome = false;
    public static ResourceLocation UNDEFINED = ModClient.locate("textures/immersiveoverlays/undefined.png");

    public static void renderGameOverlayEvent(GuiGraphics guiGraphics, float deltaTracker) {
        if (!showBiome || !ModConfig.get().biome_enable) {
            return;
        }
        if (ModConfig.get().biome_reduced_info) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (OverlayHelpers.shouldCancelRender(mc)) {
            return;
        }
        if (mc.f_91074_ == null) {
            return;
        }
        Holder<Biome> biome = BiomeOverlay.getBiome(mc.f_91074_);
        ResourceLocation biomeId = BiomeOverlay.getId(biome);
        String biomeText = BiomeOverlay.formatBiome(biomeId);
        int yPlacement = ModConfig.get().biome_vertical_position;
        int textYPlacement = yPlacement + 2;
        int xOffset = 3;
        int iconXOffset = 0;
        ResourceLocation sprite = UNDEFINED;
        if (ModConfig.get().biome_icons && !(sprite = BiomeOverlay.getBiomeSprite(biomeId, true)).equals((Object)UNDEFINED)) {
            iconXOffset = 20;
        }
        int tooltipSize = 21;
        int fontWidth = mc.f_91062_.m_92895_(biomeText) + iconXOffset;
        if (ModConfig.get().avoid_overlapping) {
            if (!ClockOverlay.showTime && !ClockOverlay.showWeather || !ModConfig.get().clock_enable) {
                yPlacement -= 24;
                textYPlacement -= 24;
            }
            if (ClockOverlay.shouldShowSeasons()) {
                yPlacement += 15;
                textYPlacement += 15;
            }
        }
        if (OverlayHelpers.playerHasPotions((Player)mc.f_91074_, ModConfig.get().biome_horizontal_position_left)) {
            yPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
            textYPlacement += OverlayHelpers.moveBy((Player)mc.f_91074_);
        }
        int windowWidth = mc.m_91268_().m_85445_();
        int xPlacement = OverlayHelpers.getPlacement(windowWidth, fontWidth, ModConfig.get().biome_horizontal_position_left);
        if (showBiome) {
            OverlayHelpers.renderBackground(guiGraphics, windowWidth, fontWidth, xPlacement, xOffset, yPlacement, tooltipSize, ModConfig.get().biome_horizontal_position_left);
            OverlayHelpers.drawString(guiGraphics, mc.f_91062_, biomeText, xPlacement - xOffset + iconXOffset, textYPlacement, BiomeOverlay.getTextColour(biome));
            if (ModConfig.get().biome_icons && !sprite.equals((Object)UNDEFINED)) {
                OverlayHelpers.blitSprite(guiGraphics, sprite, xPlacement - xOffset - 1, textYPlacement - 4);
            }
        }
    }

    private static Integer getTextColour(Holder<Biome> biome) {
        if (ModConfig.get().biome_text_tinted) {
            return TemperatureOverlay.getBiomeTemperature(biome).color();
        }
        return ModConfig.get().biome_text_colour;
    }

    public static ResourceLocation getBiomeSprite(ResourceLocation biome, boolean allowRedirect) {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        String path = "textures/immersiveoverlays/" + biome.m_135815_();
        ResourceLocation key = ModClient.locate(biome.m_135827_(), "%s.png".formatted(path));
        ResourceLocation redirect = ModClient.locate(biome.m_135827_(), "%s.txt".formatted(path));
        if (manager.m_213713_(key).isPresent()) {
            return key;
        }
        if (manager.m_213713_(redirect).isPresent() && allowRedirect) {
            try {
                return BiomeOverlay.getBiomeSprite(Objects.requireNonNull(ResourceLocation.m_135820_((String)manager.m_215597_(redirect).lines().toList().get(0))), false);
            }
            catch (Exception e) {
                return UNDEFINED;
            }
        }
        return UNDEFINED;
    }

    public static Holder<Biome> getBiome(LocalPlayer player) {
        return player.m_9236_().m_204166_(player.m_20183_());
    }

    public static ResourceLocation getId(Holder<Biome> biome) {
        return biome.m_203543_().orElse(Biomes.f_48173_).m_135782_();
    }

    public static String formatBiome(ResourceLocation biome) {
        String path = biome.m_135815_();
        String namespace = biome.m_135827_();
        String key = "biome.%s.%s".formatted(namespace, path);
        if (I18n.m_118936_((String)key)) {
            return I18n.m_118938_((String)key, (Object[])new Object[0]);
        }
        return WordUtils.capitalize((String)path.replace("_", " "));
    }
}

