/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.animator.entity.EntityJointAnimator;
import com.trainguy9512.locomotion.animation.animator.entity.LivingEntityJointAnimator;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class JointAnimatorRegistry {
    private static final HashMap<EntityType<?>, EntityJointAnimator<?, ?>> THIRD_PERSON_ENTITY_JOINT_ANIMATORS = Maps.newHashMap();
    private static LivingEntityJointAnimator<LocalPlayer, AvatarRenderState> FIRST_PERSON_PLAYER_JOINT_ANIMATOR = null;

    private JointAnimatorRegistry() {
    }

    public static <T extends Entity> void registerEntityJointAnimator(EntityType<T> entityType, EntityJointAnimator<T, ?> entityJointAnimator) {
        THIRD_PERSON_ENTITY_JOINT_ANIMATORS.put(entityType, entityJointAnimator);
    }

    public static void registerFirstPersonPlayerJointAnimator(LivingEntityJointAnimator<LocalPlayer, AvatarRenderState> firstPersonPlayerJointAnimator) {
        FIRST_PERSON_PLAYER_JOINT_ANIMATOR = firstPersonPlayerJointAnimator;
    }

    public static <T extends Entity> Optional<EntityJointAnimator<T, ?>> getThirdPersonJointAnimator(T entity) {
        return Optional.ofNullable(THIRD_PERSON_ENTITY_JOINT_ANIMATORS.get(entity.getType()));
    }

    public static Optional<LivingEntityJointAnimator<LocalPlayer, AvatarRenderState>> getFirstPersonPlayerJointAnimator() {
        return Optional.ofNullable(FIRST_PERSON_PLAYER_JOINT_ANIMATOR);
    }
}

