/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrinking;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonEating;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMining;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.MakeDynamicAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.render.ItemRenderType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;

public class FirstPersonGenericItems {
    private static final Map<Identifier, GenericItemPoseDefinition> GENERIC_ITEM_POSES_BY_IDENTIFIER = new HashMap<Identifier, GenericItemPoseDefinition>();
    public static final Identifier GENERIC_2D_ITEM = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("generic_2d_item"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE, itemStack -> true, 0).build());
    public static final Identifier ROD = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("rod"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_ROD_POSE, FirstPersonGenericItems::isRodItem, 20).build());
    public static final Identifier SHEARS = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("shears"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_SHEARS_POSE, FirstPersonGenericItems::isShearsItem, 60).build());
    public static final Identifier FISHING_ROD = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("fishing_rod"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_FISHING_ROD_POSE, FirstPersonGenericItems::isFishingRodItem, 70).build());
    public static final Identifier ARROW = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("arrow"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_ARROW_POSE, FirstPersonGenericItems::isArrowItem, 80).setItemRenderType(ItemRenderType.MIRRORED_THIRD_PERSON_ITEM).build());
    public static final Identifier BLOCK = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("block"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_BLOCK_POSE, FirstPersonGenericItems::isBlockItem, 80).setItemRenderType(ItemRenderType.BLOCK_STATE).build());
    public static final Identifier DOOR = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("door"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_DOOR_BLOCK_POSE, FirstPersonGenericItems::isDoorItem, 90).setItemRenderType(ItemRenderType.BLOCK_STATE).build());
    public static final List<Item> ROD_ITEMS = List.of(Items.BONE, Items.STICK, Items.BLAZE_ROD, Items.BREEZE_ROD, Items.POINTED_DRIPSTONE, Items.BAMBOO, Items.DEBUG_STICK, Items.END_ROD);
    public static final List<Item> FISHING_ROD_ITEMS = List.of(Items.FISHING_ROD, Items.CARROT_ON_A_STICK, Items.WARPED_FUNGUS_ON_A_STICK);
    public static final List<Item> BLOCK_ITEM_OVERRIDES = List.of(Items.CHEST, Items.TRAPPED_CHEST, Items.ENDER_CHEST);
    public static final List<TagKey<Item>> BLOCK_ITEM_TAG_OVERRIDES = List.of(ItemTags.COPPER_CHESTS, ItemTags.SHULKER_BOXES, ItemTags.SKULLS, ItemTags.BEDS);

    public static Identifier register(Identifier identifier, GenericItemPoseDefinition genericItemPoseDefinition) {
        GENERIC_ITEM_POSES_BY_IDENTIFIER.put(identifier, genericItemPoseDefinition);
        return identifier;
    }

    private static boolean isRodItem(ItemStack itemStack) {
        return ROD_ITEMS.contains(itemStack.getItem());
    }

    private static boolean isShearsItem(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShearsItem;
    }

    private static boolean isFishingRodItem(ItemStack itemStack) {
        return FISHING_ROD_ITEMS.contains(itemStack.getItem());
    }

    private static boolean isArrowItem(ItemStack itemStack) {
        return itemStack.is(ItemTags.ARROWS);
    }

    private static boolean isBlockItem(ItemStack itemStack) {
        if (!(itemStack.getItem() instanceof BlockItem)) {
            return false;
        }
        for (Item item : BLOCK_ITEM_OVERRIDES) {
            if (!itemStack.is(item)) continue;
            return true;
        }
        for (TagKey tagKey : BLOCK_ITEM_TAG_OVERRIDES) {
            if (!itemStack.is(tagKey)) continue;
            return true;
        }
        Identifier identifier = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        Identifier identifier2 = Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)("models/item/" + identifier.getPath() + ".json"));
        return Minecraft.getInstance().getResourceManager().getResource(identifier2).isEmpty();
    }

    private static boolean isDoorItem(ItemStack itemStack) {
        return itemStack.is(ItemTags.DOORS);
    }

    public static Identifier getFallback() {
        return GENERIC_2D_ITEM;
    }

    public static GenericItemPoseDefinition getOrThrowFromIdentifier(Identifier identifier) {
        GenericItemPoseDefinition definition = GENERIC_ITEM_POSES_BY_IDENTIFIER.get(identifier);
        if (definition == null) {
            throw new RuntimeException("Identifier " + String.valueOf(identifier) + " is not a registered generic item pose.");
        }
        return definition;
    }

    public static Identifier getConfigurationFromItem(ItemStack itemStack) {
        Map genericItemPosesSortedByPriority = GENERIC_ITEM_POSES_BY_IDENTIFIER.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((GenericItemPoseDefinition)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (Identifier key : genericItemPosesSortedByPriority.keySet()) {
            GenericItemPoseDefinition definition = GENERIC_ITEM_POSES_BY_IDENTIFIER.get(key);
            if (!definition.choosePoseIfTrue().test(itemStack)) continue;
            return key;
        }
        return FirstPersonGenericItems.getFallback();
    }

    public static PoseFunction<LocalSpacePose> constructPoseFunction(CachedPoseContainer cachedPoseContainer, InteractionHand hand) {
        ApplyAdditiveFunction pose = FirstPersonMining.makeMainHandPickaxeMiningPoseFunction(cachedPoseContainer, hand);
        PoseFunction<LocalSpacePose> consumablePose = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE).build();
        consumablePose = FirstPersonEating.constructWithEatingStateMachine(cachedPoseContainer, hand, consumablePose);
        consumablePose = FirstPersonDrinking.constructWithDrinkingStateMachine(cachedPoseContainer, hand, consumablePose);
        pose = ApplyAdditiveFunction.of(pose, MakeDynamicAdditiveFunction.of(consumablePose, SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE).build()));
        return pose;
    }

    public record GenericItemPoseDefinition(Identifier basePoseSequence, Predicate<ItemStack> choosePoseIfTrue, int evaluationPriority, ItemRenderType itemRenderType) {
        public static Builder builder(Identifier basePoseAnimationSequence, Predicate<ItemStack> choosePoseIfTrue, int evaluationPriority) {
            return new Builder(basePoseAnimationSequence, choosePoseIfTrue, evaluationPriority);
        }

        public static class Builder {
            private final Identifier basePoseAnimationSequence;
            private final int evaluationPriority;
            private final Predicate<ItemStack> choosePoseIfTrue;
            private ItemRenderType itemRenderType;

            private Builder(Identifier basePoseAnimationSequence, Predicate<ItemStack> choosePoseIfTrue, int evaluationPriority) {
                this.basePoseAnimationSequence = basePoseAnimationSequence;
                this.choosePoseIfTrue = choosePoseIfTrue;
                this.evaluationPriority = evaluationPriority;
                this.itemRenderType = ItemRenderType.THIRD_PERSON_ITEM;
            }

            public Builder setItemRenderType(ItemRenderType itemRenderType) {
                this.itemRenderType = itemRenderType;
                return this;
            }

            public GenericItemPoseDefinition build() {
                return new GenericItemPoseDefinition(this.basePoseAnimationSequence, this.choosePoseIfTrue, this.evaluationPriority, this.itemRenderType);
            }
        }
    }
}

