/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class FirstPersonItemUpdateAnimations {
    private static final Map<Identifier, ItemUpdateAnimationRule> ITEM_UPDATE_ANIMATION_RULES_BY_IDENTIFIER = Maps.newHashMap();
    public static final Identifier CROSSBOW_FIRE = FirstPersonItemUpdateAnimations.register(LocomotionMain.makeIdentifier("crossbow_fire"), ItemUpdateAnimationRule.of(FirstPersonMontages::getCrossbowFireMontage, FirstPersonItemUpdateAnimations::shouldPlayCrossbowFire, 0));
    public static final Identifier BUCKET_COLLECT = FirstPersonItemUpdateAnimations.register(LocomotionMain.makeIdentifier("bucket_collect"), ItemUpdateAnimationRule.of(FirstPersonMontages::getBucketCollectMontage, FirstPersonItemUpdateAnimations::shouldPlayBucketCollect, 0));
    public static final Identifier BUCKET_EMPTY = FirstPersonItemUpdateAnimations.register(LocomotionMain.makeIdentifier("bucket_empty"), ItemUpdateAnimationRule.of(FirstPersonMontages::getBucketEmptyMontage, FirstPersonItemUpdateAnimations::shouldPlayBucketEmpty, 0));
    private static final List<Item> FULL_BUCKET_ITEMS = List.of(Items.WATER_BUCKET, Items.LAVA_BUCKET, Items.AXOLOTL_BUCKET, Items.COD_BUCKET, Items.POWDER_SNOW_BUCKET, Items.PUFFERFISH_BUCKET, Items.SALMON_BUCKET, Items.TADPOLE_BUCKET, Items.TROPICAL_FISH_BUCKET);

    private static boolean shouldPlayCrossbowFire(ItemUpdateAnimationConditionContext context) {
        boolean bothItemsAreCrossbows = context.bothItemsMeetPredicate(itemStack -> itemStack.has(DataComponents.CHARGED_PROJECTILES));
        if (!bothItemsAreCrossbows) {
            return false;
        }
        boolean currentCrossbowHasCharge = !((ChargedProjectiles)context.currentItem.get(DataComponents.CHARGED_PROJECTILES)).isEmpty();
        boolean previousCrossbowHasCharge = !((ChargedProjectiles)context.previousItem.get(DataComponents.CHARGED_PROJECTILES)).isEmpty();
        return !currentCrossbowHasCharge && previousCrossbowHasCharge;
    }

    private static boolean shouldPlayBucketCollect(ItemUpdateAnimationConditionContext context) {
        boolean previousItemIsEmptyBucket = context.previousItem().is(Items.BUCKET);
        boolean currentItemIsCollectedBucket = FULL_BUCKET_ITEMS.contains(context.currentItem().getItem());
        return previousItemIsEmptyBucket && currentItemIsCollectedBucket;
    }

    private static boolean shouldPlayBucketEmpty(ItemUpdateAnimationConditionContext context) {
        boolean currentItemIsEmptyBucket = context.currentItem().is(Items.BUCKET);
        boolean previousItemIsCollectedBucket = FULL_BUCKET_ITEMS.contains(context.previousItem().getItem());
        return currentItemIsEmptyBucket && previousItemIsCollectedBucket;
    }

    public static Identifier register(Identifier identifier, ItemUpdateAnimationRule itemUpdateAnimationRule) {
        ITEM_UPDATE_ANIMATION_RULES_BY_IDENTIFIER.put(identifier, itemUpdateAnimationRule);
        return identifier;
    }

    public static void testForAndPlayItemUpdateAnimations(OnTickDriverContainer driverContainer, MontageManager montageManager, InteractionHand hand) {
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.HAS_DROPPED_ITEM)).booleanValue()) {
            return;
        }
        if (driverContainer.getDriver(FirstPersonDrivers.HOTBAR_SLOT).hasValueChanged()) {
            return;
        }
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.HAS_SCREEN_OPEN)).booleanValue()) {
            return;
        }
        ItemStack actualItem = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(hand)).getCurrentValue();
        ItemStack previousItem = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(hand)).getPreviousValue();
        ItemStack renderedItem = (ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand));
        ItemUpdateAnimationConditionContext context = new ItemUpdateAnimationConditionContext(actualItem, previousItem);
        Map sortedItemUpdateAnimationRules = ITEM_UPDATE_ANIMATION_RULES_BY_IDENTIFIER.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((ItemUpdateAnimationRule)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (Identifier ruleIdentifier : sortedItemUpdateAnimationRules.keySet()) {
            ItemUpdateAnimationRule rule = (ItemUpdateAnimationRule)sortedItemUpdateAnimationRules.get(ruleIdentifier);
            if (!rule.shouldPlayAnimation.test(context)) continue;
            LocomotionMain.DEBUG_LOGGER.info("Playing item update animation \"{}\"", (Object)ruleIdentifier);
            MontageConfiguration montage = rule.montageProvider.apply(hand);
            for (String slot : montage.slots()) {
                montageManager.interruptMontagesInSlot(slot, Transition.builder(TimeSpan.ofSeconds(0.2f)).build());
            }
            montageManager.playMontage(rule.montageProvider.apply(hand));
            Identifier renderedItemHandPose = FirstPersonHandPoses.testForNextHandPose(renderedItem, hand);
            Identifier currentItemHandPose = FirstPersonHandPoses.testForNextHandPose(actualItem, hand);
            if (currentItemHandPose == renderedItemHandPose) {
                FirstPersonDrivers.updateRenderedItem(driverContainer, hand);
            }
            return;
        }
    }

    public record ItemUpdateAnimationConditionContext(ItemStack currentItem, ItemStack previousItem) {
        boolean bothItemsMeetPredicate(Predicate<ItemStack> predicate) {
            return predicate.test(this.currentItem) && predicate.test(this.previousItem);
        }
    }

    public record ItemUpdateAnimationRule(Function<InteractionHand, MontageConfiguration> montageProvider, Predicate<ItemUpdateAnimationConditionContext> shouldPlayAnimation, int evaluationPriority) {
        public static ItemUpdateAnimationRule of(Function<InteractionHand, MontageConfiguration> montageProvider, Predicate<ItemUpdateAnimationConditionContext> shouldPlayAnimation, int evaluationPriority) {
            return new ItemUpdateAnimationRule(montageProvider, shouldPlayAnimation, evaluationPriority);
        }
    }
}

