/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonJointAnimator;
import com.trainguy9512.locomotion.animation.joint.skeleton.BlendMask;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.BlendPosesFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionHand;

public class FirstPersonMap {
    public static PoseFunction<LocalSpacePose> blendAdditiveMovementIfHoldingMap(PoseFunction<LocalSpacePose> inputPose) {
        PoseFunction<LocalSpacePose> pose = inputPose;
        for (InteractionHand hand : InteractionHand.values()) {
            pose = FirstPersonMap.blendAdditiveMovementIfHoldingMapInHand(pose, hand);
        }
        return pose;
    }

    public static PoseFunction<LocalSpacePose> blendAdditiveMovementIfHoldingMapInHand(PoseFunction<LocalSpacePose> inputPose, InteractionHand hand) {
        BlendMask.Builder builder = BlendMask.builder();
        BlendMask blendMask = builder.defineForMultipleJoints(switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> FirstPersonJointAnimator.RIGHT_SIDE_JOINTS;
            case InteractionHand.OFF_HAND -> FirstPersonJointAnimator.LEFT_SIDE_JOINTS;
        }, 1.0f).build();
        return BlendPosesFunction.builder(inputPose).addBlendInput(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build(), context -> Float.valueOf(FirstPersonMap.getMapMovementAnimationWeight(context, hand)), blendMask).build();
    }

    public static float getMapMovementAnimationWeight(PoseFunction.FunctionEvaluationState context, InteractionHand hand) {
        Identifier handPose = (Identifier)context.driverContainer().getDriverValue(FirstPersonDrivers.getHandPoseDriver(hand));
        if (handPose == FirstPersonHandPoses.MAP) {
            return 1.0f - LocomotionMain.CONFIG.data().firstPersonPlayer.mapMovementAnimationIntensity;
        }
        return 0.0f;
    }
}

