/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.function.SequenceReferencePoint;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionHand;

public class FirstPersonMontages {
    public static final String MAIN_HAND_ATTACK_SLOT = "main_hand_attack";
    public static final String OFF_HAND_ATTACK_SLOT = "off_hand_attack";
    public static final String SHIELD_BLOCK_SLOT = "shield_block";
    public static final String SPEAR_CHARGE_SLOT = "spear_charge";
    public static final MontageConfiguration HAND_TOOL_ATTACK_PICKAXE_MONTAGE = MontageConfiguration.builder("hand_tool_attack_pickaxe", FirstPersonAnimationSequences.HAND_TOOL_PICKAXE_ATTACK).playsInSlot("main_hand_attack").setCooldownDuration(TimeSpan.of60FramesPerSecond(3.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(40.0f)).setEasement(Easing.SINE_IN_OUT).build()).makeAdditive(FirstPersonMontages::getBaseHandPose, SequenceReferencePoint.END).build();
    public static final MontageConfiguration HAND_TOOL_ATTACK_AXE_MONTAGE = MontageConfiguration.builder("hand_tool_attack_axe", FirstPersonAnimationSequences.HAND_TOOL_AXE_ATTACK).playsInSlot("main_hand_attack").setCooldownDuration(TimeSpan.of60FramesPerSecond(3.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(15.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration HAND_MACE_ATTACK_MONTAGE = MontageConfiguration.builder("hand_mace_attack", FirstPersonAnimationSequences.HAND_MACE_ATTACK).playsInSlot("main_hand_attack").setCooldownDuration(TimeSpan.of60FramesPerSecond(3.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(30.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration HAND_TRIDENT_JAB_MONTAGE = MontageConfiguration.builder("hand_trident_jab", FirstPersonAnimationSequences.HAND_TRIDENT_JAB).playsInSlot("main_hand_attack").setCooldownDuration(TimeSpan.of60FramesPerSecond(3.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(30.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration HAND_SPEAR_JAB_MONTAGE = MontageConfiguration.builder("hand_spear_jab", FirstPersonAnimationSequences.HAND_SPEAR_JAB).playsInSlot("main_hand_attack").setCooldownDuration(TimeSpan.of60FramesPerSecond(3.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration USE_MAIN_HAND_MONTAGE = MontageConfiguration.builder("hand_use_main_hand", FirstPersonAnimationSequences.HAND_TOOL_USE).playsInSlot("main_hand_attack").setCooldownDuration(TimeSpan.of60FramesPerSecond(5.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(3.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(16.0f)).setEasement(Easing.SINE_IN_OUT).build()).makeAdditive(FirstPersonMontages::getBaseHandPose, SequenceReferencePoint.END).build();
    public static final MontageConfiguration USE_OFF_HAND_MONTAGE = USE_MAIN_HAND_MONTAGE.makeBuilderCopy("hand_use_off_hand", USE_MAIN_HAND_MONTAGE.animationSequence()).playsInSlot("off_hand_attack").makeAdditive(FirstPersonMontages::getBaseHandPose, SequenceReferencePoint.END).build();
    public static final MontageConfiguration SHIELD_BLOCK_IMPACT_MONTAGE = MontageConfiguration.builder("shield_block_impact", FirstPersonAnimationSequences.HAND_SHIELD_IMPACT).playsInSlot("shield_block").setCooldownDuration(TimeSpan.of60FramesPerSecond(5.0f)).setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_IN_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(8.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration AXE_SCRAPE_MAIN_HAND_MONTAGE = MontageConfiguration.builder("axe_scrape_main_hand", FirstPersonAnimationSequences.HAND_TOOL_AXE_SCRAPE).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration AXE_SCRAPE_OFF_HAND_MONTAGE = AXE_SCRAPE_MAIN_HAND_MONTAGE.makeBuilderCopy("axe_scrape_off_hand", FirstPersonAnimationSequences.HAND_TOOL_AXE_SCRAPE).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration HOE_TILL_MAIN_HAND_MONTAGE = MontageConfiguration.builder("hoe_till_main_hand", FirstPersonAnimationSequences.HAND_TOOL_HOE_TILL).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration HOE_TILL_OFF_HAND_MONTAGE = HOE_TILL_MAIN_HAND_MONTAGE.makeBuilderCopy("hoe_till_off_hand", FirstPersonAnimationSequences.HAND_TOOL_HOE_TILL).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration SHOVEL_FLATTEN_MAIN_HAND_MONTAGE = MontageConfiguration.builder("shovel_flatten_main_hand", FirstPersonAnimationSequences.HAND_TOOL_SHOVEL_FLATTEN).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration SHOVEL_FLATTEN_OFF_HAND_MONTAGE = SHOVEL_FLATTEN_MAIN_HAND_MONTAGE.makeBuilderCopy("shoven_flatten_off_hand", FirstPersonAnimationSequences.HAND_TOOL_SHOVEL_FLATTEN).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration SHEARS_USE_MAIN_HAND_MONTAGE = MontageConfiguration.builder("shears_use_main_hand", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_SHEARS_USE).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration SHEARS_USE_OFF_HAND_MONTAGE = SHEARS_USE_MAIN_HAND_MONTAGE.makeBuilderCopy("shears_use_off_hand", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_SHEARS_USE).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration BUCKET_COLLECT_MAIN_HAND_MONTAGE = MontageConfiguration.builder("bucket_collect_main_hand", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_BUCKET_COLLECT).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration BUCKET_COLLECT_OFF_HAND_MONTAGE = BUCKET_COLLECT_MAIN_HAND_MONTAGE.makeBuilderCopy("bucket_collect_off_hand", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_BUCKET_COLLECT).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration BUCKET_EMPTY_MAIN_HAND_MONTAGE = MontageConfiguration.builder("bucket_empty_main_hand", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_BUCKET_EMPTY).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration BUCKET_EMPTY_OFF_HAND_MONTAGE = BUCKET_EMPTY_MAIN_HAND_MONTAGE.makeBuilderCopy("bucket_empty_off_hand", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_BUCKET_EMPTY).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration CROSSBOW_FIRE_MAIN_HAND_MONTAGE = MontageConfiguration.builder("crossbow_fire_main_hand", FirstPersonAnimationSequences.HAND_CROSSBOW_FIRE).playsInSlot("main_hand_attack").setTransitionIn(Transition.builder(TimeSpan.of60FramesPerSecond(3.0f)).setEasement(Easing.SINE_OUT).build()).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();
    public static final MontageConfiguration CROSSBOW_FIRE_OFF_HAND_MONTAGE = CROSSBOW_FIRE_MAIN_HAND_MONTAGE.makeBuilderCopy("crossbow_fire_off_hand", FirstPersonAnimationSequences.HAND_CROSSBOW_FIRE).playsInSlot("off_hand_attack").build();
    public static final MontageConfiguration SPEAR_CHARGE_IMPACT_MONTAGE = MontageConfiguration.builder("spear_charge_impact", FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_IMPACT).playsInSlot("spear_charge").setTransitionIn(Transition.INSTANT).setTransitionOut(Transition.builder(TimeSpan.of60FramesPerSecond(30.0f)).setEasement(Easing.SINE_IN_OUT).build()).build();

    public static String getAttackSlot(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? MAIN_HAND_ATTACK_SLOT : OFF_HAND_ATTACK_SLOT;
    }

    public static Identifier getBaseHandPose(OnTickDriverContainer driverContainer) {
        Identifier handPose = (Identifier)driverContainer.getDriverValue(FirstPersonDrivers.MAIN_HAND_POSE);
        if (handPose == FirstPersonHandPoses.GENERIC_ITEM) {
            return FirstPersonGenericItems.getOrThrowFromIdentifier((Identifier)driverContainer.getDriverValue(FirstPersonDrivers.MAIN_HAND_GENERIC_ITEM_POSE)).basePoseSequence();
        }
        return FirstPersonHandPoses.getOrThrowFromIdentifier(handPose).basePoseSequence();
    }

    public static MontageConfiguration getCrossbowFireMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> CROSSBOW_FIRE_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> CROSSBOW_FIRE_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getUseAnimationMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> USE_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> USE_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getAxeScrapeMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> AXE_SCRAPE_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> AXE_SCRAPE_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getHoeTillMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> HOE_TILL_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> HOE_TILL_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getShovelFlattenMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> SHOVEL_FLATTEN_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> SHOVEL_FLATTEN_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getShearsUseMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> SHEARS_USE_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> SHEARS_USE_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getBucketCollectMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> BUCKET_COLLECT_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> BUCKET_COLLECT_OFF_HAND_MONTAGE;
        };
    }

    public static MontageConfiguration getBucketEmptyMontage(InteractionHand hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> BUCKET_EMPTY_MAIN_HAND_MONTAGE;
            case InteractionHand.OFF_HAND -> BUCKET_EMPTY_OFF_HAND_MONTAGE;
        };
    }

    public static void playAttackMontage(OnTickDriverContainer driverContainer, MontageManager montageManager) {
    }
}

