/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMining;
import com.trainguy9512.locomotion.animation.driver.DriverKey;
import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateMachineFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Set;
import net.minecraft.world.InteractionHand;

public class FirstPersonTrident {
    public static final String TRIDENT_IDLE_STATE = "idle";
    public static final String TRIDENT_CHARGE_THROW_STATE = "charge_throw";
    public static final String TRIDENT_RIPTIDE_STATE = "riptide";
    public static final String TRIDENT_RIPTIDE_END_STATE = "riptide_end";

    private static String getTridentEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        return TRIDENT_IDLE_STATE;
    }

    public static PoseFunction<LocalSpacePose> handTridentPoseFunction(CachedPoseContainer cachedPoseContainer, InteractionHand hand) {
        DriverKey<VariableDriver<Boolean>> usingItemDriverKey = FirstPersonDrivers.getUsingItemDriver(hand);
        PoseFunction<LocalSpacePose> tridentStateMachine = StateMachineFunction.builder(FirstPersonTrident::getTridentEntryState).resetsUponRelevant(true).defineState(StateDefinition.builder(TRIDENT_IDLE_STATE, FirstPersonMining.makeMainHandPickaxeMiningPoseFunction(cachedPoseContainer, hand)).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(TRIDENT_CHARGE_THROW_STATE, SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_CHARGE_THROW).build()).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(TRIDENT_RIPTIDE_END_STATE).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(usingItemDriverKey).negate()).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(15.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).defineState(StateDefinition.builder(TRIDENT_RIPTIDE_STATE, SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_RIPTIDE).build()).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(TRIDENT_RIPTIDE_END_STATE).isTakenOnAnimationFinished(1.0f).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.IS_IN_RIPTIDE).negate()).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(8.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(TRIDENT_RIPTIDE_END_STATE, SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_RIPTIDE_END).build()).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(TRIDENT_IDLE_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(8.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(TRIDENT_IDLE_STATE, TRIDENT_RIPTIDE_END_STATE, TRIDENT_RIPTIDE_STATE)).addOutboundTransition(StateTransition.builder(TRIDENT_CHARGE_THROW_STATE).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(usingItemDriverKey)).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(TRIDENT_IDLE_STATE, TRIDENT_RIPTIDE_END_STATE)).addOutboundTransition(StateTransition.builder(TRIDENT_RIPTIDE_STATE).isTakenIfTrue(context -> FirstPersonTrident.shouldPlayRiptideAnimation(context, hand)).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(2.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(60).build()).build()).build();
        return tridentStateMachine;
    }

    private static boolean shouldPlayRiptideAnimation(StateTransition.TransitionContext context, InteractionHand hand) {
        boolean isInRiptide = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_IN_RIPTIDE);
        InteractionHand lastUsedHand = (InteractionHand)context.driverContainer().getDriverValue(FirstPersonDrivers.LAST_USED_HAND);
        return isInRiptide && lastUsedHand == hand;
    }
}

