/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.joint.skeleton.BlendMask;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.pose.ComponentSpacePose;
import com.trainguy9512.locomotion.animation.pose.Pose;
import com.trainguy9512.locomotion.util.Interpolator;
import com.trainguy9512.locomotion.util.Transition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class LocalSpacePose
extends Pose {
    private LocalSpacePose(JointSkeleton jointSkeleton) {
        super(jointSkeleton);
    }

    private LocalSpacePose(Pose pose) {
        super(pose);
    }

    public static LocalSpacePose of(JointSkeleton jointSkeleton) {
        return new LocalSpacePose(jointSkeleton);
    }

    public static LocalSpacePose of(Pose pose) {
        return new LocalSpacePose(pose);
    }

    public ComponentSpacePose convertedToComponentSpace() {
        ComponentSpacePose pose = ComponentSpacePose.of(this);
        pose.convertChildrenJointsToComponentSpace(this.getJointSkeleton().getRootJoint(), new PoseStack());
        return pose;
    }

    public LocalSpacePose mirrored() {
        LocalSpacePose mirroredPose = new LocalSpacePose(this);
        this.jointChannels.keySet().forEach(joint -> {
            JointSkeleton.JointConfiguration configuration = this.getJointSkeleton().getJointConfiguration((String)joint);
            String mirrorJoint = configuration.mirrorJoint() != null ? configuration.mirrorJoint() : joint;
            JointChannel mirroredTransform = this.getJointChannel(mirrorJoint).mirrored();
            mirroredPose.setJointChannel((String)joint, mirroredTransform);
        });
        return mirroredPose;
    }

    public LocalSpacePose interpolated(LocalSpacePose other, float weight, LocalSpacePose destination) {
        return this.interpolated(other, weight, null, destination);
    }

    public LocalSpacePose interpolated(LocalSpacePose other, float weight, @Nullable BlendMask blendMask) {
        return this.interpolated(other, weight, blendMask, this);
    }

    public LocalSpacePose interpolated(LocalSpacePose other, float weight) {
        return this.interpolated(other, weight, this);
    }

    public LocalSpacePose interpolated(LocalSpacePose other, float weight, @Nullable BlendMask blendMask, LocalSpacePose destination) {
        if (weight == 0.0f) {
            return destination;
        }
        for (String customAttribute : this.jointSkeleton.getCustomAttributes()) {
            float attributeWeight = weight;
            if (blendMask != null) {
                attributeWeight *= ((Float)blendMask.getCustomAttributeProperty(customAttribute, this.jointSkeleton)).floatValue();
            }
            float customAttributeA = ((Float)this.customAttributes.get(customAttribute)).floatValue();
            float customAttributeB = ((Float)other.customAttributes.get(customAttribute)).floatValue();
            destination.customAttributes.put(customAttribute, Interpolator.FLOAT.interpolate(Float.valueOf(customAttributeA), Float.valueOf(customAttributeB), attributeWeight));
        }
        for (String joint : this.jointSkeleton.getJoints()) {
            float jointWeight = weight;
            if (blendMask != null) {
                jointWeight *= ((Float)blendMask.getJointProperty(joint, this.jointSkeleton)).floatValue();
            }
            if (jointWeight == 1.0f) {
                destination.setJointChannel(joint, other.getJointChannel(joint));
                continue;
            }
            destination.setJointChannel(joint, destination.getJointChannel(joint).interpolate(other.getJointChannel(joint), jointWeight));
        }
        return destination;
    }

    public LocalSpacePose interpolatedByTransition(LocalSpacePose other, float time, Transition transition, @Nullable BlendMask blendMask, LocalSpacePose destination) {
        if (time == 0.0f) {
            return destination;
        }
        for (String customAttribute : this.jointSkeleton.getCustomAttributes()) {
            float attributeTime = time;
            if (transition.blendProfile() != null) {
                attributeTime /= ((Float)transition.blendProfile().getCustomAttributeProperty(customAttribute, this.jointSkeleton)).floatValue();
                attributeTime = Mth.clamp((float)attributeTime, (float)0.0f, (float)1.0f);
            }
            attributeTime = transition.easement().ease(attributeTime);
            if (blendMask != null) {
                attributeTime *= ((Float)blendMask.getCustomAttributeProperty(customAttribute, this.jointSkeleton)).floatValue();
            }
            float customAttributeA = ((Float)this.customAttributes.get(customAttribute)).floatValue();
            float customAttributeB = ((Float)other.customAttributes.get(customAttribute)).floatValue();
            destination.customAttributes.put(customAttribute, Interpolator.FLOAT.interpolate(Float.valueOf(customAttributeA), Float.valueOf(customAttributeB), attributeTime));
        }
        for (String joint : this.jointSkeleton.getJoints()) {
            float jointTime = time;
            if (transition.blendProfile() != null) {
                jointTime /= ((Float)transition.blendProfile().getJointProperty(joint, this.jointSkeleton)).floatValue();
                jointTime = Mth.clamp((float)jointTime, (float)0.0f, (float)1.0f);
            }
            jointTime = transition.easement().ease(jointTime);
            if (blendMask != null) {
                jointTime *= ((Float)blendMask.getJointProperty(joint, this.jointSkeleton)).floatValue();
            }
            if (jointTime == 1.0f) {
                destination.setJointChannel(joint, other.getJointChannel(joint));
                continue;
            }
            destination.setJointChannel(joint, destination.getJointChannel(joint).interpolate(other.getJointChannel(joint), jointTime));
        }
        return destination;
    }

    public LocalSpacePose interpolatedByTransition(LocalSpacePose other, float time, Transition transition, @Nullable BlendMask blendMask) {
        return this.interpolatedByTransition(other, time, transition, blendMask, this);
    }

    public void multiply(LocalSpacePose other, JointChannel.TransformSpace transformSpace) {
        this.jointChannels.forEach((joint, channel) -> channel.multiply((JointChannel)other.jointChannels.get(joint), transformSpace, JointChannel.TransformType.ADD));
    }

    public void invert() {
        this.jointChannels.values().forEach(JointChannel::invert);
    }
}

