/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ApplyAdditiveFunction
implements PoseFunction<LocalSpacePose> {
    private final PoseFunction<LocalSpacePose> basePoseInput;
    private final PoseFunction<LocalSpacePose> additivePoseInput;
    private final Function<PoseFunction.FunctionInterpolationContext, Float> alphaFunction;

    public ApplyAdditiveFunction(PoseFunction<LocalSpacePose> basePoseInput, PoseFunction<LocalSpacePose> additivePoseInput, Function<PoseFunction.FunctionInterpolationContext, Float> alphaFunction) {
        this.basePoseInput = basePoseInput;
        this.additivePoseInput = additivePoseInput;
        this.alphaFunction = alphaFunction;
    }

    public static ApplyAdditiveFunction of(PoseFunction<LocalSpacePose> basePoseInput, PoseFunction<LocalSpacePose> additivePoseInput, Function<PoseFunction.FunctionInterpolationContext, Float> weightFunction) {
        return new ApplyAdditiveFunction(basePoseInput, additivePoseInput, weightFunction);
    }

    public static ApplyAdditiveFunction of(PoseFunction<LocalSpacePose> basePoseInput, PoseFunction<LocalSpacePose> additivePoseInput) {
        return new ApplyAdditiveFunction(basePoseInput, additivePoseInput, context -> Float.valueOf(1.0f));
    }

    @Override
    @NotNull
    public LocalSpacePose compute(PoseFunction.FunctionInterpolationContext context) {
        LocalSpacePose basePose = this.basePoseInput.compute(context);
        LocalSpacePose additivePose = this.additivePoseInput.compute(context);
        additivePose.multiply(basePose, JointChannel.TransformSpace.COMPONENT);
        additivePose.copyCustomAttributesFrom(basePose);
        float weight = this.alphaFunction.apply(context).floatValue();
        if (weight == 1.0f) {
            return additivePose;
        }
        if (weight == 0.0f) {
            return basePose;
        }
        return basePose.interpolated(additivePose, weight);
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
        this.basePoseInput.tick(evaluationState);
        this.additivePoseInput.tick(evaluationState);
    }

    @Override
    public PoseFunction<LocalSpacePose> wrapUnique() {
        return new ApplyAdditiveFunction(this.basePoseInput.wrapUnique(), this.additivePoseInput.wrapUnique(), this.alphaFunction);
    }

    @Override
    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> findCondition) {
        if (findCondition.test(this)) {
            return Optional.of(this);
        }
        Optional<PoseFunction<?>> test = this.basePoseInput.searchDownChainForMostRelevant(findCondition);
        if (test.isPresent()) {
            return test;
        }
        return this.additivePoseInput.searchDownChainForMostRelevant(findCondition);
    }
}

