/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.trainguy9512.locomotion.animation.driver.Driver;
import com.trainguy9512.locomotion.animation.driver.DriverKey;
import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.TimeBasedPoseFunction;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.util.TimeSpan;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BlendedSequencePlayerFunction
extends TimeBasedPoseFunction<LocalSpacePose> {
    private final TreeMap<Float, BlendSpace1DEntry> blendSpaceEntries;
    private final Function<PoseFunction.FunctionEvaluationState, Float> blendPositionFunction;
    private final VariableDriver<Float> blendPosition;

    private BlendedSequencePlayerFunction(Function<PoseFunction.FunctionEvaluationState, Boolean> isPlayingFunction, Function<PoseFunction.FunctionEvaluationState, Float> playRateFunction, TimeSpan resetStartTimeOffset, TreeMap<Float, BlendSpace1DEntry> blendSpaceEntries, Function<PoseFunction.FunctionEvaluationState, Float> blendPositionFunction) {
        super(isPlayingFunction, playRateFunction, resetStartTimeOffset);
        this.blendSpaceEntries = blendSpaceEntries;
        this.blendPositionFunction = blendPositionFunction;
        this.blendPosition = VariableDriver.ofFloat(() -> Float.valueOf(0.0f));
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
        float position = this.blendPositionFunction.apply(evaluationState).floatValue();
        this.blendPosition.pushCurrentToPrevious();
        this.blendPosition.setValue(Float.valueOf(position));
        this.isPlaying = (Boolean)this.isPlayingFunction.apply(evaluationState);
        this.playRate = this.isPlaying ? ((Float)this.playRateFunction.apply(evaluationState)).floatValue() * this.getPlayRateAtPosition(position) : 0.0f;
        super.updateTime(evaluationState);
    }

    private float getPlayRateAtPosition(float position) {
        Map.Entry<Float, BlendSpace1DEntry> floorEntry = this.blendSpaceEntries.floorEntry(Float.valueOf(position));
        Map.Entry<Float, BlendSpace1DEntry> ceilingEntry = this.blendSpaceEntries.ceilingEntry(Float.valueOf(position));
        if (floorEntry == null) {
            return ceilingEntry.getValue().playRate();
        }
        if (ceilingEntry == null) {
            return floorEntry.getValue().playRate();
        }
        if (floorEntry.getKey().equals(ceilingEntry.getKey())) {
            return floorEntry.getValue().playRate();
        }
        float relativeTime = (position - floorEntry.getKey().floatValue()) / (ceilingEntry.getKey().floatValue() - floorEntry.getKey().floatValue());
        return Mth.lerp((float)relativeTime, (float)floorEntry.getValue().playRate(), (float)ceilingEntry.getValue().playRate());
    }

    @Override
    @NotNull
    public LocalSpacePose compute(PoseFunction.FunctionInterpolationContext context) {
        float interpolatedPosition = this.blendPosition.getValueInterpolated(context.partialTicks()).floatValue();
        TimeSpan time = this.getInterpolatedTimeElapsed(context);
        Map.Entry<Float, BlendSpace1DEntry> floorEntry = this.blendSpaceEntries.floorEntry(Float.valueOf(interpolatedPosition));
        Map.Entry<Float, BlendSpace1DEntry> ceilingEntry = this.blendSpaceEntries.ceilingEntry(Float.valueOf(interpolatedPosition));
        if (floorEntry == null) {
            return AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), ceilingEntry.getValue().animationSequence(), time, true);
        }
        if (ceilingEntry == null) {
            return AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), floorEntry.getValue().animationSequence(), time, true);
        }
        if (floorEntry.getKey().equals(ceilingEntry.getKey())) {
            return AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), floorEntry.getValue().animationSequence(), time, true);
        }
        float relativeTime = (interpolatedPosition - floorEntry.getKey().floatValue()) / (ceilingEntry.getKey().floatValue() - floorEntry.getKey().floatValue());
        LocalSpacePose floorPose = AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), floorEntry.getValue().animationSequence(), time, true);
        LocalSpacePose ceilingPose = AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), ceilingEntry.getValue().animationSequence(), time, true);
        return floorPose.interpolated(ceilingPose, relativeTime);
    }

    @Override
    public PoseFunction<LocalSpacePose> wrapUnique() {
        return new BlendedSequencePlayerFunction(this.isPlayingFunction, this.playRateFunction, this.resetStartTimeOffset, this.blendSpaceEntries, this.blendPositionFunction);
    }

    @Override
    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> findCondition) {
        return findCondition.test(this) ? Optional.of(this) : Optional.empty();
    }

    public static Builder<?> builder(Function<PoseFunction.FunctionEvaluationState, Float> blendValueFunction) {
        return new Builder(blendValueFunction);
    }

    public static Builder<?> builder(DriverKey<? extends Driver<Float>> floatDriverKey) {
        return BlendedSequencePlayerFunction.builder((PoseFunction.FunctionEvaluationState evaluationState) -> (Float)evaluationState.driverContainer().getDriverValue(floatDriverKey));
    }

    private record BlendSpace1DEntry(Identifier animationSequence, float playRate) {
    }

    public static class Builder<B extends Builder<B>>
    extends TimeBasedPoseFunction.Builder<B> {
        private final TreeMap<Float, BlendSpace1DEntry> blendSpaceEntries = new TreeMap();
        private final Function<PoseFunction.FunctionEvaluationState, Float> blendValueFunction;

        private Builder(Function<PoseFunction.FunctionEvaluationState, Float> blendValueFunction) {
            this.blendValueFunction = blendValueFunction;
        }

        public B addEntry(float position, Identifier animationSequence, float playRate) {
            this.blendSpaceEntries.put(Float.valueOf(position), new BlendSpace1DEntry(animationSequence, playRate));
            return (B)this;
        }

        public B addEntry(float position, Identifier animationSequence) {
            return this.addEntry(position, animationSequence, 1.0f);
        }

        public BlendedSequencePlayerFunction build() {
            if (this.blendSpaceEntries.isEmpty()) {
                throw new IllegalArgumentException("Blend space player has no added entries.");
            }
            return new BlendedSequencePlayerFunction(this.isPlayingFunction, this.playRateFunction, this.resetStartTimeOffsetTicks, this.blendSpaceEntries, this.blendValueFunction);
        }
    }
}

