/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.AnimationPlayer;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceReferencePoint;
import com.trainguy9512.locomotion.animation.pose.function.TimeBasedPoseFunction;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.resource.LocomotionResources;
import com.trainguy9512.locomotion.util.TimeSpan;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class SequencePlayerFunction
extends TimeBasedPoseFunction<LocalSpacePose>
implements AnimationPlayer {
    private final Identifier animationSequence;
    private final boolean isLooping;
    private final boolean ignoredByRelevancyTest;
    private final Map<String, Consumer<PoseFunction.FunctionEvaluationState>> timeMarkerBindings;
    private final boolean isAdditive;
    private final SequenceReferencePoint additiveSubtractionReferencePoint;
    private LocalSpacePose additiveSubtractionPose;

    protected SequencePlayerFunction(Function<PoseFunction.FunctionEvaluationState, Boolean> isPlayingFunction, Function<PoseFunction.FunctionEvaluationState, Float> playRateFunction, TimeSpan resetStartTimeOffset, Identifier animationSequence, boolean isLooping, boolean ignoredByRelevancyTest, Map<String, Consumer<PoseFunction.FunctionEvaluationState>> timeMarkerBindings, boolean isAdditive, SequenceReferencePoint additiveSubtractionReferencePoint) {
        super(isPlayingFunction, playRateFunction, resetStartTimeOffset);
        this.animationSequence = animationSequence;
        this.isLooping = isLooping;
        this.timeMarkerBindings = timeMarkerBindings;
        this.additiveSubtractionReferencePoint = additiveSubtractionReferencePoint;
        this.ignoredByRelevancyTest = false;
        this.isAdditive = isAdditive;
    }

    @Override
    @NotNull
    public LocalSpacePose compute(PoseFunction.FunctionInterpolationContext context) {
        LocalSpacePose pose = AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), this.animationSequence, this.getInterpolatedTimeElapsed(context), this.isLooping);
        AnimationSequence sequence = LocomotionResources.getOrThrowAnimationSequence(this.animationSequence);
        if (!this.isAdditive) {
            return pose;
        }
        if (this.additiveSubtractionPose == null) {
            this.additiveSubtractionPose = AnimationSequence.samplePose(context.driverContainer().getJointSkeleton(), this.animationSequence, this.resetStartTimeOffset.interpolated(sequence.length(), this.additiveSubtractionReferencePoint.getProgressThroughSequence()), false);
            this.additiveSubtractionPose.invert();
        }
        pose.multiply(this.additiveSubtractionPose, JointChannel.TransformSpace.COMPONENT);
        return pose;
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
        super.tick(evaluationState);
        Set<String> timeMarkersToFire = LocomotionResources.getOrThrowAnimationSequence(this.animationSequence).getMarkersInRange(TimeSpan.ofTicks(((Float)this.ticksElapsed.getCurrentValue()).floatValue()), TimeSpan.ofTicks(((Float)this.ticksElapsed.getCurrentValue()).floatValue() + this.playRate), this.isLooping);
        for (String timeMarker : timeMarkersToFire) {
            if (!this.timeMarkerBindings.containsKey(timeMarker)) continue;
            this.timeMarkerBindings.get(timeMarker).accept(evaluationState);
        }
    }

    @Override
    public PoseFunction<LocalSpacePose> wrapUnique() {
        return new SequencePlayerFunction(this.isPlayingFunction, this.playRateFunction, this.resetStartTimeOffset, this.animationSequence, this.isLooping, this.ignoredByRelevancyTest, this.timeMarkerBindings, this.isAdditive, this.additiveSubtractionReferencePoint);
    }

    @Override
    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> findCondition) {
        return findCondition.test(this) && !this.ignoredByRelevancyTest ? Optional.of(this) : Optional.empty();
    }

    public static Builder<?> builder(Identifier animationSequence) {
        return new Builder(animationSequence);
    }

    @Override
    public Tuple<TimeSpan, TimeSpan> getRemainingTime() {
        float remainingTimeCurrently;
        float remainingTimePreviously;
        float lengthInTicks = LocomotionResources.getOrThrowAnimationSequence(this.animationSequence).length().inTicks();
        if (this.isLooping) {
            remainingTimePreviously = lengthInTicks - (((Float)this.ticksElapsed.getCurrentValue()).floatValue() - this.playRate) % lengthInTicks;
            remainingTimeCurrently = lengthInTicks - ((Float)this.ticksElapsed.getCurrentValue()).floatValue() % lengthInTicks;
        } else {
            remainingTimePreviously = lengthInTicks - Mth.clamp((float)(((Float)this.ticksElapsed.getCurrentValue()).floatValue() - this.playRate), (float)0.0f, (float)lengthInTicks);
            remainingTimeCurrently = lengthInTicks - Mth.clamp((float)((Float)this.ticksElapsed.getCurrentValue()).floatValue(), (float)0.0f, (float)lengthInTicks);
        }
        return new Tuple((Object)TimeSpan.ofTicks(remainingTimePreviously), (Object)TimeSpan.ofTicks(remainingTimeCurrently));
    }

    @Override
    public TimeSpan getAnimationLength() {
        return LocomotionResources.getOrThrowAnimationSequence(this.animationSequence).length();
    }

    public static class Builder<B extends Builder<B>>
    extends TimeBasedPoseFunction.Builder<B> {
        private final Identifier animationSequence;
        private boolean looping;
        private boolean ignoredForRelevancyTest;
        private final Map<String, Consumer<PoseFunction.FunctionEvaluationState>> timeMarkerBindings;
        private boolean isAdditive;
        private SequenceReferencePoint additiveSubtractionReferencePoint;

        protected Builder(Identifier animationSequence) {
            this.animationSequence = animationSequence;
            this.looping = false;
            this.ignoredForRelevancyTest = false;
            this.timeMarkerBindings = Maps.newHashMap();
            this.isAdditive = false;
            this.additiveSubtractionReferencePoint = SequenceReferencePoint.BEGINNING;
        }

        public B setLooping(boolean looping) {
            this.looping = looping;
            return (B)this;
        }

        public B bindToTimeMarker(String timeMarkerIdentifier, Consumer<PoseFunction.FunctionEvaluationState> binding) {
            this.timeMarkerBindings.computeIfPresent(timeMarkerIdentifier, (identifier, existingBinding) -> existingBinding.andThen(binding));
            this.timeMarkerBindings.putIfAbsent(timeMarkerIdentifier, binding);
            return (B)this;
        }

        public B ignoreForRelevancyTest() {
            this.ignoredForRelevancyTest = true;
            return (B)this;
        }

        public B isAdditive(boolean isAdditive, SequenceReferencePoint subtractionReferencePoint) {
            this.isAdditive = isAdditive;
            this.additiveSubtractionReferencePoint = subtractionReferencePoint;
            return (B)this;
        }

        public SequencePlayerFunction build() {
            return new SequencePlayerFunction(this.isPlayingFunction, this.playRateFunction, this.resetStartTimeOffsetTicks, this.animationSequence, this.looping, this.ignoredForRelevancyTest, this.timeMarkerBindings, this.isAdditive, this.additiveSubtractionReferencePoint);
        }
    }
}

