/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function.montage;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.joint.skeleton.BlendMask;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceReferencePoint;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;

public record MontageConfiguration(String identifier, List<String> slots, Identifier animationSequence, Function<OnTickDriverContainer, Float> playRateFunction, Map<String, Consumer<PoseFunction.FunctionEvaluationState>> timeMarkerBindings, @Nullable BlendMask blendMask, Transition transitionIn, Transition transitionOut, TimeSpan startTimeOffset, float transitionOutCrossfadeWeight, TimeSpan cooldownDuration, boolean isAdditive, Function<OnTickDriverContainer, Identifier> additiveBasePoseProvider, SequenceReferencePoint additiveReferencePosePoint) {
    public static Builder builder(String identifier, Identifier animationSequence) {
        return new Builder(identifier, animationSequence);
    }

    public Builder makeBuilderCopy(String identifier, Identifier animationSequence) {
        Builder builder = MontageConfiguration.builder(identifier, animationSequence).setPlayRate(this.playRateFunction).setBlendMask(this.blendMask).setTransitionIn(this.transitionIn).setTransitionOut(this.transitionOut).setStartTimeOffset(this.startTimeOffset).setTransitionOutCrossfadeWeight(this.transitionOutCrossfadeWeight).setCooldownDuration(this.cooldownDuration);
        for (String string : this.slots) {
            builder.playsInSlot(string);
        }
        for (Map.Entry entry : this.timeMarkerBindings.entrySet()) {
            builder.bindToTimeMarker((String)entry.getKey(), (Consumer)entry.getValue());
        }
        if (this.isAdditive) {
            builder.makeAdditive(this.additiveBasePoseProvider, this.additiveReferencePosePoint);
        }
        return builder;
    }

    public static class Builder {
        private final String identifier;
        private final Identifier animationSequence;
        private final List<String> slots;
        private Function<OnTickDriverContainer, Float> playRateFunction;
        private Map<String, Consumer<PoseFunction.FunctionEvaluationState>> timeMarkerBindings;
        private BlendMask blendMask;
        private Transition transitionIn;
        private Transition transitionOut;
        private TimeSpan startTimeOffset;
        private float transitionOutCrossfadeWeight;
        private TimeSpan cooldownDuration;
        private boolean isAdditive;
        private Function<OnTickDriverContainer, Identifier> additiveBasePoseProvider;
        private SequenceReferencePoint additiveReferencePosePoint;

        private Builder(String identifier, Identifier animationSequence) {
            this.identifier = identifier;
            this.animationSequence = animationSequence;
            this.slots = new ArrayList<String>();
            this.playRateFunction = driverContainer -> Float.valueOf(1.0f);
            this.timeMarkerBindings = Maps.newHashMap();
            this.blendMask = null;
            this.transitionIn = Transition.SINGLE_TICK;
            this.transitionOut = Transition.SINGLE_TICK;
            this.startTimeOffset = TimeSpan.ofSeconds(0.0f);
            this.transitionOutCrossfadeWeight = 1.0f;
            this.cooldownDuration = TimeSpan.ofTicks(0.0f);
            this.isAdditive = false;
            this.additiveBasePoseProvider = null;
            this.additiveReferencePosePoint = SequenceReferencePoint.BEGINNING;
        }

        public Builder playsInSlot(String slotIdentifier) {
            this.slots.clear();
            this.slots.add(slotIdentifier);
            return this;
        }

        public Builder playsInSlots(String ... slotIdentifiers) {
            this.slots.clear();
            this.slots.addAll(List.of(slotIdentifiers));
            return this;
        }

        public Builder setPlayRate(Function<OnTickDriverContainer, Float> playRate) {
            this.playRateFunction = playRate;
            return this;
        }

        public Builder setBlendMask(BlendMask blendMask) {
            this.blendMask = blendMask;
            return this;
        }

        public Builder setTransitionIn(Transition transitionIn) {
            this.transitionIn = transitionIn;
            return this;
        }

        public Builder setTransitionOut(Transition transitionOut) {
            this.transitionOut = transitionOut;
            return this;
        }

        public Builder bindToTimeMarker(String timeMarkerIdentifier, Consumer<PoseFunction.FunctionEvaluationState> binding) {
            this.timeMarkerBindings.computeIfPresent(timeMarkerIdentifier, (identifier, existingBinding) -> existingBinding.andThen(binding));
            this.timeMarkerBindings.putIfAbsent(timeMarkerIdentifier, binding);
            return this;
        }

        public Builder setStartTimeOffset(TimeSpan offset) {
            this.startTimeOffset = offset;
            return this;
        }

        public Builder setTransitionOutCrossfadeWeight(float weight) {
            this.transitionOutCrossfadeWeight = weight;
            return this;
        }

        public Builder setCooldownDuration(TimeSpan duration) {
            this.cooldownDuration = duration;
            return this;
        }

        public Builder makeAdditive(Function<OnTickDriverContainer, Identifier> additiveBasePoseProvider, SequenceReferencePoint additiveReferencePosePoint) {
            this.isAdditive = true;
            this.additiveBasePoseProvider = additiveBasePoseProvider;
            this.additiveReferencePosePoint = additiveReferencePosePoint;
            return this;
        }

        public MontageConfiguration build() {
            return new MontageConfiguration(this.identifier, this.slots, this.animationSequence, this.playRateFunction, this.timeMarkerBindings, this.blendMask, this.transitionIn, this.transitionOut, this.startTimeOffset, this.transitionOutCrossfadeWeight, this.cooldownDuration, this.isAdditive, this.additiveBasePoseProvider, this.additiveReferencePosePoint);
        }
    }
}

