/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function.statemachine;

import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record StateAlias(Set<String> originStates, List<StateTransition> outboundTransitions) {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/StateAlias");

    public static Builder builder(Set<String> originStates) {
        return new Builder(originStates);
    }

    public static class Builder {
        private final Set<String> originStates;
        private final List<StateTransition> outboundTransitions;

        private Builder(Set<String> originStates) {
            this.originStates = new HashSet<String>(originStates);
            this.outboundTransitions = new ArrayList<StateTransition>();
        }

        public final Builder addOriginatingStates(Set<String> states) {
            this.originStates.addAll(states);
            return this;
        }

        public final Builder addOriginatingState(String state) {
            this.originStates.add(state);
            return this;
        }

        public Builder addOutboundTransition(StateTransition transition) {
            if (this.originStates.contains(transition.target())) {
                LOGGER.warn("Cannot add state transition to state {} from state alias that contains it already: {}", (Object)transition.target(), this.originStates);
            }
            this.outboundTransitions.add(transition);
            return this;
        }

        public StateAlias build() {
            return new StateAlias(this.originStates, this.outboundTransitions);
        }
    }
}

