/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function.statemachine;

import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.driver.Driver;
import com.trainguy9512.locomotion.animation.driver.DriverKey;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.AnimationPlayer;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public record StateTransition(String target, Predicate<TransitionContext> conditionPredicate, Transition transition, int priority, Consumer<PoseFunction.FunctionEvaluationState> onTransitionTakenListener, boolean isAutomaticTransition) implements Comparable<StateTransition>
{
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/StateTransition");
    public static final Predicate<TransitionContext> ALWAYS_TRUE = transitionContext -> true;
    public static final Predicate<TransitionContext> CURRENT_TRANSITION_FINISHED = transitionContext -> transitionContext.currentStateWeight() == 1.0f && transitionContext.previousStateWeight() == 1.0f;
    public static final Predicate<TransitionContext> MOST_RELEVANT_ANIMATION_PLAYER_IS_FINISHING = StateTransition.makeMostRelevantAnimationPlayerFinishedCondition(1.0f);
    public static final Predicate<TransitionContext> MOST_RELEVANT_ANIMATION_PLAYER_HAS_FINISHED = StateTransition.makeMostRelevantAnimationPlayerFinishedCondition(0.0f);

    public static <D extends Driver<Boolean>> Predicate<TransitionContext> takeIfBooleanDriverTrue(DriverKey<D> booleanDriverKey) {
        return transitionContext -> (Boolean)transitionContext.driverContainer.getDriverValue(booleanDriverKey);
    }

    public static Predicate<TransitionContext> takeIfTimeInStateLessThan(TimeSpan time) {
        return context -> context.timeElapsedInCurrentState().inTicks() < time.inTicks();
    }

    public static Predicate<TransitionContext> takeIfTimeInStateGreaterThan(TimeSpan time) {
        return context -> context.timeElapsedInCurrentState().inTicks() > time.inTicks();
    }

    public static Predicate<TransitionContext> makeMostRelevantAnimationPlayerFinishedCondition(float crossFadeWeight) {
        return transitionContext -> {
            Optional<AnimationPlayer> potentialPlayer = transitionContext.findMostRelevantAnimationPlayer();
            if (potentialPlayer.isPresent()) {
                AnimationPlayer player = potentialPlayer.get();
                float transitionTimeTicks = transitionContext.transitionDuration().inTicks() * crossFadeWeight;
                Tuple<TimeSpan, TimeSpan> remainingTime = player.getRemainingTime();
                if (((TimeSpan)remainingTime.getA()).inTicks() > ((TimeSpan)remainingTime.getB()).inTicks()) {
                    return transitionTimeTicks < ((TimeSpan)remainingTime.getA()).inTicks() && transitionTimeTicks >= ((TimeSpan)remainingTime.getB()).inTicks();
                }
                if (((TimeSpan)remainingTime.getA()).inTicks() < ((TimeSpan)remainingTime.getB()).inTicks()) {
                    return transitionTimeTicks < ((TimeSpan)remainingTime.getA()).inTicks();
                }
            }
            return false;
        };
    }

    public static Builder builder(String target) {
        return new Builder(target);
    }

    @Override
    public int compareTo(@NotNull StateTransition other) {
        return Integer.compare(other.priority(), this.priority());
    }

    public static class Builder {
        private final String target;
        private Predicate<TransitionContext> conditionPredicate = null;
        private Transition transition;
        private int priority;
        private Consumer<PoseFunction.FunctionEvaluationState> onTransitionTakenListener;
        private boolean canInterruptOtherTransitions;
        private boolean automaticTransition;
        private float automaticTransitionCrossfadeWeight;

        private Builder(String target) {
            this.target = target;
            this.transition = Transition.SINGLE_TICK;
            this.priority = 50;
            this.onTransitionTakenListener = evaluationState -> {};
            this.canInterruptOtherTransitions = true;
            this.automaticTransition = false;
            this.automaticTransitionCrossfadeWeight = 1.0f;
        }

        public Builder setCanInterruptOtherTransitions(boolean canInterruptOtherTransitions) {
            this.canInterruptOtherTransitions = canInterruptOtherTransitions;
            return this;
        }

        public Builder isTakenOnAnimationFinished(float crossFadeWeight) {
            this.automaticTransition = true;
            this.automaticTransitionCrossfadeWeight = crossFadeWeight;
            return this;
        }

        public final Builder isTakenIfTrue(Predicate<TransitionContext> conditionPredicate) {
            this.conditionPredicate = conditionPredicate;
            return this;
        }

        public Builder setTiming(Transition transition) {
            this.transition = transition;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder bindToOnTransitionTaken(Consumer<PoseFunction.FunctionEvaluationState> onTransitionTaken) {
            this.onTransitionTakenListener = this.onTransitionTakenListener.andThen(onTransitionTaken);
            return this;
        }

        public StateTransition build() {
            if (this.conditionPredicate == null) {
                this.conditionPredicate = context -> false;
                if (!this.automaticTransition) {
                    LOGGER.warn("State transition to target {}.{} has no passable conditions, and will go unused.", (Object)this.target.getClass().getSimpleName(), (Object)this.target);
                }
            }
            if (!this.canInterruptOtherTransitions) {
                this.conditionPredicate = this.conditionPredicate.and(CURRENT_TRANSITION_FINISHED);
            }
            if (this.automaticTransition) {
                this.conditionPredicate = this.conditionPredicate.or(StateTransition.makeMostRelevantAnimationPlayerFinishedCondition(this.automaticTransitionCrossfadeWeight));
            }
            return new StateTransition(this.target, this.conditionPredicate, this.transition, this.priority, this.onTransitionTakenListener, this.automaticTransition);
        }
    }

    public record TransitionContext(OnTickDriverContainer driverContainer, TimeSpan timeElapsedInCurrentState, float currentStateWeight, float previousStateWeight, PoseFunction<LocalSpacePose> currentStateInput, TimeSpan transitionDuration) {
        public static TransitionContext of(OnTickDriverContainer dataContainer, TimeSpan timeElapsedInCurrentState, float currentStateWeight, float previousStateWeight, PoseFunction<LocalSpacePose> currentStateInput, TimeSpan transitionDuration) {
            return new TransitionContext(dataContainer, timeElapsedInCurrentState, currentStateWeight, previousStateWeight, currentStateInput, transitionDuration);
        }

        public Optional<AnimationPlayer> findMostRelevantAnimationPlayer() {
            Optional<PoseFunction<?>> foundPoseFunction = this.currentStateInput.searchDownChainForMostRelevant(poseFunction -> poseFunction instanceof AnimationPlayer);
            return foundPoseFunction.map(poseFunction -> (AnimationPlayer)((Object)poseFunction));
        }
    }
}

