/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.debug;

import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.driver.Driver;
import com.trainguy9512.locomotion.animation.driver.DriverKey;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class DebugEntryFirstPersonDrivers
implements DebugScreenEntry {
    private static final Identifier GROUP = Identifier.fromNamespaceAndPath((String)"locomotion", (String)"locomotion");

    public void display(DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk clientChunk, @Nullable LevelChunk serverChunk) {
        displayer.addToGroup(GROUP, "First Person Drivers");
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> {
            List<Map.Entry> sortedDrivers = dataContainer.getAllDrivers().entrySet().stream().sorted(Comparator.comparing(entry -> ((DriverKey)entry.getKey()).getIdentifier())).toList();
            for (Map.Entry entry2 : sortedDrivers) {
                String driverName = ((DriverKey)entry2.getKey()).getIdentifier();
                String driverValue = ((Driver)entry2.getValue()).getChatFormattedString();
                String lineString = driverName + ":    " + driverValue;
                displayer.addToGroup(GROUP, lineString);
            }
        });
    }
}

