/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.mixin.game;

import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonUseAnimations;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft {
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    private volatile boolean pause;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;

    @Shadow
    protected abstract boolean isLevelRunningNormally();

    @Shadow
    public abstract CompletableFuture<Void> delayTextureReload();

    @Inject(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V")})
    public void playItemDropAnimation(CallbackInfo ci) {
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> dataContainer.getDriver(FirstPersonDrivers.HAS_DROPPED_ITEM).trigger());
    }

    @Inject(method={"handleKeybinds()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getConnection()Lnet/minecraft/client/multiplayer/ClientPacketListener;", ordinal=0)})
    public void playSwapItemAnimation(CallbackInfo ci) {
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> dataContainer.getDriver(FirstPersonDrivers.HAS_SWAPPED_ITEMS).trigger());
    }

    @Inject(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V")})
    public void injectStartAttackMiss(CallbackInfoReturnable<Boolean> cir) {
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> dataContainer.getDriver(FirstPersonDrivers.HAS_ATTACKED).trigger());
    }

    @Inject(method={"startUseItem()V"}, at={@At(value="HEAD")})
    public void injectOnSwingPlayerHandWhenBeginningUse(CallbackInfo ci) {
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(FirstPersonUseAnimations::updateUseAnimationHitResults);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;animateTick(III)V")})
    private void locomotionTick(CallbackInfo ci) {
        assert (this.level != null);
        JointAnimatorDispatcher jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
        jointAnimatorDispatcher.tickEntityJointAnimators(this.level.entitiesForRendering());
        jointAnimatorDispatcher.tickFirstPersonPlayerJointAnimator();
    }
}

