/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.mixin.render;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHookRenderer.class})
public abstract class MixinFishingHookRenderer {
    @Shadow
    public static HumanoidArm getHoldingArm(Player player) {
        return null;
    }

    @Inject(method={"getPlayerHandPos(Lnet/minecraft/world/entity/player/Player;FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectLocomotionFishingHookPosition(Player player, float handAngle, float partialTick, CallbackInfoReturnable<Vec3> cir) {
        if (LocomotionMain.CONFIG.data().firstPersonPlayer.enableRenderer) {
            EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            if (entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
                JointAnimatorDispatcher jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
                jointAnimatorDispatcher.getFirstPersonPlayerDataContainer().flatMap(dataContainer -> jointAnimatorDispatcher.getInterpolatedFirstPersonPlayerPose()).ifPresent(animationPose -> {
                    float fovScale = 0.0f;
                    fovScale = (float)((Integer)entityRenderDispatcher.options.fov().get()).intValue() * 0.011219974f;
                    fovScale = (float)Math.tan(fovScale);
                    fovScale = ((Integer)entityRenderDispatcher.options.fov().get()).intValue();
                    fovScale = 2.0408163E-4f * (fovScale * fovScale);
                    assert (entityRenderDispatcher.camera != null);
                    HumanoidArm fishingRodArm = MixinFishingHookRenderer.getHoldingArm(player);
                    String itemJoint = fishingRodArm == HumanoidArm.LEFT ? "item_L_jnt" : "item_R_jnt";
                    Matrix4f itemTransform = new Matrix4f().scale(0.0625f).scale(1.0f, -1.0f, -1.0f).mul((Matrix4fc)animationPose.getJointChannel(itemJoint).getTransform()).translate(0.0f, 10.0f, 5.0f);
                    float playerRotationX = player.getXRot(partialTick) * ((float)Math.PI / 180);
                    float playerRotationY = player.getYRot(partialTick) * ((float)(-Math.PI) / 180);
                    Quaternionf playerRotation = new Quaternionf().rotateY(playerRotationY).rotateX(playerRotationX);
                    Matrix4f playerTransform = new Matrix4f().translate((Vector3fc)entityRenderDispatcher.camera.position().toVector3f()).rotate((Quaternionfc)playerRotation);
                    Matrix4f cameraCenterTransform = new Matrix4f().scale(0.0625f).scale(1.0f, -1.0f, -1.0f).mul((Matrix4fc)animationPose.getJointChannel("camera_jnt").getTransform()).translate(0.0f, 0.0f, -5.0f);
                    Vector3f cameraPosition = entityRenderDispatcher.camera.position().add(player.getEyePosition(partialTick)).toVector3f();
                    Quaternionf cameraRotation = entityRenderDispatcher.camera.rotation();
                    Matrix4f cameraTransform = new Matrix4f().translate((Vector3fc)cameraPosition);
                    Matrix4f blendedFovItemTransform = cameraCenterTransform.lerp((Matrix4fc)itemTransform, fovScale);
                    Vector3f fishingLinePosition = playerTransform.translate((Vector3fc)blendedFovItemTransform.getTranslation(new Vector3f())).rotate((Quaternionfc)blendedFovItemTransform.getNormalizedRotation(new Quaternionf())).getTranslation(new Vector3f());
                    cir.setReturnValue((Object)new Vec3((Vector3fc)fishingLinePosition));
                });
            }
        }
    }
}

