/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.trainguy9512.locomotion.access.FirstPersonSingleBlockRenderer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class FirstPersonBlockItemRenderer {
    private static List<BlockRenderConfiguration> BLOCK_RENDER_CONFIGURATIONS = new ArrayList<BlockRenderConfiguration>();

    public static void register(BlockRenderConfiguration blockRenderConfiguration) {
        BLOCK_RENDER_CONFIGURATIONS.add(blockRenderConfiguration);
        BLOCK_RENDER_CONFIGURATIONS = new ArrayList<BlockRenderConfiguration>(BLOCK_RENDER_CONFIGURATIONS.stream().sorted(Comparator.comparingInt(BlockRenderConfiguration::evaluationPriority).reversed()).toList());
    }

    public static void renderSingleBlock(BlockSubmitContext context) {
        FirstPersonBlockItemRenderer.submitSingleBlock(context.nodeCollector(), context.poseStack(), context.blockState(), context.combinedLight());
    }

    public static void renderDoorBlock(BlockSubmitContext context) {
        FirstPersonBlockItemRenderer.submitSingleBlock(context.nodeCollector(), context.poseStack(), context.blockState(), context.combinedLight());
        FirstPersonBlockItemRenderer.renderUpperHalfBlock(context);
    }

    private static void renderUpperHalfBlock(BlockSubmitContext context) {
        context.poseStack().translate(0.0f, 1.0f, 0.0f);
        BlockState upperHalfBlockstate = (BlockState)context.blockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
        FirstPersonBlockItemRenderer.submitSingleBlock(context.nodeCollector(), context.poseStack(), upperHalfBlockstate, context.combinedLight());
    }

    public static void submit(ItemStack itemStack, PoseStack poseStack, SubmitNodeCollector nodeCollector, int combinedLight, HumanoidArm side) {
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (side == HumanoidArm.LEFT) {
            poseStack.translate(-1.0f, 0.0f, 0.0f);
        }
        Block block = blockItem.getBlock();
        BlockState blockState = block.defaultBlockState();
        for (BlockRenderConfiguration configuration : BLOCK_RENDER_CONFIGURATIONS) {
            if (!configuration.shouldChoose().test(block)) continue;
            configuration.renderer.accept(new BlockSubmitContext(blockState, poseStack, nodeCollector, combinedLight, side));
            return;
        }
    }

    private static void submitSingleBlock(SubmitNodeCollector nodeCollector, PoseStack poseStack, BlockState blockState, int combinedLight) {
        ((FirstPersonSingleBlockRenderer)Minecraft.getInstance().getBlockRenderer()).locomotion$submitSingleBlockWithEmission(blockState, poseStack, nodeCollector, combinedLight);
    }

    static {
        FirstPersonBlockItemRenderer.register(BlockRenderConfiguration.of(FirstPersonBlockItemRenderer::renderSingleBlock, block -> true, 0));
        FirstPersonBlockItemRenderer.register(BlockRenderConfiguration.of(FirstPersonBlockItemRenderer::renderDoorBlock, block -> block instanceof DoorBlock, 10));
    }

    public record BlockSubmitContext(BlockState blockState, PoseStack poseStack, SubmitNodeCollector nodeCollector, int combinedLight, HumanoidArm side) {
    }

    public record BlockRenderConfiguration(Consumer<BlockSubmitContext> renderer, Predicate<Block> shouldChoose, int evaluationPriority) {
        public static BlockRenderConfiguration of(Consumer<BlockSubmitContext> renderer, Predicate<Block> shouldChoose, int evaluationPriority) {
            return new BlockRenderConfiguration(renderer, shouldChoose, evaluationPriority);
        }
    }
}

