/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.trainguy9512.locomotion.access.FirstPersonSingleBlockRenderer;
import com.trainguy9512.locomotion.access.MatrixModelPart;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.render.FirstPersonBlockItemRenderer;
import com.trainguy9512.locomotion.render.ItemRenderType;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.player.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FirstPersonPlayerRenderer
implements RenderLayerParent<AvatarRenderState, PlayerModel> {
    private final Minecraft minecraft;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockRenderer;
    private final ItemModelResolver itemModelResolver;
    private final JointAnimatorDispatcher jointAnimatorDispatcher;
    public static boolean IS_RENDERING_LOCOMOTION_FIRST_PERSON = false;
    public static boolean SHOULD_FLIP_ITEM_TRANSFORM = false;
    public static InteractionHand CURRENT_ITEM_INTERACTION_HAND = InteractionHand.MAIN_HAND;
    public static float CURRENT_PARTIAL_TICKS = 0.0f;
    private static final RenderType MAP_BACKGROUND = RenderTypes.text((Identifier)Identifier.withDefaultNamespace((String)"textures/map/map_background.png"));
    private static final RenderType MAP_BACKGROUND_CHECKERBOARD = RenderTypes.text((Identifier)Identifier.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png"));
    private final MapRenderState mapRenderState = new MapRenderState();

    public FirstPersonPlayerRenderer(EntityRendererProvider.Context context) {
        this.minecraft = Minecraft.getInstance();
        this.entityRenderDispatcher = context.getEntityRenderDispatcher();
        this.itemRenderer = this.minecraft.getItemRenderer();
        this.blockRenderer = context.getBlockRenderDispatcher();
        this.itemModelResolver = context.getItemModelResolver();
        this.jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
    }

    public void render(float partialTicks, PoseStack poseStack, SubmitNodeCollector nodeCollector, LocalPlayer player, int combinedLight) {
        CURRENT_PARTIAL_TICKS = partialTicks;
        JointAnimatorDispatcher jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> jointAnimatorDispatcher.getInterpolatedFirstPersonPlayerPose().ifPresent(animationPose -> {
            JointChannel rightArmPose = animationPose.getJointChannel("arm_R_jnt");
            JointChannel leftArmPose = animationPose.getJointChannel("arm_L_jnt");
            JointChannel rightItemPose = animationPose.getJointChannel("item_R_jnt");
            JointChannel leftItemPose = animationPose.getJointChannel("item_L_jnt");
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            AvatarRenderer playerRenderer = this.entityRenderDispatcher.getPlayerRenderer((AbstractClientPlayer)player);
            PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
            playerModel.resetPose();
            ((MatrixModelPart)playerModel.rightArm).locomotion$setMatrix(rightArmPose.getTransform());
            ((MatrixModelPart)playerModel.leftArm).locomotion$setMatrix(leftArmPose.getTransform());
            playerModel.body.visible = false;
            this.renderArm((AbstractClientPlayer)player, playerModel, HumanoidArm.LEFT, poseStack, nodeCollector, combinedLight);
            this.renderArm((AbstractClientPlayer)player, playerModel, HumanoidArm.RIGHT, poseStack, nodeCollector, combinedLight);
            boolean leftHanded = this.minecraft.options.mainHand().get() == HumanoidArm.LEFT;
            Identifier leftHandGenericItemPoseIdentifier = (Identifier)dataContainer.getDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(leftHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            Identifier rightHandGenericItemPoseIdentifier = (Identifier)dataContainer.getDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(!leftHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            FirstPersonGenericItems.GenericItemPoseDefinition leftHandGenericItemPoseDefinition = FirstPersonGenericItems.getOrThrowFromIdentifier(leftHandGenericItemPoseIdentifier);
            FirstPersonGenericItems.GenericItemPoseDefinition rightHandGenericItemPoseDefinition = FirstPersonGenericItems.getOrThrowFromIdentifier(rightHandGenericItemPoseIdentifier);
            Identifier leftHandPoseIdentifier = (Identifier)dataContainer.getDriverValue(FirstPersonDrivers.getHandPoseDriver(leftHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            Identifier rightHandPoseIdentifier = (Identifier)dataContainer.getDriverValue(FirstPersonDrivers.getHandPoseDriver(!leftHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            FirstPersonHandPoses.HandPoseDefinition leftHandPose = FirstPersonHandPoses.getOrThrowFromIdentifier(leftHandPoseIdentifier);
            FirstPersonHandPoses.HandPoseDefinition rightHandPose = FirstPersonHandPoses.getOrThrowFromIdentifier(rightHandPoseIdentifier);
            ItemRenderType leftHandItemRenderType = leftHandPoseIdentifier == FirstPersonHandPoses.GENERIC_ITEM ? leftHandGenericItemPoseDefinition.itemRenderType() : leftHandPose.itemRenderType();
            ItemRenderType rightHandItemRenderType = rightHandPoseIdentifier == FirstPersonHandPoses.GENERIC_ITEM ? rightHandGenericItemPoseDefinition.itemRenderType() : rightHandPose.itemRenderType();
            ItemStack mainHandItem = FirstPersonPlayerRenderer.getItemStackInHandToRender(dataContainer, player, InteractionHand.MAIN_HAND);
            ItemStack offHandItem = FirstPersonPlayerRenderer.getItemStackInHandToRender(dataContainer, player, InteractionHand.OFF_HAND);
            ItemStack rightHandItem = leftHanded ? offHandItem : mainHandItem;
            ItemStack leftHandItem = leftHanded ? mainHandItem : offHandItem;
            this.renderItem((LivingEntity)player, rightHandItem, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, poseStack, rightItemPose, nodeCollector, combinedLight, HumanoidArm.RIGHT, !leftHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, rightHandItemRenderType);
            this.renderItem((LivingEntity)player, leftHandItem, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, poseStack, leftItemPose, nodeCollector, combinedLight, HumanoidArm.LEFT, leftHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, leftHandItemRenderType);
            poseStack.popPose();
        }));
        this.minecraft.gameRenderer.getFeatureRenderDispatcher().renderAllFeatures();
        this.minecraft.renderBuffers().bufferSource().endBatch();
    }

    private static ItemStack getItemStackInHandToRender(AnimationDataContainer dataContainer, LocalPlayer localPlayer, InteractionHand hand) {
        ItemStack driverItem = (ItemStack)dataContainer.getDriverValue(FirstPersonDrivers.getItemDriver(hand));
        ItemStack driverRenderedItem = (ItemStack)dataContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand));
        ItemStack playerItem = localPlayer.getItemInHand(hand);
        if (!ItemStack.isSameItem((ItemStack)playerItem, (ItemStack)driverRenderedItem)) {
            return driverRenderedItem;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)playerItem, (ItemStack)driverRenderedItem)) {
            return playerItem;
        }
        for (TypedDataComponent dataComponent : playerItem.getComponents()) {
            if (dataComponent.type() == DataComponents.DAMAGE) continue;
            if (!driverRenderedItem.getComponents().has(dataComponent.type())) {
                return driverRenderedItem;
            }
            if (Objects.equals(driverRenderedItem.get(dataComponent.type()), dataComponent.value())) continue;
            return driverRenderedItem;
        }
        return playerItem;
    }

    private void renderArm(AbstractClientPlayer abstractClientPlayer, PlayerModel playerModel, HumanoidArm arm, PoseStack poseStack, SubmitNodeCollector nodeCollector, int combinedLight) {
        PlayerSkin skin = abstractClientPlayer.getSkin();
        boolean isUsingSlimArms = skin.model() == PlayerModelType.SLIM;
        boolean leftArm = arm == HumanoidArm.LEFT;
        Identifier skinTextureLocation = skin.body().texturePath();
        ModelPart armModelPart = leftArm ? playerModel.leftArm : playerModel.rightArm;
        ModelPart sleeveModelPart = leftArm ? playerModel.leftSleeve : playerModel.rightSleeve;
        PlayerModelPart sleevePlayerModelPart = leftArm ? PlayerModelPart.LEFT_SLEEVE : PlayerModelPart.RIGHT_SLEEVE;
        poseStack.pushPose();
        if (isUsingSlimArms) {
            poseStack.translate(0.03125f * (float)(leftArm ? 1 : -1), 0.0f, 0.0f);
        }
        sleeveModelPart.visible = abstractClientPlayer.isModelPartShown(sleevePlayerModelPart);
        nodeCollector.submitModelPart(armModelPart, poseStack, RenderTypes.entityTranslucent((Identifier)skinTextureLocation), combinedLight, OverlayTexture.NO_OVERLAY, null);
        poseStack.popPose();
    }

    public void renderItem(LivingEntity entity, ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, JointChannel jointChannel, SubmitNodeCollector nodeCollector, int combinedLight, HumanoidArm side, InteractionHand hand, ItemRenderType renderType) {
        if (!itemStack.isEmpty()) {
            IS_RENDERING_LOCOMOTION_FIRST_PERSON = true;
            CURRENT_ITEM_INTERACTION_HAND = hand;
            poseStack.pushPose();
            jointChannel.transformPoseStack(poseStack, 16.0f);
            if (renderType.isMirrored() && side == HumanoidArm.LEFT) {
                SHOULD_FLIP_ITEM_TRANSFORM = true;
            }
            switch (renderType) {
                case MAP: {
                    this.renderMap(nodeCollector, poseStack, itemStack, combinedLight);
                    break;
                }
                case THIRD_PERSON_ITEM: 
                case MIRRORED_THIRD_PERSON_ITEM: {
                    ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
                    this.itemModelResolver.updateForTopItem(itemStackRenderState, itemStack, displayContext, entity.level(), (ItemOwner)entity, entity.getId() + displayContext.ordinal());
                    itemStackRenderState.submit(poseStack, nodeCollector, combinedLight, OverlayTexture.NO_OVERLAY, 0);
                    break;
                }
                case BLOCK_STATE: {
                    FirstPersonBlockItemRenderer.submit(itemStack, poseStack, nodeCollector, combinedLight, side);
                }
            }
            SHOULD_FLIP_ITEM_TRANSFORM = false;
            IS_RENDERING_LOCOMOTION_FIRST_PERSON = false;
            poseStack.popPose();
        }
    }

    private void renderMap(SubmitNodeCollector nodeCollector, PoseStack poseStack, ItemStack itemStack, int combinedLight) {
        MapId mapId = (MapId)itemStack.get(DataComponents.MAP_ID);
        assert (this.minecraft.level != null);
        MapItemSavedData mapItemSavedData = MapItem.getSavedData((MapId)mapId, (Level)this.minecraft.level);
        RenderType renderType = mapItemSavedData == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD;
        poseStack.scale(-1.0f, 1.0f, -1.0f);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.translate(-2.0f, -4.0f, -1.0f);
        poseStack.scale(0.125f, 0.125f, 0.125f);
        poseStack.scale(0.25f, 0.25f, 0.25f);
        nodeCollector.submitCustomGeometry(poseStack, renderType, (pose, vertexConsumer) -> {
            vertexConsumer.addVertex(pose, -7.0f, 135.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(combinedLight);
            vertexConsumer.addVertex(pose, 135.0f, 135.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(combinedLight);
            vertexConsumer.addVertex(pose, 135.0f, -7.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(combinedLight);
            vertexConsumer.addVertex(pose, -7.0f, -7.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(combinedLight);
        });
        if (mapItemSavedData != null) {
            MapRenderer mapRenderer = this.minecraft.getMapRenderer();
            mapRenderer.extractRenderState(mapId, mapItemSavedData, this.mapRenderState);
            mapRenderer.render(this.mapRenderState, poseStack, nodeCollector, false, combinedLight);
        }
    }

    private void renderBlock(SubmitNodeCollector nodeCollector, PoseStack poseStack, BlockState blockState, int combinedLight) {
        ((FirstPersonSingleBlockRenderer)Minecraft.getInstance().getBlockRenderer()).locomotion$submitSingleBlockWithEmission(blockState, poseStack, nodeCollector, combinedLight);
    }

    private BlockState getDefaultBlockState(Block block) {
        BlockState blockState = block.defaultBlockState();
        blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(8));
        blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.ATTACH_FACE, (Comparable)AttachFace.FLOOR);
        blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.valueOf(true));
        if (block instanceof StairBlock) {
            blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH);
            blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        } else {
            blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH);
            blockState = (BlockState)blockState.trySetValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
        }
        return blockState;
    }

    private void renderBedBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource multiVersionRenderData, int combinedLight) {
        poseStack.translate(1.0f, -0.25f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
    }

    private void renderDoorBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource multiVersionRenderData, int combinedLight) {
    }

    private void renderFenceBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true));
        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true));
        this.blockRenderer.renderSingleBlock(blockState, poseStack, bufferSource, combinedLight, OverlayTexture.NO_OVERLAY);
    }

    private void renderWallBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.EAST_WALL, (Comparable)WallSide.LOW);
        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WEST_WALL, (Comparable)WallSide.LOW);
        this.blockRenderer.renderSingleBlock(blockState, poseStack, bufferSource, combinedLight, OverlayTexture.NO_OVERLAY);
    }

    private void renderUpperHalfBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        poseStack.translate(0.0f, 1.0f, 0.0f);
        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
        this.blockRenderer.renderSingleBlock(blockState, poseStack, bufferSource, combinedLight, OverlayTexture.NO_OVERLAY);
    }

    public void transformCamera(PoseStack poseStack) {
        if (this.minecraft.options.getCameraType().isFirstPerson()) {
            this.jointAnimatorDispatcher.getInterpolatedFirstPersonPlayerPose().ifPresent(animationPose -> {
                JointChannel cameraPose = animationPose.getJointChannel("camera_jnt");
                Vector3f cameraRot = cameraPose.getEulerRotationZYX();
                cameraRot.z *= -1.0f;
                cameraPose.rotate(cameraRot, JointChannel.TransformSpace.LOCAL, JointChannel.TransformType.REPLACE);
                cameraPose.translate(cameraPose.getTranslation().mul(1.0f, 1.0f, -1.0f), JointChannel.TransformSpace.COMPONENT, JointChannel.TransformType.REPLACE);
                cameraPose.transformPoseStack(poseStack, 16.0f);
            });
        }
    }

    @NotNull
    public PlayerModel getModel() {
        assert (this.minecraft.player != null);
        return (PlayerModel)this.entityRenderDispatcher.getPlayerRenderer((AbstractClientPlayer)this.minecraft.player).getModel();
    }
}

