/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.resource;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.resource.json.GsonConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocomotionResources
implements PreparableReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/Resources");
    public static final Identifier RELOADER_IDENTIFIER = Identifier.fromNamespaceAndPath((String)"locomotion", (String)"locomotion_asset_loader");
    private static final String JOINT_SKELETON_PATH = "skeletons";
    private static final String ANIMATION_SEQUENCE_PATH = "sequences";
    private static final Map<Identifier, AnimationSequence> ANIMATION_SEQUENCES;
    private static final Map<Identifier, JointSkeleton> JOINT_SKELETONS;

    public static Map<Identifier, JointSkeleton> getJointSkeletons() {
        return JOINT_SKELETONS;
    }

    public static Map<Identifier, AnimationSequence> getAnimationSequences() {
        return ANIMATION_SEQUENCES;
    }

    public static JointSkeleton getOrThrowJointSkeleton(Identifier jointSkeletonLocation) {
        if (JOINT_SKELETONS.containsKey(jointSkeletonLocation)) {
            return JOINT_SKELETONS.get(jointSkeletonLocation);
        }
        throw new IllegalArgumentException("Tried to access joint skeleton from resource location " + String.valueOf(jointSkeletonLocation) + ", but it was not found in the loaded data: " + String.valueOf(JOINT_SKELETONS.keySet()));
    }

    public static AnimationSequence getOrThrowAnimationSequence(Identifier sequenceLocation) {
        if (ANIMATION_SEQUENCES.containsKey(sequenceLocation)) {
            return ANIMATION_SEQUENCES.get(sequenceLocation);
        }
        throw new IllegalArgumentException("Tried to access animation sequence from resource location " + String.valueOf(sequenceLocation) + ", but it was not found in the loaded data.");
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.SharedState sharedState, Executor exectutor, PreparableReloadListener.PreparationBarrier barrier, Executor applyExectutor) {
        CompletableFuture<Map<Identifier, JointSkeleton>> loadedJointSkeletons = LocomotionResources.loadJointSkeletons(sharedState.resourceManager(), exectutor);
        CompletableFuture<Map<Identifier, AnimationSequence>> loadedAnimationSequences = LocomotionResources.loadAnimationSequences(sharedState.resourceManager(), exectutor);
        return ((CompletableFuture)CompletableFuture.allOf(loadedJointSkeletons, loadedAnimationSequences).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0))).thenCompose(voided -> CompletableFuture.runAsync(() -> {
            JOINT_SKELETONS.clear();
            JOINT_SKELETONS.putAll((Map)loadedJointSkeletons.join());
            ANIMATION_SEQUENCES.clear();
            ANIMATION_SEQUENCES.putAll((Map)loadedAnimationSequences.join());
            ANIMATION_SEQUENCES.replaceAll((Identifier2, animationSequence) -> animationSequence.getBaked());
            LOGGER.info("Cleared and replaced Locomotion resource data.");
        }));
    }

    private static CompletableFuture<Map<Identifier, AnimationSequence>> loadAnimationSequences(ResourceManager manager, Executor backgroundExecutor) {
        return LocomotionResources.loadJsonResources(manager, backgroundExecutor, AnimationSequence.class, ANIMATION_SEQUENCE_PATH, Identifier2 -> LOGGER.info("Successfully loaded animation sequence {}", Identifier2));
    }

    private static CompletableFuture<Map<Identifier, JointSkeleton>> loadJointSkeletons(ResourceManager manager, Executor backgroundExecutor) {
        return LocomotionResources.loadJsonResources(manager, backgroundExecutor, JointSkeleton.class, JOINT_SKELETON_PATH, Identifier2 -> LOGGER.info("Successfully loaded joint skeleton {}", Identifier2));
    }

    private static <D> CompletableFuture<Map<Identifier, D>> loadJsonResources(ResourceManager manager, Executor backgroundExecutor, Class<D> type, String pathToListFrom, Consumer<Identifier> onSuccessfullyLoaded) {
        return CompletableFuture.supplyAsync(() -> {
            Predicate<Identifier> isAssetJson = Identifier2 -> Identifier2.getPath().endsWith(".json");
            Map foundResources = manager.listResources(pathToListFrom, isAssetJson);
            HashMap deserializedResources = Maps.newHashMap();
            foundResources.forEach((Identifier2, resource) -> {
                try {
                    try (BufferedReader reader = resource.openAsReader();){
                        JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GsonConfiguration.getInstance(), (Reader)reader, JsonElement.class);
                        Object deserializedAsset = GsonConfiguration.getInstance().fromJson(jsonElement, type);
                        deserializedResources.put(Identifier2, deserializedAsset);
                        onSuccessfullyLoaded.accept((Identifier)Identifier2);
                    }
                    catch (JsonParseException exception) {
                        LOGGER.warn("Skipping loading of JSON asset {} of type {} due to a JSON parsing error:", Identifier2, (Object)type.getSimpleName());
                        LOGGER.warn("--- {}", (Object)exception.getMessage());
                    }
                }
                catch (IOException exception) {
                    LOGGER.error("Encountered error while reading asset {} of type {}:", Identifier2, (Object)type.getSimpleName());
                    LOGGER.error("--- {}", (Object)exception.getMessage());
                    throw new RuntimeException(exception);
                }
            });
            return deserializedResources;
        }, backgroundExecutor);
    }

    static {
        JOINT_SKELETONS = Maps.newHashMap();
        ANIMATION_SEQUENCES = Maps.newHashMap();
    }
}

