/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.util;

import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.Interpolator;
import java.util.Map;
import java.util.TreeMap;

public class Timeline<T> {
    private final TreeMap<Float, Keyframe<T>> keyframes = new TreeMap();
    private final Interpolator<T> interpolator;
    private final float length;

    private Timeline(Interpolator<T> interpolator, float length) {
        this.interpolator = interpolator;
        this.length = length;
    }

    public static <T> Timeline<T> of(Interpolator<T> interpolator, float length) {
        return new Timeline<T>(interpolator, length);
    }

    public T getValueAtTime(float time, boolean looping) {
        return looping ? this.getValueAtTimeLooped(time) : this.getValueAtTime(time);
    }

    public T getValueAtTime(float time) {
        Map.Entry<Float, Keyframe<T>> firstKeyframe = this.keyframes.floorEntry(Float.valueOf(time));
        Map.Entry<Float, Keyframe<T>> secondKeyframe = this.keyframes.ceilingEntry(Float.valueOf(time));
        if (firstKeyframe == null) {
            return secondKeyframe.getValue().getValue();
        }
        if (secondKeyframe == null) {
            return firstKeyframe.getValue().getValue();
        }
        if (firstKeyframe.getKey().equals(secondKeyframe.getKey())) {
            return firstKeyframe.getValue().getValue();
        }
        float relativeTime = (time - firstKeyframe.getKey().floatValue()) / (secondKeyframe.getKey().floatValue() - firstKeyframe.getKey().floatValue());
        return this.interpolator.interpolate(firstKeyframe.getValue().getValue(), secondKeyframe.getValue().getValue(), secondKeyframe.getValue().getEasing().ease(relativeTime));
    }

    public T getValueAtTimeLooped(float time) {
        return this.getValueAtTime(time % this.length);
    }

    public Timeline<T> addKeyframe(float time, T value) {
        return this.addKeyframe(time, value, Easing.LINEAR);
    }

    public Timeline<T> addKeyframe(float time, T value, Easing easing) {
        this.keyframes.put(Float.valueOf(time), new Keyframe<T>(value, easing));
        return this;
    }

    public static Timeline<Float> ofFloat(float length) {
        return Timeline.of(Interpolator.FLOAT, length);
    }

    public static Timeline<JointChannel> ofJointTransform(float length) {
        return Timeline.of(JointChannel::interpolate, length);
    }

    public static class Keyframe<T> {
        private final T value;
        Easing easing;

        public Keyframe(T value, Easing easing) {
            this.value = value;
            this.easing = easing;
        }

        public T getValue() {
            return this.value;
        }

        public Easing getEasing() {
            return this.easing;
        }
    }
}

