/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class FirstPersonAttackAnimations {
    private static final Map<class_2960, AttackAnimationRule> ATTACK_ANIMATION_RULES_BY_IDENTIFIER = Maps.newHashMap();
    public static final class_2960 DEFAULT = FirstPersonAttackAnimations.register(LocomotionMain.makeIdentifier("default"), AttackAnimationRule.of(FirstPersonMontages.HAND_TOOL_ATTACK_PICKAXE_MONTAGE, context -> true, 0));
    public static final class_2960 TRIDENT = FirstPersonAttackAnimations.register(LocomotionMain.makeIdentifier("trident_jab"), AttackAnimationRule.of(FirstPersonMontages.HAND_TRIDENT_JAB_MONTAGE, context -> context.currentMainHandPose() == FirstPersonHandPoses.TRIDENT, 30));
    public static final class_2960 SWORD_NULL = FirstPersonAttackAnimations.register(LocomotionMain.makeIdentifier("sword_null"), AttackAnimationRule.of(null, context -> context.currentMainHandPose() == FirstPersonHandPoses.SWORD, 30));
    public static final class_2960 AXE_ACROSS = FirstPersonAttackAnimations.register(LocomotionMain.makeIdentifier("axe_across"), AttackAnimationRule.of(FirstPersonMontages.HAND_TOOL_ATTACK_AXE_MONTAGE, context -> context.currentMainHandPose() == FirstPersonHandPoses.AXE, 30));
    public static final class_2960 MACE_SLAM = FirstPersonAttackAnimations.register(LocomotionMain.makeIdentifier("mace_slam"), AttackAnimationRule.of(FirstPersonMontages.HAND_MACE_ATTACK_MONTAGE, context -> context.currentMainHandPose() == FirstPersonHandPoses.MACE, 30));
    public static final class_2960 SPEAR_JAB = FirstPersonAttackAnimations.register(LocomotionMain.makeIdentifier("spear_jab"), AttackAnimationRule.of(FirstPersonMontages.HAND_SPEAR_JAB_MONTAGE, context -> context.currentMainHandPose() == FirstPersonHandPoses.SPEAR, 30));

    public static class_2960 register(class_2960 identifier, AttackAnimationRule rule) {
        ATTACK_ANIMATION_RULES_BY_IDENTIFIER.put(identifier, rule);
        return identifier;
    }

    public static void playAttackAnimation(OnTickDriverContainer driverContainer, MontageManager montageManager) {
        AttackAnimationConditionContext context = new AttackAnimationConditionContext((class_1799)driverContainer.getDriverValue(FirstPersonDrivers.MAIN_HAND_ITEM), (class_2960)driverContainer.getDriverValue(FirstPersonDrivers.MAIN_HAND_POSE));
        Map sortedAttackAnimationRules = ATTACK_ANIMATION_RULES_BY_IDENTIFIER.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((AttackAnimationRule)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (class_2960 ruleIdentifier : sortedAttackAnimationRules.keySet()) {
            AttackAnimationRule rule = (AttackAnimationRule)sortedAttackAnimationRules.get(ruleIdentifier);
            if (!rule.shouldChooseAttackAnimation().test(context)) continue;
            LocomotionMain.DEBUG_LOGGER.info("Playing use animation \"{}\"", (Object)ruleIdentifier);
            MontageConfiguration montage = rule.montageToPlay();
            if (montage == null) {
                return;
            }
            montageManager.playMontage(montage);
            return;
        }
    }

    public record AttackAnimationConditionContext(class_1799 item, class_2960 currentMainHandPose) {
    }

    public record AttackAnimationRule(MontageConfiguration montageToPlay, Predicate<AttackAnimationConditionContext> shouldChooseAttackAnimation, int evaluationPriority) {
        public static AttackAnimationRule of(MontageConfiguration montageToPlay, Predicate<AttackAnimationConditionContext> shouldChooseAttackAnimation, int evaluationPriority) {
            return new AttackAnimationRule(montageToPlay, shouldChooseAttackAnimation, evaluationPriority);
        }
    }
}

