/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrinking;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonEating;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMining;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.MakeDynamicAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.render.ItemRenderType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class FirstPersonGenericItems {
    private static final Map<class_2960, GenericItemPoseDefinition> GENERIC_ITEM_POSES_BY_IDENTIFIER = new HashMap<class_2960, GenericItemPoseDefinition>();
    public static final class_2960 GENERIC_2D_ITEM = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("generic_2d_item"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE, itemStack -> true, 0).build());
    public static final class_2960 ROD = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("rod"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_ROD_POSE, FirstPersonGenericItems::isRodItem, 20).build());
    public static final class_2960 SHEARS = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("shears"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_SHEARS_POSE, FirstPersonGenericItems::isShearsItem, 60).build());
    public static final class_2960 FISHING_ROD = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("fishing_rod"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_FISHING_ROD_POSE, FirstPersonGenericItems::isFishingRodItem, 70).build());
    public static final class_2960 ARROW = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("arrow"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_ARROW_POSE, FirstPersonGenericItems::isArrowItem, 80).setItemRenderType(ItemRenderType.MIRRORED_THIRD_PERSON_ITEM).build());
    public static final class_2960 BLOCK = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("block"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_BLOCK_POSE, FirstPersonGenericItems::isBlockItem, 80).setItemRenderType(ItemRenderType.BLOCK_STATE).build());
    public static final class_2960 DOOR = FirstPersonGenericItems.register(LocomotionMain.makeIdentifier("door"), GenericItemPoseDefinition.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_DOOR_BLOCK_POSE, FirstPersonGenericItems::isDoorItem, 90).setItemRenderType(ItemRenderType.BLOCK_STATE).build());
    public static final List<class_1792> ROD_ITEMS = List.of(class_1802.field_8606, class_1802.field_8600, class_1802.field_8894, class_1802.field_49821, class_1802.field_28042, class_1802.field_8648, class_1802.field_8688, class_1802.field_8056);
    public static final List<class_1792> FISHING_ROD_ITEMS = List.of(class_1802.field_8378, class_1802.field_8184, class_1802.field_23254);
    public static final List<class_1792> BLOCK_ITEM_OVERRIDES = List.of(class_1802.field_8106, class_1802.field_8247, class_1802.field_8466);
    public static final List<class_6862<class_1792>> BLOCK_ITEM_TAG_OVERRIDES = List.of(class_3489.field_61212, class_3489.field_54293, class_3489.field_48298, class_3489.field_16444);

    public static class_2960 register(class_2960 identifier, GenericItemPoseDefinition genericItemPoseDefinition) {
        GENERIC_ITEM_POSES_BY_IDENTIFIER.put(identifier, genericItemPoseDefinition);
        return identifier;
    }

    private static boolean isRodItem(class_1799 itemStack) {
        return ROD_ITEMS.contains(itemStack.method_7909());
    }

    private static boolean isShearsItem(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1820;
    }

    private static boolean isFishingRodItem(class_1799 itemStack) {
        return FISHING_ROD_ITEMS.contains(itemStack.method_7909());
    }

    private static boolean isArrowItem(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_18317);
    }

    private static boolean isBlockItem(class_1799 itemStack) {
        if (!(itemStack.method_7909() instanceof class_1747)) {
            return false;
        }
        for (class_1792 class_17922 : BLOCK_ITEM_OVERRIDES) {
            if (!itemStack.method_31574(class_17922)) continue;
            return true;
        }
        for (class_6862 class_68622 : BLOCK_ITEM_TAG_OVERRIDES) {
            if (!itemStack.method_31573(class_68622)) continue;
            return true;
        }
        class_2960 identifier = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        class_2960 class_29602 = class_2960.method_60655((String)identifier.method_12836(), (String)("models/item/" + identifier.method_12832() + ".json"));
        return class_310.method_1551().method_1478().method_14486(class_29602).isEmpty();
    }

    private static boolean isDoorItem(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_15553);
    }

    public static class_2960 getFallback() {
        return GENERIC_2D_ITEM;
    }

    public static GenericItemPoseDefinition getOrThrowFromIdentifier(class_2960 identifier) {
        GenericItemPoseDefinition definition = GENERIC_ITEM_POSES_BY_IDENTIFIER.get(identifier);
        if (definition == null) {
            throw new RuntimeException("Identifier " + String.valueOf(identifier) + " is not a registered generic item pose.");
        }
        return definition;
    }

    public static class_2960 getConfigurationFromItem(class_1799 itemStack) {
        Map genericItemPosesSortedByPriority = GENERIC_ITEM_POSES_BY_IDENTIFIER.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((GenericItemPoseDefinition)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (class_2960 key : genericItemPosesSortedByPriority.keySet()) {
            GenericItemPoseDefinition definition = GENERIC_ITEM_POSES_BY_IDENTIFIER.get(key);
            if (!definition.choosePoseIfTrue().test(itemStack)) continue;
            return key;
        }
        return FirstPersonGenericItems.getFallback();
    }

    public static PoseFunction<LocalSpacePose> constructPoseFunction(CachedPoseContainer cachedPoseContainer, class_1268 hand) {
        ApplyAdditiveFunction pose = FirstPersonMining.makeMainHandPickaxeMiningPoseFunction(cachedPoseContainer, hand);
        PoseFunction<LocalSpacePose> consumablePose = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE).build();
        consumablePose = FirstPersonEating.constructWithEatingStateMachine(cachedPoseContainer, hand, consumablePose);
        consumablePose = FirstPersonDrinking.constructWithDrinkingStateMachine(cachedPoseContainer, hand, consumablePose);
        pose = ApplyAdditiveFunction.of(pose, MakeDynamicAdditiveFunction.of(consumablePose, SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE).build()));
        return pose;
    }

    public record GenericItemPoseDefinition(class_2960 basePoseSequence, Predicate<class_1799> choosePoseIfTrue, int evaluationPriority, ItemRenderType itemRenderType) {
        public static Builder builder(class_2960 basePoseAnimationSequence, Predicate<class_1799> choosePoseIfTrue, int evaluationPriority) {
            return new Builder(basePoseAnimationSequence, choosePoseIfTrue, evaluationPriority);
        }

        public static class Builder {
            private final class_2960 basePoseAnimationSequence;
            private final int evaluationPriority;
            private final Predicate<class_1799> choosePoseIfTrue;
            private ItemRenderType itemRenderType;

            private Builder(class_2960 basePoseAnimationSequence, Predicate<class_1799> choosePoseIfTrue, int evaluationPriority) {
                this.basePoseAnimationSequence = basePoseAnimationSequence;
                this.choosePoseIfTrue = choosePoseIfTrue;
                this.evaluationPriority = evaluationPriority;
                this.itemRenderType = ItemRenderType.THIRD_PERSON_ITEM;
            }

            public Builder setItemRenderType(ItemRenderType itemRenderType) {
                this.itemRenderType = itemRenderType;
                return this;
            }

            public GenericItemPoseDefinition build() {
                return new GenericItemPoseDefinition(this.basePoseAnimationSequence, this.choosePoseIfTrue, this.evaluationPriority, this.itemRenderType);
            }
        }
    }
}

