/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonJointAnimator;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.BlendPosesFunction;
import com.trainguy9512.locomotion.animation.pose.function.EmptyPoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceReferencePoint;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageSlotFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateMachineFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import net.minecraft.class_9336;

public class FirstPersonHandPoseSwitching {
    public static final String HAND_POSE_DROPPING_LAST_ITEM_STATE = "dropping_last_item";
    public static final String HAND_POSE_USING_LAST_ITEM_STATE = "using_last_item";
    public static final String HAND_POSE_THROWING_TRIDENT_STATE = "throwing_trident";

    public static String getEntryHandPoseState(PoseFunction.FunctionEvaluationState evaluationState, class_1268 hand) {
        class_2960 handPoseIdentifier = (class_2960)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.getHandPoseDriver(hand));
        FirstPersonHandPoses.HandPoseDefinition definition = FirstPersonHandPoses.getOrThrowFromIdentifier(handPoseIdentifier);
        return definition.stateIdentifier();
    }

    public static PoseFunction<LocalSpacePose> constructPoseFunction(CachedPoseContainer cachedPoseContainer, class_1268 hand) {
        StateMachineFunction.Builder stateMachineBuilder = StateMachineFunction.builder(evaluationState -> FirstPersonHandPoseSwitching.getEntryHandPoseState(evaluationState, hand));
        stateMachineBuilder.resetsUponRelevant(true);
        StateAlias.Builder fromLowerAliasBuilder = StateAlias.builder(Set.of());
        for (class_2960 handPoseIdentifier : FirstPersonHandPoses.getRegisteredHandPoseDefinitions()) {
            FirstPersonHandPoses.HandPoseDefinition handPose = FirstPersonHandPoses.getOrThrowFromIdentifier(handPoseIdentifier);
            FirstPersonHandPoseSwitching.defineStatesForHandPose(cachedPoseContainer, hand, stateMachineBuilder, fromLowerAliasBuilder, handPoseIdentifier, handPose);
        }
        stateMachineBuilder.addStateAlias(fromLowerAliasBuilder.build());
        FirstPersonHandPoseSwitching.defineExtraStates(stateMachineBuilder, hand);
        BlendPosesFunction pose = stateMachineBuilder.build();
        pose = BlendPosesFunction.builder(pose).addBlendInput(EmptyPoseFunction.of(), functionEvaluationState -> Float.valueOf(1.0f - LocomotionMain.CONFIG.data().firstPersonPlayer.cameraShakeItemInteractionIntensity), FirstPersonJointAnimator.CAMERA_MASK).build();
        return pose;
    }

    public static PoseFunction<LocalSpacePose> constructCurrentBasePoseFunction(class_1268 hand) {
        return SequenceEvaluatorFunction.builder(context -> FirstPersonHandPoseSwitching.getCurrentBasePoseForAdditive(context, hand)).build();
    }

    public static class_2960 getCurrentBasePoseForAdditive(PoseFunction.FunctionInterpolationContext context, class_1268 hand) {
        class_2960 currentHandPoseIdentifier = (class_2960)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.getHandPoseDriver(hand), context.partialTicks());
        if (currentHandPoseIdentifier == FirstPersonHandPoses.GENERIC_ITEM) {
            class_2960 currentGenericItemPoseIdentifier = (class_2960)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(hand), context.partialTicks());
            FirstPersonGenericItems.GenericItemPoseDefinition definition = FirstPersonGenericItems.getOrThrowFromIdentifier(currentGenericItemPoseIdentifier);
            return definition.basePoseSequence();
        }
        FirstPersonHandPoses.HandPoseDefinition definition = FirstPersonHandPoses.getOrThrowFromIdentifier(currentHandPoseIdentifier);
        return definition.basePoseSequence();
    }

    private static boolean shouldTransitionToThisRaiseState(StateTransition.TransitionContext context, class_2960 handPoseIdentifier, class_1268 hand) {
        class_1799 currentItemStack = (class_1799)context.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(hand));
        class_2960 handPoseFromCurrentItemStack = FirstPersonHandPoses.testForNextHandPose(currentItemStack, hand);
        return handPoseIdentifier == handPoseFromCurrentItemStack;
    }

    public static void defineStatesForHandPose(CachedPoseContainer cachedPoseContainer, class_1268 hand, StateMachineFunction.Builder stateMachineBuilder, StateAlias.Builder fromLowerAliasBuilder, class_2960 handPoseIdentifier, FirstPersonHandPoses.HandPoseDefinition handPose) {
        String poseState = handPose.stateIdentifier();
        String lowerState = handPose.getLowerStateIdentifier();
        String raiseState = handPose.getRaiseStateIdentifier();
        MontageSlotFunction posePoseFunction = handPose.poseFunctionProvider().apply(cachedPoseContainer, hand);
        posePoseFunction = MontageSlotFunction.of(posePoseFunction, FirstPersonMontages.getAttackSlot(hand));
        PoseFunction<LocalSpacePose> raisePoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(handPose.raiseSequence()).isAdditive(true, SequenceReferencePoint.END)).build();
        raisePoseFunction = ApplyAdditiveFunction.of(FirstPersonHandPoseSwitching.constructCurrentBasePoseFunction(hand), raisePoseFunction);
        raisePoseFunction = MontageSlotFunction.of(raisePoseFunction, FirstPersonMontages.getAttackSlot(hand));
        PoseFunction<LocalSpacePose> lowerPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(handPose.lowerSequence()).isAdditive(true, SequenceReferencePoint.BEGINNING)).build();
        lowerPoseFunction = ApplyAdditiveFunction.of(FirstPersonHandPoseSwitching.constructCurrentBasePoseFunction(hand), lowerPoseFunction);
        stateMachineBuilder.defineState(StateDefinition.builder(poseState, posePoseFunction).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(lowerState, lowerPoseFunction).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(raiseState, raisePoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(poseState).isTakenOnAnimationFinished(1.0f).setTiming(handPose.raiseToPoseTransition()).build()).addOutboundTransition(StateTransition.builder(poseState).isTakenIfTrue(context -> FirstPersonHandPoseSwitching.shouldSkipRaiseAnimation(context, hand)).setTiming(Transition.builder(TimeSpan.ofTicks(3.0f)).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(poseState, raiseState)).addOutboundTransition(StateTransition.builder(lowerState).isTakenIfTrue(context -> FirstPersonHandPoseSwitching.shouldTakeHardSwitchTransition(context, hand)).setTiming(handPose.poseToLowerTransition()).setPriority(50).build()).addOutboundTransition(StateTransition.builder(HAND_POSE_DROPPING_LAST_ITEM_STATE).isTakenIfTrue(context -> FirstPersonHandPoseSwitching.shouldTakeDropLastItemTransition(context, hand)).setPriority(80).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).build()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), hand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPoseSwitching.clearMontagesInAttackSlot(evaluationState, hand)).build()).addOutboundTransition(StateTransition.builder(HAND_POSE_USING_LAST_ITEM_STATE).isTakenIfTrue(context -> FirstPersonHandPoseSwitching.shouldTakeUseLastItemTransition(context, hand)).setPriority(70).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).build()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), hand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPoseSwitching.clearMontagesInAttackSlot(evaluationState, hand)).build()).addOutboundTransition(StateTransition.builder(HAND_POSE_THROWING_TRIDENT_STATE).isTakenIfTrue(context -> FirstPersonHandPoseSwitching.shouldTakeThrowTridentTransition(context, hand)).setPriority(60).setTiming(Transition.builder(TimeSpan.ofTicks(1.0f)).build()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), hand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPoseSwitching.clearMontagesInAttackSlot(evaluationState, hand)).build()).build());
        fromLowerAliasBuilder.addOriginatingState(lowerState).addOutboundTransition(StateTransition.builder(raiseState).setTiming(Transition.INSTANT).isTakenIfTrue(StateTransition.MOST_RELEVANT_ANIMATION_PLAYER_IS_FINISHING.and(context -> FirstPersonHandPoseSwitching.shouldTransitionToThisRaiseState(context, handPoseIdentifier, hand))).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), hand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPoseSwitching.clearMontagesInAttackSlot(evaluationState, hand)).build());
    }

    public static void defineExtraStates(StateMachineFunction.Builder stateMachineBuilder, class_1268 hand) {
        FirstPersonHandPoses.HandPoseDefinition emptyHandPose = FirstPersonHandPoses.getOrThrowFromIdentifier(FirstPersonHandPoses.getEmptyHandPose(hand));
        PoseFunction<LocalSpacePose> useLastItemPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_USE).isAdditive(true, SequenceReferencePoint.END)).build();
        useLastItemPoseFunction = ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(emptyHandPose.basePoseSequence()).build(), useLastItemPoseFunction);
        PoseFunction<LocalSpacePose> dropLastItemPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_USE).isAdditive(true, SequenceReferencePoint.END)).build();
        dropLastItemPoseFunction = ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(emptyHandPose.basePoseSequence()).build(), dropLastItemPoseFunction);
        SequencePlayerFunction throwingTridentPoseFunction = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_RELEASE_THROW).build();
        stateMachineBuilder.defineState(StateDefinition.builder(HAND_POSE_DROPPING_LAST_ITEM_STATE, dropLastItemPoseFunction).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(HAND_POSE_USING_LAST_ITEM_STATE, useLastItemPoseFunction).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(HAND_POSE_THROWING_TRIDENT_STATE, throwingTridentPoseFunction).addOutboundTransition(StateTransition.builder(emptyHandPose.getRaiseStateIdentifier()).isTakenOnAnimationFinished(0.0f).setTiming(Transition.builder(TimeSpan.ofTicks(1.0f)).build()).build()).resetsPoseFunctionUponEntry(true).build()).addStateAlias(StateAlias.builder(Set.of(HAND_POSE_DROPPING_LAST_ITEM_STATE, HAND_POSE_USING_LAST_ITEM_STATE)).addOutboundTransition(StateTransition.builder(emptyHandPose.stateIdentifier()).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.ofSeconds(0.1f)).setEasement(Easing.SINE_IN_OUT).build()).build()).addOutboundTransition(StateTransition.builder(emptyHandPose.stateIdentifier()).isTakenIfTrue(context -> FirstPersonHandPoseSwitching.shouldCancelLastItemAnimation(context, hand)).setTiming(Transition.builder(TimeSpan.ofSeconds(0.05f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build());
    }

    private static void clearMontagesInAttackSlot(PoseFunction.FunctionEvaluationState evaluationState, class_1268 hand) {
        evaluationState.montageManager().interruptMontagesInSlot(FirstPersonMontages.getAttackSlot(hand), Transition.INSTANT);
    }

    private static boolean shouldCancelLastItemAnimation(StateTransition.TransitionContext context, class_1268 hand) {
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getHasUsedItemDriver(hand))).booleanValue() && context.timeElapsedInCurrentState().inTicks() > 2.0f) {
            return true;
        }
        if (hand == class_1268.field_5808) {
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.HAS_ATTACKED)).booleanValue()) {
                return true;
            }
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_MINING)).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasItemChanged(StateTransition.TransitionContext context, class_1268 hand) {
        class_1799 itemCurrentTick;
        class_1799 itemPreviousTick = (class_1799)context.driverContainer().getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand));
        if (!itemPreviousTick.method_31574((itemCurrentTick = (class_1799)context.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(hand))).method_7909())) {
            return true;
        }
        for (class_9336 dataComponent : itemCurrentTick.method_57353()) {
            if (dataComponent.comp_2443() == class_9334.field_49629) continue;
            if (!itemPreviousTick.method_57353().method_57832(dataComponent.comp_2443())) {
                return true;
            }
            if (Objects.equals(itemPreviousTick.method_58694(dataComponent.comp_2443()), dataComponent.comp_2444())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewItemEmpty(StateTransition.TransitionContext context, class_1268 hand) {
        return ((class_1799)context.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(hand))).method_7960();
    }

    private static boolean isOldItemEmpty(StateTransition.TransitionContext context, class_1268 hand) {
        return ((class_1799)context.driverContainer().getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand))).method_7960();
    }

    private static boolean hasSelectedHotbarSlotChanged(StateTransition.TransitionContext context, class_1268 hand) {
        return hand == class_1268.field_5808 && context.driverContainer().getDriver(FirstPersonDrivers.HOTBAR_SLOT).hasValueChanged();
    }

    private static boolean areAnyTwoHandedOverridesActive(StateTransition.TransitionContext context) {
        return !Objects.equals(context.driverContainer().getDriverValue(FirstPersonDrivers.CURRENT_TWO_HANDED_OVERRIDE_STATE), "normal");
    }

    private static boolean shouldTakeHardSwitchTransition(StateTransition.TransitionContext context, class_1268 hand) {
        if (FirstPersonHandPoseSwitching.areAnyTwoHandedOverridesActive(context)) {
            return false;
        }
        if (context.driverContainer().getDriver(FirstPersonDrivers.getUsingItemDriver(hand)).getPreviousValue().booleanValue()) {
            class_1839 useAnimation = context.driverContainer().getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(hand)).getPreviousValue().method_7976();
            if (useAnimation == class_1839.field_8950) {
                return false;
            }
            if (useAnimation == class_1839.field_8946) {
                return false;
            }
        }
        if (FirstPersonHandPoseSwitching.hasItemChanged(context, hand)) {
            return true;
        }
        return FirstPersonHandPoseSwitching.hasSelectedHotbarSlotChanged(context, hand) && (!FirstPersonHandPoseSwitching.isNewItemEmpty(context, hand) || !FirstPersonHandPoseSwitching.isOldItemEmpty(context, hand));
    }

    private static boolean shouldTakeDropLastItemTransition(StateTransition.TransitionContext context, class_1268 hand) {
        if (hand != class_1268.field_5808) {
            return false;
        }
        if (!FirstPersonHandPoseSwitching.isNewItemEmpty(context, hand)) {
            return false;
        }
        return context.driverContainer().getDriver(FirstPersonDrivers.HAS_DROPPED_ITEM).hasBeenTriggered();
    }

    private static boolean shouldTakeUseLastItemTransition(StateTransition.TransitionContext context, class_1268 hand) {
        if (!FirstPersonHandPoseSwitching.isNewItemEmpty(context, hand)) {
            return false;
        }
        if (FirstPersonHandPoseSwitching.isOldItemEmpty(context, hand)) {
            return false;
        }
        if (context.driverContainer().getDriver(FirstPersonDrivers.getHasUsedItemDriver(hand)).hasBeenTriggered()) {
            return true;
        }
        return hand == class_1268.field_5808 && context.driverContainer().getDriver(FirstPersonDrivers.HAS_ATTACKED).hasBeenTriggered();
    }

    private static boolean shouldTakeThrowTridentTransition(StateTransition.TransitionContext context, class_1268 hand) {
        if (!FirstPersonHandPoseSwitching.isNewItemEmpty(context, hand)) {
            return false;
        }
        if (FirstPersonHandPoseSwitching.isOldItemEmpty(context, hand)) {
            return false;
        }
        if (FirstPersonHandPoseSwitching.hasSelectedHotbarSlotChanged(context, hand)) {
            return false;
        }
        if (context.driverContainer().getDriver(FirstPersonDrivers.HAS_SWAPPED_ITEMS).hasBeenTriggered()) {
            return false;
        }
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.HAS_SCREEN_OPEN)).booleanValue()) {
            return false;
        }
        boolean previousItemWasTrident = context.driverContainer().getDriverValue(FirstPersonDrivers.getHandPoseDriver(hand)) == FirstPersonHandPoses.TRIDENT;
        boolean wasJustUsingItem = context.driverContainer().getDriver(FirstPersonDrivers.getUsingItemDriver(hand)).getPreviousValue();
        return previousItemWasTrident;
    }

    private static boolean shouldSkipRaiseAnimation(StateTransition.TransitionContext context, class_1268 hand) {
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getUsingItemDriver(hand))).booleanValue()) {
            return true;
        }
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getHasUsedItemDriver(hand))).booleanValue()) {
            return true;
        }
        if (hand == class_1268.field_5808) {
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_MINING)).booleanValue()) {
                return true;
            }
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.HAS_ATTACKED)).booleanValue()) {
                return true;
            }
        }
        return false;
    }
}

