/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonBrush;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMace;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMining;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonShield;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonSpear;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonSpyglass;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonSword;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonTrident;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.render.ItemRenderType;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.MultiVersionUtils;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_9334;

public class FirstPersonHandPoses {
    private static final Map<class_2960, HandPoseDefinition> HAND_POSES_BY_IDENTIFIER = new HashMap<class_2960, HandPoseDefinition>();
    public static final class_2960 EMPTY_MAIN_HAND = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("empty_main_hand"), HandPoseDefinition.builder("empty_main_hand", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_EMPTY_POSE, class_1799::method_7960, 10).setHandsToUsePoseIn(class_1268.field_5808).build());
    public static final class_2960 EMPTY_OFF_HAND = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("empty_off_hand"), HandPoseDefinition.builder("empty_off_hand", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_EMPTY_LOWERED, class_1799::method_7960, 10).setRaiseSequence(FirstPersonAnimationSequences.HAND_EMPTY_LOWERED).setLowerSequence(FirstPersonAnimationSequences.HAND_EMPTY_LOWERED).setHandsToUsePoseIn(class_1268.field_5810).build());
    public static final class_2960 GENERIC_ITEM = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("generic_item"), HandPoseDefinition.builder("generic_item", FirstPersonGenericItems::constructPoseFunction, FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE, itemStack -> true, 0).build());
    public static final class_2960 PICKAXE = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("pickaxe"), HandPoseDefinition.builder("pickaxe", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_TOOL_POSE, itemStack -> itemStack.method_31573(class_3489.field_42614), 60).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 AXE = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("axe"), HandPoseDefinition.builder("axe", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_TOOL_POSE, itemStack -> itemStack.method_31573(class_3489.field_42612), 50).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 SHOVEL = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("shovel"), HandPoseDefinition.builder("shovel", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_TOOL_POSE, itemStack -> itemStack.method_31573(class_3489.field_42615), 40).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 HOE = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("hoe"), HandPoseDefinition.builder("hoe", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_TOOL_POSE, itemStack -> itemStack.method_31573(class_3489.field_42613), 40).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 SWORD = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("sword"), HandPoseDefinition.builder("sword", FirstPersonSword::handSwordPoseFunction, FirstPersonAnimationSequences.HAND_TOOL_POSE, itemStack -> itemStack.method_31573(class_3489.field_42611), 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 SHIELD = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("shield"), HandPoseDefinition.builder("shield", FirstPersonShield::constructShieldPoseFunction, FirstPersonAnimationSequences.HAND_SHIELD_POSE, itemStack -> itemStack.method_7909() instanceof class_1819, 90).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 BOW = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("bow"), HandPoseDefinition.builder("bow", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_BOW_POSE, itemStack -> itemStack.method_7976() == class_1839.field_8953, 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 CROSSBOW = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("crossbow"), HandPoseDefinition.builder("crossbow", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_CROSSBOW_POSE, itemStack -> itemStack.method_7976() == class_1839.field_8947, 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_CROSSBOW_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 TRIDENT = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("trident"), HandPoseDefinition.builder("trident", FirstPersonTrident::handTridentPoseFunction, FirstPersonAnimationSequences.HAND_TRIDENT_POSE, itemStack -> itemStack.method_7976() == MultiVersionUtils.getTridentUseAnimation(), 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_SPEAR_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_SPEAR_LOWER).build());
    public static final class_2960 BRUSH = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("brush"), HandPoseDefinition.builder("brush", FirstPersonBrush::handBrushPoseFunction, FirstPersonAnimationSequences.HAND_BRUSH_POSE, itemStack -> itemStack.method_7976() == class_1839.field_42717, 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 MACE = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("mace"), HandPoseDefinition.builder("mace", FirstPersonMace::handMacePoseFunction, FirstPersonAnimationSequences.HAND_MACE_POSE, itemStack -> itemStack.method_31573(class_3489.field_50109), 110).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 SPYGLASS = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("spyglass"), HandPoseDefinition.builder("spyglass", FirstPersonSpyglass::handSpyglassPoseFunction, FirstPersonAnimationSequences.HAND_SPYGLASS_POSE, itemStack -> itemStack.method_7976() == class_1839.field_27079, 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build());
    public static final class_2960 MAP = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("map"), HandPoseDefinition.builder("map", FirstPersonMining::makeMainHandPickaxeMiningPoseFunction, FirstPersonAnimationSequences.HAND_MAP_SINGLE_HAND_POSE, itemStack -> itemStack.method_57826(class_9334.field_49646), 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_TOOL_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_TOOL_LOWER).setItemRenderType(ItemRenderType.MAP).build());
    public static final class_2960 SPEAR = FirstPersonHandPoses.register(LocomotionMain.makeIdentifier("spear"), HandPoseDefinition.builder("spear", FirstPersonSpear::constructSpearPoseFunction, FirstPersonAnimationSequences.HAND_SPEAR_POSE, itemStack -> itemStack.method_7976() == MultiVersionUtils.getSpearUseAnimation(), 100).setRaiseSequence(FirstPersonAnimationSequences.HAND_SPEAR_RAISE).setLowerSequence(FirstPersonAnimationSequences.HAND_SPEAR_LOWER).build());

    public static class_2960 register(class_2960 identifier, HandPoseDefinition configuration) {
        HAND_POSES_BY_IDENTIFIER.put(identifier, configuration);
        return identifier;
    }

    public static class_2960 getFallback() {
        return GENERIC_ITEM;
    }

    public static class_2960 getEmptyHandPose(class_1268 hand) {
        return switch (hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> EMPTY_MAIN_HAND;
            case class_1268.field_5810 -> EMPTY_OFF_HAND;
        };
    }

    public static HandPoseDefinition getOrThrowFromIdentifier(class_2960 identifier) {
        HandPoseDefinition definition = HAND_POSES_BY_IDENTIFIER.get(identifier);
        if (definition == null) {
            throw new RuntimeException("Identifier " + String.valueOf(identifier) + " is not a registered hand pose.");
        }
        return definition;
    }

    public static Set<class_2960> getRegisteredHandPoseDefinitions() {
        return HAND_POSES_BY_IDENTIFIER.keySet();
    }

    public static class_2960 testForNextHandPose(class_1799 itemStack, class_1268 hand) {
        Map handPosesSortedByPriority = HAND_POSES_BY_IDENTIFIER.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((HandPoseDefinition)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (class_2960 key : handPosesSortedByPriority.keySet()) {
            HandPoseDefinition definition = HAND_POSES_BY_IDENTIFIER.get(key);
            boolean poseHasBeenChosen = definition.choosePoseIfTrue().test(itemStack);
            boolean poseCanPlayInCurrentHand = Arrays.asList(definition.handsToUsePoseIn()).contains(hand);
            if (!poseHasBeenChosen || !poseCanPlayInCurrentHand) continue;
            return key;
        }
        return FirstPersonHandPoses.getFallback();
    }

    public record HandPoseDefinition(String stateIdentifier, Predicate<class_1799> choosePoseIfTrue, int evaluationPriority, BiFunction<CachedPoseContainer, class_1268, PoseFunction<LocalSpacePose>> poseFunctionProvider, class_2960 basePoseSequence, class_2960 raiseSequence, class_2960 lowerSequence, Transition raiseToPoseTransition, Transition poseToLowerTransition, ItemRenderType itemRenderType, class_1268[] handsToUsePoseIn) {
        public String getRaiseStateIdentifier() {
            return this.stateIdentifier + "_raise";
        }

        public String getLowerStateIdentifier() {
            return this.stateIdentifier + "_lower";
        }

        public static Builder builder(String stateIdentifier, BiFunction<CachedPoseContainer, class_1268, PoseFunction<LocalSpacePose>> poseFunctionProvider, class_2960 basePoseSequence, Predicate<class_1799> choosePoseIfTrue, int chooseEvaluationPriority) {
            return new Builder(stateIdentifier, poseFunctionProvider, basePoseSequence, choosePoseIfTrue, chooseEvaluationPriority);
        }

        public static class Builder {
            private final String stateIdentifier;
            private final Predicate<class_1799> choosePoseIfTrue;
            private final int evaluationPriority;
            private final BiFunction<CachedPoseContainer, class_1268, PoseFunction<LocalSpacePose>> poseFunctionProvider;
            private final class_2960 basePoseSequence;
            private class_2960 raiseSequence;
            private class_2960 lowerSequence;
            private Transition raiseToPoseTransition;
            private Transition poseToLowerTransition;
            private ItemRenderType itemRenderType;
            private class_1268[] handsToUsePoseIn;

            private Builder(String stateIdentifier, BiFunction<CachedPoseContainer, class_1268, PoseFunction<LocalSpacePose>> poseFunctionProvider, class_2960 basePoseSequence, Predicate<class_1799> choosePoseIfTrue, int evaluationPriority) {
                this.stateIdentifier = stateIdentifier;
                this.poseFunctionProvider = poseFunctionProvider;
                this.choosePoseIfTrue = choosePoseIfTrue;
                this.evaluationPriority = evaluationPriority;
                this.basePoseSequence = basePoseSequence;
                this.raiseSequence = FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE;
                this.lowerSequence = FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER;
                this.raiseToPoseTransition = Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build();
                this.poseToLowerTransition = Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build();
                this.itemRenderType = ItemRenderType.THIRD_PERSON_ITEM;
                this.handsToUsePoseIn = class_1268.values();
            }

            public Builder setRaiseSequence(class_2960 sequence) {
                this.raiseSequence = sequence;
                return this;
            }

            public Builder setLowerSequence(class_2960 sequence) {
                this.lowerSequence = sequence;
                return this;
            }

            public Builder setRaiseToPoseTransition(Transition transition) {
                this.raiseToPoseTransition = transition;
                return this;
            }

            public Builder setPoseToLowerTransition(Transition transition) {
                this.poseToLowerTransition = transition;
                return this;
            }

            public Builder setItemRenderType(ItemRenderType renderType) {
                this.itemRenderType = renderType;
                return this;
            }

            public Builder setHandsToUsePoseIn(class_1268 ... hands) {
                this.handsToUsePoseIn = hands;
                return this;
            }

            public HandPoseDefinition build() {
                return new HandPoseDefinition(this.stateIdentifier, this.choosePoseIfTrue, this.evaluationPriority, this.poseFunctionProvider, this.basePoseSequence, this.raiseSequence, this.lowerSequence, this.raiseToPoseTransition, this.poseToLowerTransition, this.itemRenderType, this.handsToUsePoseIn);
            }
        }
    }
}

