/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class FirstPersonItemUpdateAnimations {
    private static final Map<class_2960, ItemUpdateAnimationRule> ITEM_UPDATE_ANIMATION_RULES_BY_IDENTIFIER = Maps.newHashMap();
    public static final class_2960 CROSSBOW_FIRE = FirstPersonItemUpdateAnimations.register(LocomotionMain.makeIdentifier("crossbow_fire"), ItemUpdateAnimationRule.of(FirstPersonMontages::getCrossbowFireMontage, FirstPersonItemUpdateAnimations::shouldPlayCrossbowFire, 0));
    public static final class_2960 BUCKET_COLLECT = FirstPersonItemUpdateAnimations.register(LocomotionMain.makeIdentifier("bucket_collect"), ItemUpdateAnimationRule.of(FirstPersonMontages::getBucketCollectMontage, FirstPersonItemUpdateAnimations::shouldPlayBucketCollect, 0));
    public static final class_2960 BUCKET_EMPTY = FirstPersonItemUpdateAnimations.register(LocomotionMain.makeIdentifier("bucket_empty"), ItemUpdateAnimationRule.of(FirstPersonMontages::getBucketEmptyMontage, FirstPersonItemUpdateAnimations::shouldPlayBucketEmpty, 0));
    private static final List<class_1792> FULL_BUCKET_ITEMS = List.of(class_1802.field_8705, class_1802.field_8187, class_1802.field_28354, class_1802.field_8666, class_1802.field_27876, class_1802.field_8108, class_1802.field_8714, class_1802.field_37533, class_1802.field_8478);

    private static boolean shouldPlayCrossbowFire(ItemUpdateAnimationConditionContext context) {
        boolean bothItemsAreCrossbows = context.bothItemsMeetPredicate(itemStack -> itemStack.method_57826(class_9334.field_49649));
        if (!bothItemsAreCrossbows) {
            return false;
        }
        boolean currentCrossbowHasCharge = !((class_9278)context.currentItem.method_58694(class_9334.field_49649)).method_57442();
        boolean previousCrossbowHasCharge = !((class_9278)context.previousItem.method_58694(class_9334.field_49649)).method_57442();
        return !currentCrossbowHasCharge && previousCrossbowHasCharge;
    }

    private static boolean shouldPlayBucketCollect(ItemUpdateAnimationConditionContext context) {
        boolean previousItemIsEmptyBucket = context.previousItem().method_31574(class_1802.field_8550);
        boolean currentItemIsCollectedBucket = FULL_BUCKET_ITEMS.contains(context.currentItem().method_7909());
        return previousItemIsEmptyBucket && currentItemIsCollectedBucket;
    }

    private static boolean shouldPlayBucketEmpty(ItemUpdateAnimationConditionContext context) {
        boolean currentItemIsEmptyBucket = context.currentItem().method_31574(class_1802.field_8550);
        boolean previousItemIsCollectedBucket = FULL_BUCKET_ITEMS.contains(context.previousItem().method_7909());
        return currentItemIsEmptyBucket && previousItemIsCollectedBucket;
    }

    public static class_2960 register(class_2960 identifier, ItemUpdateAnimationRule itemUpdateAnimationRule) {
        ITEM_UPDATE_ANIMATION_RULES_BY_IDENTIFIER.put(identifier, itemUpdateAnimationRule);
        return identifier;
    }

    public static void testForAndPlayItemUpdateAnimations(OnTickDriverContainer driverContainer, MontageManager montageManager, class_1268 hand) {
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.HAS_DROPPED_ITEM)).booleanValue()) {
            return;
        }
        if (driverContainer.getDriver(FirstPersonDrivers.HOTBAR_SLOT).hasValueChanged()) {
            return;
        }
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.HAS_SCREEN_OPEN)).booleanValue()) {
            return;
        }
        class_1799 actualItem = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(hand)).getCurrentValue();
        class_1799 previousItem = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(hand)).getPreviousValue();
        class_1799 renderedItem = (class_1799)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand));
        ItemUpdateAnimationConditionContext context = new ItemUpdateAnimationConditionContext(actualItem, previousItem);
        Map sortedItemUpdateAnimationRules = ITEM_UPDATE_ANIMATION_RULES_BY_IDENTIFIER.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((ItemUpdateAnimationRule)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (class_2960 ruleIdentifier : sortedItemUpdateAnimationRules.keySet()) {
            ItemUpdateAnimationRule rule = (ItemUpdateAnimationRule)sortedItemUpdateAnimationRules.get(ruleIdentifier);
            if (!rule.shouldPlayAnimation.test(context)) continue;
            LocomotionMain.DEBUG_LOGGER.info("Playing item update animation \"{}\"", (Object)ruleIdentifier);
            MontageConfiguration montage = rule.montageProvider.apply(hand);
            for (String slot : montage.slots()) {
                montageManager.interruptMontagesInSlot(slot, Transition.builder(TimeSpan.ofSeconds(0.2f)).build());
            }
            montageManager.playMontage(rule.montageProvider.apply(hand));
            class_2960 renderedItemHandPose = FirstPersonHandPoses.testForNextHandPose(renderedItem, hand);
            class_2960 currentItemHandPose = FirstPersonHandPoses.testForNextHandPose(actualItem, hand);
            if (currentItemHandPose == renderedItemHandPose) {
                FirstPersonDrivers.updateRenderedItem(driverContainer, hand);
            }
            return;
        }
    }

    public record ItemUpdateAnimationConditionContext(class_1799 currentItem, class_1799 previousItem) {
        boolean bothItemsMeetPredicate(Predicate<class_1799> predicate) {
            return predicate.test(this.currentItem) && predicate.test(this.previousItem);
        }
    }

    public record ItemUpdateAnimationRule(Function<class_1268, MontageConfiguration> montageProvider, Predicate<ItemUpdateAnimationConditionContext> shouldPlayAnimation, int evaluationPriority) {
        public static ItemUpdateAnimationRule of(Function<class_1268, MontageConfiguration> montageProvider, Predicate<ItemUpdateAnimationConditionContext> shouldPlayAnimation, int evaluationPriority) {
            return new ItemUpdateAnimationRule(montageProvider, shouldPlayAnimation, evaluationPriority);
        }
    }
}

