/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMining;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.MakeDynamicAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageSlotFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateMachineFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Set;
import net.minecraft.class_12123;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_746;
import net.minecraft.class_9334;

public class FirstPersonSpear {
    public static String CHARGE_IDLE_STATE = "idle";
    public static String CHARGE_ENTER_STATE = "enter";
    public static String CHARGE_STAGE_1_STATE = "stage_1";
    public static String CHARGE_STAGE_1_TO_2_STATE = "stage_1_to_2";
    public static String CHARGE_STAGE_2_STATE = "stage_2";
    public static String CHARGE_STAGE_2_TO_3_STATE = "stage_2_to_3";
    public static String CHARGE_STAGE_3_STATE = "stage_3";
    public static String CHARGE_EXIT_STATE = "exit";

    public static PoseFunction<LocalSpacePose> constructSpearPoseFunction(CachedPoseContainer cachedPoseContainer, class_1268 hand) {
        PoseFunction<LocalSpacePose> pose = FirstPersonSpear.constructChargePoseFunction(cachedPoseContainer, hand);
        pose = FirstPersonSpear.constructWithSpearImpact(pose);
        return pose;
    }

    private static PoseFunction<LocalSpacePose> constructWithSpearImpact(PoseFunction<LocalSpacePose> inputPose) {
        SequenceEvaluatorFunction basePose = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_POSE_1).build();
        PoseFunction<LocalSpacePose> pose = MontageSlotFunction.of(basePose, "spear_charge");
        pose = MakeDynamicAdditiveFunction.of(pose, basePose);
        pose = ApplyAdditiveFunction.of(inputPose, pose);
        return pose;
    }

    private static PoseFunction<LocalSpacePose> constructChargePoseFunction(CachedPoseContainer cachedPoseContainer, class_1268 hand) {
        PoseFunction<LocalSpacePose> chargeIdlePose = FirstPersonMining.makeMainHandPickaxeMiningPoseFunction(cachedPoseContainer, hand);
        SequencePlayerFunction chargeEnterPose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_ENTER).build();
        SequencePlayerFunction chargeExitPose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_EXIT).build();
        SequencePlayerFunction chargeStage1Pose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_POSE_1).build();
        SequencePlayerFunction chargeStage2Pose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_POSE_2).build();
        SequencePlayerFunction chargeStage3Pose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_POSE_3).build();
        SequencePlayerFunction chargeStage1To2Pose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_WEAKEN_1).build();
        SequencePlayerFunction chargeStage2To3Pose = SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_SPEAR_CHARGE_WEAKEN_2).build();
        PoseFunction<LocalSpacePose> chargeStateMachinePose = StateMachineFunction.builder(evaluationState -> CHARGE_IDLE_STATE).resetsUponRelevant(true).defineState(StateDefinition.builder(CHARGE_IDLE_STATE, chargeIdlePose).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(CHARGE_ENTER_STATE, chargeEnterPose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CHARGE_STAGE_1_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).defineState(StateDefinition.builder(CHARGE_STAGE_1_STATE, chargeStage1Pose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CHARGE_STAGE_1_TO_2_STATE).isTakenIfTrue(FirstPersonSpear::spearCanNoLongerDismount).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).defineState(StateDefinition.builder(CHARGE_STAGE_1_TO_2_STATE, chargeStage1To2Pose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CHARGE_STAGE_2_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).defineState(StateDefinition.builder(CHARGE_STAGE_2_STATE, chargeStage2Pose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CHARGE_STAGE_2_TO_3_STATE).isTakenIfTrue(FirstPersonSpear::spearCanNoLongerKnockback).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).defineState(StateDefinition.builder(CHARGE_STAGE_2_TO_3_STATE, chargeStage2To3Pose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CHARGE_STAGE_3_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).defineState(StateDefinition.builder(CHARGE_STAGE_3_STATE, chargeStage3Pose).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(CHARGE_EXIT_STATE, chargeExitPose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CHARGE_IDLE_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(20.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).setCanInterruptOtherTransitions(false).build()).build()).addStateAlias(StateAlias.builder(Set.of(CHARGE_STAGE_1_STATE, CHARGE_STAGE_2_STATE, CHARGE_STAGE_3_STATE, CHARGE_STAGE_1_TO_2_STATE, CHARGE_STAGE_2_TO_3_STATE, CHARGE_ENTER_STATE)).addOutboundTransition(StateTransition.builder(CHARGE_EXIT_STATE).isTakenIfTrue(FirstPersonSpear::spearCanNoLongerDamage).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(10.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).addStateAlias(StateAlias.builder(Set.of(CHARGE_EXIT_STATE, CHARGE_IDLE_STATE)).addOutboundTransition(StateTransition.builder(CHARGE_ENTER_STATE).isTakenIfTrue(context -> FirstPersonSpear.isUsingSpear(context, hand)).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(60).setCanInterruptOtherTransitions(false).build()).build()).build();
        return chargeStateMachinePose;
    }

    public static boolean isUsingSpear(StateTransition.TransitionContext context, class_1268 hand) {
        boolean isUsing = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getUsingItemDriver(hand));
        boolean handPoseIsSpear = context.driverContainer().getDriverValue(FirstPersonDrivers.getHandPoseDriver(hand)) == FirstPersonHandPoses.SPEAR;
        boolean spearCanDamage = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.SPEAR_CAN_DAMAGE);
        return isUsing && handPoseIsSpear && spearCanDamage;
    }

    public static boolean spearCanNoLongerDismount(StateTransition.TransitionContext context) {
        boolean spearCanDismount = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.SPEAR_CAN_DISMOUNT);
        return !spearCanDismount;
    }

    public static boolean spearCanNoLongerKnockback(StateTransition.TransitionContext context) {
        boolean spearCanKnockback = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.SPEAR_CAN_KNOCKBACK);
        return !spearCanKnockback;
    }

    public static boolean spearCanNoLongerDamage(StateTransition.TransitionContext context) {
        boolean spearCanDamage = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.SPEAR_CAN_DAMAGE);
        return !spearCanDamage;
    }

    public static void extractSpearData(class_746 player, OnTickDriverContainer driverContainer, MontageManager montageManager) {
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemStack = player.method_5998(hand);
            class_12123 kineticWeapon = (class_12123)itemStack.method_58694(class_9334.field_63632);
            if (kineticWeapon == null) continue;
            int spearUseDuration = itemStack.method_7935((class_1309)player) - (player.method_6014() + 1);
            int delayTicks = kineticWeapon.comp_4957();
            driverContainer.getDriver(FirstPersonDrivers.SPEAR_CAN_DISMOUNT).setValue((float)spearUseDuration < kineticWeapon.comp_4958().map(class_12123.class_12124::comp_4965).orElse(0).floatValue() - (float)delayTicks);
            driverContainer.getDriver(FirstPersonDrivers.SPEAR_CAN_KNOCKBACK).setValue((float)spearUseDuration < kineticWeapon.comp_4959().map(class_12123.class_12124::comp_4965).orElse(0).floatValue() - (float)delayTicks);
            driverContainer.getDriver(FirstPersonDrivers.SPEAR_CAN_DAMAGE).setValue((float)spearUseDuration < kineticWeapon.comp_4960().map(class_12123.class_12124::comp_4965).orElse(0).floatValue() - (float)delayTicks);
            int ticksSinceLastSpearImpact = (int)player.method_75879(0.0f);
            if (ticksSinceLastSpearImpact != 1) continue;
            montageManager.playMontage(FirstPersonMontages.SPEAR_CHARGE_IMPACT_MONTAGE);
        }
    }
}

