/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.driver.TriggerDriver;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5953;
import net.minecraft.class_5955;

public class FirstPersonUseAnimations {
    private static final Map<class_2960, UseAnimationRule> USE_ANIMATION_RULES_BY_LOCATION = Maps.newHashMap();
    public static final class_2960 DEFAULT = FirstPersonUseAnimations.register(LocomotionMain.makeIdentifier("default"), UseAnimationRule.of(FirstPersonMontages::getUseAnimationMontage, UseAnimationConditionContext::swingFromClient, 0));
    public static final class_2960 AXE_SCRAPE = FirstPersonUseAnimations.register(LocomotionMain.makeIdentifier("axe_scrape"), UseAnimationRule.of(FirstPersonMontages::getAxeScrapeMontage, FirstPersonUseAnimations::shouldPlayAxeScrape, 10));
    public static final class_2960 HOE_TILL = FirstPersonUseAnimations.register(LocomotionMain.makeIdentifier("hoe_till"), UseAnimationRule.of(FirstPersonMontages::getHoeTillMontage, FirstPersonUseAnimations::shouldPlayHoeTill, 20));
    public static final class_2960 SHOVEL_FLATTEN = FirstPersonUseAnimations.register(LocomotionMain.makeIdentifier("shovel_flatten"), UseAnimationRule.of(FirstPersonMontages::getShovelFlattenMontage, FirstPersonUseAnimations::shouldPlayShovelFlatten, 30));
    public static final class_2960 SHEARS_USE = FirstPersonUseAnimations.register(LocomotionMain.makeIdentifier("shears_use"), UseAnimationRule.of(FirstPersonMontages::getShearsUseMontage, FirstPersonUseAnimations::shouldPlayShearsUse, 40));
    private static final List<class_2248> TILLABLES = List.of(class_2246.field_10219, class_2246.field_10194, class_2246.field_10566, class_2246.field_10253, class_2246.field_28685);
    private static final List<class_2248> FLATTENABLES = List.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10520, class_2246.field_10253, class_2246.field_10402, class_2246.field_28685);

    private static boolean shouldPlayAxeScrape(UseAnimationConditionContext context) {
        if (!context.currentItem.method_31573(class_3489.field_42612) || !context.isTargetingBlock()) {
            return false;
        }
        if (class_5955.method_34735((class_2680)context.lastTargetedBlock()).isPresent()) {
            return true;
        }
        if (((BiMap)class_5953.field_29561.get()).get((Object)context.lastTargetedBlock().method_26204()) != null) {
            return true;
        }
        if (context.lastTargetedBlock().method_26204().method_8389().method_7854().method_31573(class_3489.field_15539)) {
            return true;
        }
        return context.lastTargetedBlock().method_26204() == class_2246.field_41072;
    }

    private static boolean shouldPlayHoeTill(UseAnimationConditionContext context) {
        if (!context.currentItem.method_31573(class_3489.field_42613) || !context.isTargetingBlock()) {
            return false;
        }
        return TILLABLES.contains(context.lastTargetedBlock().method_26204());
    }

    private static boolean shouldPlayShovelFlatten(UseAnimationConditionContext context) {
        if (!context.currentItem.method_31573(class_3489.field_42615) || !context.isTargetingBlock()) {
            return false;
        }
        return FLATTENABLES.contains(context.lastTargetedBlock().method_26204());
    }

    private static boolean shouldPlayShearsUse(UseAnimationConditionContext context) {
        return context.currentItem.method_31574(class_1802.field_8868) && context.useAnimationType() == UseAnimationType.INTERACT_ENTITY;
    }

    public static class_2960 register(class_2960 identifier, UseAnimationRule useAnimationRule) {
        USE_ANIMATION_RULES_BY_LOCATION.put(identifier, useAnimationRule);
        return identifier;
    }

    public static void playUseAnimationIfTriggered(OnTickDriverContainer driverContainer, MontageManager montageManager, class_1268 hand) {
        boolean swingTimeIsOne;
        TriggerDriver hasUsedItemDriver = driverContainer.getDriver(FirstPersonDrivers.getHasUsedItemDriver(hand));
        TriggerDriver hasAttackedDriver = driverContainer.getDriver(FirstPersonDrivers.HAS_ATTACKED);
        int swingTime = (Integer)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_SWING_TIME);
        class_1268 lastUsedHand = (class_1268)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_HAND);
        boolean bl = swingTimeIsOne = swingTime == 1;
        if (lastUsedHand != hand) {
            return;
        }
        boolean shouldPlayUseAnimationThisTick = hasUsedItemDriver.hasBeenTriggeredAndNotConsumed();
        if (!shouldPlayUseAnimationThisTick) {
            return;
        }
        hasUsedItemDriver.consume();
        class_1799 renderedItem = (class_1799)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand));
        class_1799 actualItem = (class_1799)driverContainer.getDriverValue(FirstPersonDrivers.getItemDriver(hand));
        UseAnimationType useAnimationType = (UseAnimationType)((Object)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USE_TYPE));
        class_2680 lastTargetedBlock = (class_2680)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_TARGET_BLOCK_STATE);
        class_1299 lastTargetedEntity = (class_1299)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_TARGET_ENTITY);
        boolean lastSwingFromClient = (Boolean)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_SWING_FROM_CLIENT);
        UseAnimationConditionContext context = new UseAnimationConditionContext(useAnimationType, actualItem, useAnimationType == UseAnimationType.USE_ITEM_ON_BLOCK, useAnimationType == UseAnimationType.INTERACT_ENTITY || useAnimationType == UseAnimationType.INTERACT_AT_ENTITY, lastTargetedBlock, lastTargetedEntity, lastSwingFromClient);
        Map sortedUseAnimationRules = USE_ANIMATION_RULES_BY_LOCATION.entrySet().stream().sorted(Comparator.comparingInt(entry -> -((UseAnimationRule)entry.getValue()).evaluationPriority())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (class_2960 ruleIdentifier : sortedUseAnimationRules.keySet()) {
            UseAnimationRule rule = (UseAnimationRule)sortedUseAnimationRules.get(ruleIdentifier);
            if (!rule.shouldChooseUseAnimation.test(context)) continue;
            LocomotionMain.DEBUG_LOGGER.info("Playing use animation \"{}\"", (Object)ruleIdentifier);
            montageManager.playMontage(rule.montageProvider.apply(hand));
            class_2960 renderedItemHandPose = FirstPersonHandPoses.testForNextHandPose(renderedItem, hand);
            class_2960 currentItemHandPose = FirstPersonHandPoses.testForNextHandPose(actualItem, hand);
            if (currentItemHandPose == renderedItemHandPose) {
                FirstPersonDrivers.updateRenderedItem(driverContainer, hand);
            }
            return;
        }
    }

    public static void triggerUseAnimation(class_1268 hand, UseAnimationType useAnimationType, class_1269.class_9861 swingSource) {
        Optional<AnimationDataContainer> optional = JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer();
        if (optional.isEmpty()) {
            return;
        }
        AnimationDataContainer dataContainer = optional.get();
        dataContainer.getDriver(FirstPersonDrivers.getHasUsedItemDriver(hand)).trigger();
        dataContainer.getDriver(FirstPersonDrivers.LAST_USE_TYPE).setValue(useAnimationType);
        dataContainer.getDriver(FirstPersonDrivers.LAST_USED_HAND).setValue(hand);
        dataContainer.getDriver(FirstPersonDrivers.LAST_USED_SWING_FROM_CLIENT).setValue(swingSource == class_1269.class_9861.field_52427);
    }

    public static void updateUseAnimationHitResults(AnimationDataContainer dataContainer) {
        class_239 hitResult = class_310.method_1551().field_1765;
        assert (hitResult != null);
        if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            if (class_310.method_1551().field_1687 != null) {
                class_2680 blockState = class_310.method_1551().field_1687.method_8320(blockHitResult.method_17777());
                dataContainer.getDriver(FirstPersonDrivers.LAST_USED_TARGET_BLOCK_STATE).setValue(blockState);
            }
        }
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            class_1299 entityType = entityHitResult.method_17782().method_5864();
            dataContainer.getDriver(FirstPersonDrivers.LAST_USED_TARGET_ENTITY).setValue(entityType);
        }
    }

    public record UseAnimationConditionContext(UseAnimationType useAnimationType, class_1799 currentItem, boolean isTargetingBlock, boolean isTargetingEntity, class_2680 lastTargetedBlock, class_1299<?> lastTargetedEntity, boolean swingFromClient) {
        public boolean isTargetingBlockOrEntity() {
            return this.isTargetingBlock || this.isTargetingEntity;
        }
    }

    public static enum UseAnimationType {
        INTERACT_ENTITY,
        INTERACT_AT_ENTITY,
        USE_ITEM,
        USE_ITEM_ON_BLOCK;

    }

    public record UseAnimationRule(Function<class_1268, MontageConfiguration> montageProvider, Predicate<UseAnimationConditionContext> shouldChooseUseAnimation, int evaluationPriority) {
        public static UseAnimationRule of(Function<class_1268, MontageConfiguration> montageProvider, Predicate<UseAnimationConditionContext> shouldChooseUseAnimation, int evaluationPriority) {
            return new UseAnimationRule(montageProvider, shouldChooseUseAnimation, evaluationPriority);
        }
    }
}

