/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.driver;

import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.Interpolator;
import com.trainguy9512.locomotion.util.TimeSpan;
import java.util.function.Supplier;

public class TimerDriver
extends VariableDriver<Float> {
    private float incrementPerTick;
    private Easing easing;
    private final float minValue;
    private final float maxValue;

    protected TimerDriver(Supplier<Float> initialValue, float incrementPerTick, Easing easing, float minValue, float maxValue) {
        super(initialValue, Interpolator.FLOAT);
        this.incrementPerTick = incrementPerTick;
        this.easing = easing;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public static Builder builder(Supplier<Float> initialValue) {
        return new Builder(initialValue);
    }

    public void setIncrementPerTick(float incrementPerTick) {
        this.incrementPerTick = incrementPerTick;
    }

    public void setIncrementPerTick(TimeSpan timeToIncrementFully, float target) {
        this.incrementPerTick = 1.0f / target / timeToIncrementFully.inTicks();
    }

    @Override
    public Float getValueInterpolated(float partialTicks) {
        return Float.valueOf(this.easing.ease(((Float)super.getValueInterpolated(partialTicks)).floatValue()));
    }

    @Override
    public void setValue(Float newValue) {
        super.setValue(Float.valueOf(Math.clamp(newValue.floatValue(), this.minValue, this.maxValue)));
    }

    @Override
    public void postTick() {
        this.setValue(Float.valueOf(((Float)this.currentValue).floatValue() + this.incrementPerTick));
    }

    public static class Builder {
        private final Supplier<Float> initialValue;
        private float incrementPerTick;
        private Easing easing;
        private float minValue;
        private float maxValue;

        private Builder(Supplier<Float> initialValue) {
            this.initialValue = initialValue;
            this.incrementPerTick = 1.0f;
            this.easing = Easing.LINEAR;
            this.minValue = -3.4028235E38f;
            this.maxValue = Float.MAX_VALUE;
        }

        public Builder setInitialIncrement(float incrementPerTick) {
            this.incrementPerTick = incrementPerTick;
            return this;
        }

        public Builder setEasing(Easing easing) {
            this.easing = easing;
            return this;
        }

        public Builder setMinValue(float minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder setMaxValue(float maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public TimerDriver build() {
            return new TimerDriver(this.initialValue, this.incrementPerTick, this.easing, this.minValue, this.maxValue);
        }
    }
}

