/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.driver;

import com.trainguy9512.locomotion.animation.driver.Driver;
import com.trainguy9512.locomotion.util.Interpolator;
import java.text.DecimalFormat;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class VariableDriver<D>
implements Driver<D> {
    protected final Supplier<D> initialValue;
    protected final Interpolator<D> interpolator;
    protected D currentValue;
    protected D previousValue;

    protected VariableDriver(Supplier<D> initialValue, Interpolator<D> interpolator) {
        this.initialValue = initialValue;
        this.interpolator = interpolator;
        this.currentValue = initialValue.get();
        this.previousValue = initialValue.get();
    }

    @Override
    public void tick() {
    }

    @Override
    public D getValueInterpolated(float partialTicks) {
        return this.interpolator.interpolate(this.previousValue, this.currentValue, partialTicks);
    }

    public D getPreviousValue() {
        return this.previousValue;
    }

    public D getCurrentValue() {
        return this.currentValue;
    }

    public void setValue(D newValue) {
        this.currentValue = newValue != null ? newValue : this.initialValue.get();
    }

    public void modifyValue(Function<D, D> valueModifier) {
        this.currentValue = valueModifier.apply(this.currentValue);
    }

    @Override
    public void pushCurrentToPrevious() {
        this.previousValue = this.currentValue;
    }

    @Override
    public void postTick() {
    }

    public void reset() {
        this.setValue(this.initialValue.get());
    }

    public void hardReset() {
        this.reset();
        this.pushCurrentToPrevious();
    }

    public boolean hasValueChanged() {
        return !this.currentValue.equals(this.previousValue);
    }

    public static <D> VariableDriver<D> ofInterpolatable(Supplier<D> defaultValue, Interpolator<D> interpolator) {
        return new VariableDriver<D>(defaultValue, interpolator);
    }

    public static <D> VariableDriver<D> ofConstant(Supplier<D> defaultValue) {
        return VariableDriver.ofInterpolatable(defaultValue, Interpolator.constantBlend());
    }

    public static VariableDriver<Boolean> ofBoolean(Supplier<Boolean> defaultValue) {
        return VariableDriver.ofInterpolatable(defaultValue, Interpolator.BOOLEAN_BLEND);
    }

    public static VariableDriver<Float> ofFloat(@Nullable Supplier<Float> defaultValue) {
        return VariableDriver.ofInterpolatable(defaultValue, Interpolator.FLOAT);
    }

    public static VariableDriver<Integer> ofInteger(Supplier<Integer> defaultValue) {
        return VariableDriver.ofConstant(defaultValue);
    }

    public static VariableDriver<Vector3f> ofVector(Supplier<Vector3f> defaultValue) {
        return VariableDriver.ofInterpolatable(defaultValue, Interpolator.VECTOR_FLOAT);
    }

    public String toString() {
        Object currentValueString = this.currentValue.toString();
        DecimalFormat format = new DecimalFormat("0.00");
        D d = this.currentValue;
        if (d instanceof Float) {
            Float value = (Float)d;
            currentValueString = format.format(value);
        } else {
            d = this.currentValue;
            if (d instanceof Vector3f) {
                Vector3f value = (Vector3f)d;
                currentValueString = "(" + format.format(value.x) + " " + format.format(value.y) + " " + format.format(value.z) + ")";
            }
        }
        return currentValueString;
    }

    @Override
    public String getChatFormattedString() {
        return this.toString();
    }
}

