/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.joint.skeleton;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.animation.joint.skeleton.SkeletonPropertyDefinition;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3532;

public class BlendMask
extends SkeletonPropertyDefinition<Float> {
    private BlendMask(Map<String, Float> jointProperties, Map<String, Float> customAttributeProperties, boolean mirrored) {
        super(jointProperties, customAttributeProperties, mirrored, Float.valueOf(0.0f));
    }

    @Override
    public SkeletonPropertyDefinition<Float> getMirrored() {
        return new BlendMask(this.jointProperties, this.customAttributeProperties, !this.isMirrored);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Float> jointWeights = Maps.newHashMap();
        private final Map<String, Float> customAttributeWeights = Maps.newHashMap();

        public Builder defineForJoint(String jointName, float weight) {
            this.jointWeights.put(jointName, Float.valueOf(class_3532.method_15363((float)weight, (float)0.0f, (float)1.0f)));
            return this;
        }

        public Builder defineForMultipleJoints(Set<String> jointNames, float weight) {
            jointNames.forEach(jointName -> this.defineForJoint((String)jointName, weight));
            return this;
        }

        public Builder defineForCustomAttribute(String customAttributeName, float weight) {
            this.jointWeights.put(customAttributeName, Float.valueOf(class_3532.method_15363((float)weight, (float)0.0f, (float)1.0f)));
            return this;
        }

        public Builder defineForMultipleCustomAttributes(Set<String> customAttributeNames, float weight) {
            customAttributeNames.forEach(jointName -> this.defineForJoint((String)jointName, weight));
            return this;
        }

        public BlendMask build() {
            return new BlendMask(this.jointWeights, this.customAttributeWeights, false);
        }
    }
}

