/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class MakeDynamicAdditiveFunction
implements PoseFunction<LocalSpacePose> {
    private final PoseFunction<LocalSpacePose> additivePoseInput;
    private final PoseFunction<LocalSpacePose> basePoseInput;

    public MakeDynamicAdditiveFunction(PoseFunction<LocalSpacePose> additivePoseInput, PoseFunction<LocalSpacePose> basePoseInput) {
        this.additivePoseInput = additivePoseInput;
        this.basePoseInput = basePoseInput;
    }

    public static MakeDynamicAdditiveFunction of(PoseFunction<LocalSpacePose> additivePoseInput, PoseFunction<LocalSpacePose> basePoseInput) {
        return new MakeDynamicAdditiveFunction(additivePoseInput, basePoseInput);
    }

    @Override
    @NotNull
    public LocalSpacePose compute(PoseFunction.FunctionInterpolationContext context) {
        LocalSpacePose additivePose = this.additivePoseInput.compute(context);
        LocalSpacePose additivePoseReference = this.basePoseInput.compute(context);
        additivePoseReference.invert();
        additivePose.multiply(additivePoseReference, JointChannel.TransformSpace.COMPONENT);
        return additivePose;
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
        this.additivePoseInput.tick(evaluationState);
        this.basePoseInput.tick(evaluationState);
    }

    @Override
    public PoseFunction<LocalSpacePose> wrapUnique() {
        return new MakeDynamicAdditiveFunction(this.additivePoseInput.wrapUnique(), this.basePoseInput.wrapUnique());
    }

    @Override
    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> findCondition) {
        if (findCondition.test(this)) {
            return Optional.of(this);
        }
        Optional<PoseFunction<?>> test = this.additivePoseInput.searchDownChainForMostRelevant(findCondition);
        if (test.isPresent()) {
            return test;
        }
        return this.basePoseInput.searchDownChainForMostRelevant(findCondition);
    }
}

