/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.data.PoseCalculationDataContainer;
import com.trainguy9512.locomotion.animation.pose.Pose;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.util.TimeSpan;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public interface PoseFunction<P extends Pose> {
    @NotNull
    public P compute(FunctionInterpolationContext var1);

    public void tick(FunctionEvaluationState var1);

    public PoseFunction<P> wrapUnique();

    public Optional<PoseFunction<?>> searchDownChainForMostRelevant(Predicate<PoseFunction<?>> var1);

    public record FunctionInterpolationContext(PoseCalculationDataContainer driverContainer, MontageManager montageManager, float partialTicks, TimeSpan gameTime) {
        public static FunctionInterpolationContext of(PoseCalculationDataContainer dataContainer, MontageManager montageManager, float partialTicks, TimeSpan gameTime) {
            return new FunctionInterpolationContext(dataContainer, montageManager, partialTicks, gameTime);
        }
    }

    public record FunctionEvaluationState(OnTickDriverContainer driverContainer, MontageManager montageManager, boolean resetting, long currentTick) {
        public static FunctionEvaluationState of(OnTickDriverContainer driverContainer, MontageManager montageManager, boolean resetting, long currentTick) {
            return new FunctionEvaluationState(driverContainer, montageManager, resetting, currentTick);
        }

        public FunctionEvaluationState markedForReset() {
            return FunctionEvaluationState.of(this.driverContainer, this.montageManager, true, this.currentTick);
        }

        public FunctionEvaluationState cleared() {
            return FunctionEvaluationState.of(this.driverContainer, this.montageManager, false, this.currentTick);
        }

        public void ifMarkedForReset(Runnable runnable) {
            if (this.resetting) {
                runnable.run();
            }
        }
    }
}

