/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function;

import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.animation.pose.Pose;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.util.TimeSpan;
import java.util.function.Function;

public abstract class TimeBasedPoseFunction<P extends Pose>
implements PoseFunction<P> {
    protected final Function<PoseFunction.FunctionEvaluationState, Boolean> isPlayingFunction;
    protected final Function<PoseFunction.FunctionEvaluationState, Float> playRateFunction;
    protected final TimeSpan resetStartTimeOffset;
    protected final VariableDriver<Float> ticksElapsed;
    protected float playRate;
    protected boolean isPlaying;

    protected TimeBasedPoseFunction(Function<PoseFunction.FunctionEvaluationState, Boolean> isPlayingFunction, Function<PoseFunction.FunctionEvaluationState, Float> playRateFunction, TimeSpan resetStartTimeOffset) {
        this.isPlayingFunction = isPlayingFunction;
        this.playRateFunction = playRateFunction;
        this.resetStartTimeOffset = resetStartTimeOffset;
        this.ticksElapsed = VariableDriver.ofFloat(this.resetStartTimeOffset::inTicks);
    }

    @Override
    public void tick(PoseFunction.FunctionEvaluationState evaluationState) {
        this.isPlaying = this.isPlayingFunction.apply(evaluationState);
        this.playRate = this.isPlaying ? this.playRateFunction.apply(evaluationState).floatValue() : 0.0f;
        this.updateTime(evaluationState);
    }

    protected void updateTime(PoseFunction.FunctionEvaluationState evaluationState) {
        this.ticksElapsed.pushCurrentToPrevious();
        evaluationState.ifMarkedForReset(this::resetTime);
        if (this.isPlaying) {
            this.ticksElapsed.modifyValue(currentValue -> Float.valueOf(currentValue.floatValue() + this.playRate));
        }
    }

    protected void resetTime() {
        this.ticksElapsed.hardReset();
    }

    protected TimeSpan getInterpolatedTimeElapsed(PoseFunction.FunctionInterpolationContext context) {
        return TimeSpan.ofTicks(this.ticksElapsed.getValueInterpolated(context.partialTicks()).floatValue());
    }

    public static class Builder<B> {
        protected Function<PoseFunction.FunctionEvaluationState, Float> playRateFunction = interpolationContext -> Float.valueOf(1.0f);
        protected Function<PoseFunction.FunctionEvaluationState, Boolean> isPlayingFunction = interpolationContext -> true;
        protected TimeSpan resetStartTimeOffsetTicks = TimeSpan.ZERO;

        protected Builder() {
        }

        public B setPlayRate(Function<PoseFunction.FunctionEvaluationState, Float> playRateFunction) {
            this.playRateFunction = playRateFunction;
            return (B)this;
        }

        public B setPlayRate(float playRate) {
            this.playRateFunction = evaluationState -> Float.valueOf(playRate);
            return (B)this;
        }

        public B setIsPlaying(Function<PoseFunction.FunctionEvaluationState, Boolean> isPlayingFunction) {
            this.isPlayingFunction = isPlayingFunction;
            return (B)this;
        }

        public B setResetStartTimeOffset(TimeSpan startTimeOffset) {
            this.resetStartTimeOffsetTicks = startTimeOffset;
            return (B)this;
        }
    }
}

