/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.pose.function.montage;

import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.resource.LocomotionResources;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;

public class MontageManager {
    private final AnimationDataContainer animationDataContainer;
    private final List<MontageInstance> montageStack;

    public MontageManager(AnimationDataContainer animationDataContainer) {
        this.animationDataContainer = animationDataContainer;
        this.montageStack = new ArrayList<MontageInstance>();
    }

    public void tick() {
        this.montageStack.forEach(MontageInstance::tick);
        this.montageStack.removeIf(montageInstance -> montageInstance.ticksElapsed.getPreviousValue().floatValue() > montageInstance.tickLength + (1.0f - montageInstance.configuration.transitionOutCrossfadeWeight()) * montageInstance.configuration.transitionOut().duration().inTicks());
        this.montageStack.removeIf(montageInstance -> {
            if (montageInstance.hasBeenInterrupted) {
                return montageInstance.ticksElapsed.getPreviousValue().floatValue() - montageInstance.interruptTick > montageInstance.interruptTransition.duration().inTicks();
            }
            return false;
        });
    }

    public static MontageManager of(AnimationDataContainer animationDataContainer) {
        return new MontageManager(animationDataContainer);
    }

    public void playMontage(MontageConfiguration configuration) {
        for (MontageInstance instance : this.montageStack) {
            if (!Objects.equals(instance.configuration.identifier(), configuration.identifier()) || !(instance.ticksElapsed.getCurrentValue().floatValue() < configuration.cooldownDuration().inTicks())) continue;
            return;
        }
        this.montageStack.addLast(MontageInstance.of(configuration, this.animationDataContainer));
    }

    public void interruptMontagesInSlot(String slot, Transition transition) {
        for (MontageInstance montageInstance : this.montageStack) {
            if (!montageInstance.configuration.slots().contains(slot)) continue;
            montageInstance.interrupt(transition);
        }
    }

    public boolean isMontagePlaying(String identifier) {
        for (MontageInstance montageInstance : this.montageStack) {
            if (!montageInstance.configuration.identifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnythingPlayingInSlot(String slot) {
        for (MontageInstance montageInstance : this.montageStack) {
            if (!montageInstance.configuration.slots().contains(slot)) continue;
            return true;
        }
        return false;
    }

    public LocalSpacePose getLayeredSlotPose(LocalSpacePose basePose, String slot, JointSkeleton jointSkeleton, float partialTicks) {
        LocalSpacePose slotPose = LocalSpacePose.of(basePose);
        LocalSpacePose previousPose = LocalSpacePose.of(basePose);
        for (MontageInstance montageInstance : this.montageStack) {
            if (!montageInstance.configuration.slots().contains(slot)) continue;
            float weight = montageInstance.getWeight(partialTicks);
            Transition transition = montageInstance.isInEntranceTransition(partialTicks) ? montageInstance.configuration.transitionIn() : montageInstance.configuration.transitionOut().withInverseEasing();
            slotPose.interpolatedByTransition(montageInstance.getPose(jointSkeleton, partialTicks), weight, transition, montageInstance.configuration.blendMask());
            if (montageInstance.hasBeenInterrupted) {
                slotPose.interpolatedByTransition(previousPose, montageInstance.getInterruptWeight(partialTicks), montageInstance.interruptTransition, null);
            }
            previousPose = LocalSpacePose.of(slotPose);
        }
        return slotPose;
    }

    public boolean areAnyMontagesInSlotFullyOverriding(String slot) {
        for (MontageInstance montageInstance : this.montageStack) {
            if (!montageInstance.configuration.slots().contains(slot)) break;
            if (!montageInstance.getWeightIsFull(1.0f) || !montageInstance.getWeightIsFull(0.0f)) continue;
            return true;
        }
        return false;
    }

    private static class MontageInstance {
        private final VariableDriver<Float> ticksElapsed = VariableDriver.ofFloat(() -> Float.valueOf(configuration.startTimeOffset().inTicks()));
        private final MontageConfiguration configuration;
        private final float playRate;
        private final float tickLength;
        private boolean hasBeenInterrupted;
        private float interruptTick;
        private Transition interruptTransition;
        private final class_2960 additiveBasePoseLocation;
        private LocalSpacePose additiveBasePose;
        private LocalSpacePose additiveSubtractionPose;

        private MontageInstance(MontageConfiguration configuration, OnTickDriverContainer driverContainer) {
            this.configuration = configuration;
            this.playRate = configuration.playRateFunction().apply(driverContainer).floatValue();
            this.tickLength = LocomotionResources.getOrThrowAnimationSequence(configuration.animationSequence()).length().inTicks();
            this.hasBeenInterrupted = false;
            this.interruptTick = 0.0f;
            this.interruptTransition = Transition.INSTANT;
            this.additiveBasePoseLocation = configuration.isAdditive() ? configuration.additiveBasePoseProvider().apply(driverContainer) : null;
            this.additiveBasePose = null;
            this.additiveSubtractionPose = null;
        }

        private static MontageInstance of(MontageConfiguration configuration, OnTickDriverContainer driverContainer) {
            return new MontageInstance(configuration, driverContainer);
        }

        private void tick() {
            this.ticksElapsed.pushCurrentToPrevious();
            this.ticksElapsed.modifyValue(currentValue -> Float.valueOf(currentValue.floatValue() + this.playRate));
        }

        private void interrupt(Transition transition) {
            if (!this.hasBeenInterrupted) {
                this.hasBeenInterrupted = true;
                this.interruptTransition = transition;
                this.interruptTick = this.ticksElapsed.getCurrentValue().floatValue();
            }
        }

        private boolean getWeightIsFull(float partialTicks) {
            float interpolatedTimeElapsed = this.ticksElapsed.getValueInterpolated(partialTicks).floatValue();
            if (interpolatedTimeElapsed > this.configuration.startTimeOffset().inTicks() + this.configuration.transitionIn().duration().inTicks() && interpolatedTimeElapsed < this.tickLength - this.configuration.transitionOut().duration().inTicks() * this.configuration.transitionOutCrossfadeWeight()) {
                return !this.hasBeenInterrupted;
            }
            return false;
        }

        private LocalSpacePose getPose(JointSkeleton jointSkeleton, float partialTicks) {
            LocalSpacePose pose = AnimationSequence.samplePose(jointSkeleton, this.configuration.animationSequence(), TimeSpan.ofTicks(this.ticksElapsed.getValueInterpolated(partialTicks).floatValue()), false);
            if (this.configuration.isAdditive()) {
                if (this.additiveBasePose == null) {
                    this.additiveBasePose = AnimationSequence.samplePose(jointSkeleton, this.additiveBasePoseLocation, TimeSpan.ofTicks(0.0f), false);
                }
                if (this.additiveSubtractionPose == null) {
                    this.additiveSubtractionPose = AnimationSequence.samplePose(jointSkeleton, this.configuration.animationSequence(), this.configuration.startTimeOffset(), false);
                    this.additiveSubtractionPose.invert();
                }
                pose.multiply(this.additiveSubtractionPose, JointChannel.TransformSpace.COMPONENT);
                pose.multiply(this.additiveBasePose, JointChannel.TransformSpace.COMPONENT);
            }
            return pose;
        }

        private boolean isInEntranceTransition(float partialTicks) {
            float entranceTransitionEndTime;
            float elapsedTicksInterpolated = this.ticksElapsed.getValueInterpolated(partialTicks).floatValue();
            return elapsedTicksInterpolated < (entranceTransitionEndTime = this.configuration.startTimeOffset().inTicks() + this.configuration.transitionIn().duration().inTicks());
        }

        private boolean isInExitTransition(float partialTicks) {
            float exitTransitionStartTime;
            float elapsedTicksInterpolated = this.ticksElapsed.getValueInterpolated(partialTicks).floatValue();
            return elapsedTicksInterpolated > (exitTransitionStartTime = this.tickLength - this.configuration.transitionOut().duration().inTicks() * this.configuration.transitionOutCrossfadeWeight());
        }

        private float getWeight(float partialTicks) {
            if (this.getWeightIsFull(partialTicks)) {
                return 1.0f;
            }
            float elapsedTicksInterpolated = this.ticksElapsed.getValueInterpolated(partialTicks).floatValue();
            float entranceTransitionEndTime = this.configuration.startTimeOffset().inTicks() + this.configuration.transitionIn().duration().inTicks();
            float exitTransitionStartTime = this.tickLength - this.configuration.transitionOut().duration().inTicks() * this.configuration.transitionOutCrossfadeWeight();
            boolean isInEntranceTransition = this.isInEntranceTransition(partialTicks);
            boolean isInExitTransition = this.isInExitTransition(partialTicks);
            float weight = 1.0f;
            if (isInEntranceTransition) {
                weight = (elapsedTicksInterpolated - this.configuration.startTimeOffset().inTicks()) / this.configuration.transitionIn().duration().inTicks();
            } else if (isInExitTransition) {
                weight = 1.0f - Math.min((elapsedTicksInterpolated - exitTransitionStartTime) / this.configuration.transitionOut().duration().inTicks(), 1.0f);
            }
            return weight;
        }

        private float getInterruptWeight(float partialTicks) {
            float elapsedTicksInterpolated = this.ticksElapsed.getValueInterpolated(partialTicks).floatValue();
            return 1.0f - (1.0f - Math.min((elapsedTicksInterpolated - this.interruptTick) / this.interruptTransition.duration().inTicks(), 1.0f));
        }
    }
}

