/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.render;

import com.trainguy9512.locomotion.access.FirstPersonSingleBlockRenderer;
import com.trainguy9512.locomotion.access.MatrixModelPart;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPoses;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.render.FirstPersonBlockItemRenderer;
import com.trainguy9512.locomotion.render.ItemRenderType;
import java.util.Objects;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_10090;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_330;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4778;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_7920;
import net.minecraft.class_811;
import net.minecraft.class_8685;
import net.minecraft.class_898;
import net.minecraft.class_918;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FirstPersonPlayerRenderer
implements class_3883<class_10055, class_591> {
    private final class_310 minecraft;
    private final class_898 entityRenderDispatcher;
    private final class_918 itemRenderer;
    private final class_776 blockRenderer;
    private final class_10442 itemModelResolver;
    private final JointAnimatorDispatcher jointAnimatorDispatcher;
    public static boolean IS_RENDERING_LOCOMOTION_FIRST_PERSON = false;
    public static boolean SHOULD_FLIP_ITEM_TRANSFORM = false;
    public static class_1268 CURRENT_ITEM_INTERACTION_HAND = class_1268.field_5808;
    public static float CURRENT_PARTIAL_TICKS = 0.0f;
    private static final class_1921 MAP_BACKGROUND = class_12249.method_76022((class_2960)class_2960.method_60656((String)"textures/map/map_background.png"));
    private static final class_1921 MAP_BACKGROUND_CHECKERBOARD = class_12249.method_76022((class_2960)class_2960.method_60656((String)"textures/map/map_background_checkerboard.png"));
    private final class_10090 mapRenderState = new class_10090();

    public FirstPersonPlayerRenderer(class_5617.class_5618 context) {
        this.minecraft = class_310.method_1551();
        this.entityRenderDispatcher = context.method_32166();
        this.itemRenderer = this.minecraft.method_1480();
        this.blockRenderer = context.method_43337();
        this.itemModelResolver = context.method_65566();
        this.jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
    }

    public void render(float partialTicks, class_4587 poseStack, class_11659 nodeCollector, class_746 player, int combinedLight) {
        CURRENT_PARTIAL_TICKS = partialTicks;
        JointAnimatorDispatcher jointAnimatorDispatcher = JointAnimatorDispatcher.getInstance();
        JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> jointAnimatorDispatcher.getInterpolatedFirstPersonPlayerPose().ifPresent(animationPose -> {
            JointChannel rightArmPose = animationPose.getJointChannel("arm_R_jnt");
            JointChannel leftArmPose = animationPose.getJointChannel("arm_L_jnt");
            JointChannel rightItemPose = animationPose.getJointChannel("item_R_jnt");
            JointChannel leftItemPose = animationPose.getJointChannel("item_L_jnt");
            poseStack.method_22903();
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
            class_1007 playerRenderer = this.entityRenderDispatcher.method_74405((class_742)player);
            class_591 playerModel = (class_591)playerRenderer.method_4038();
            playerModel.method_63514();
            ((MatrixModelPart)playerModel.field_3401).locomotion$setMatrix(rightArmPose.getTransform());
            ((MatrixModelPart)playerModel.field_27433).locomotion$setMatrix(leftArmPose.getTransform());
            playerModel.field_3391.field_3665 = false;
            this.renderArm((class_742)player, playerModel, class_1306.field_6182, poseStack, nodeCollector, combinedLight);
            this.renderArm((class_742)player, playerModel, class_1306.field_6183, poseStack, nodeCollector, combinedLight);
            boolean leftHanded = this.minecraft.field_1690.method_42552().method_41753() == class_1306.field_6182;
            class_2960 leftHandGenericItemPoseIdentifier = (class_2960)dataContainer.getDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(leftHanded ? class_1268.field_5808 : class_1268.field_5810));
            class_2960 rightHandGenericItemPoseIdentifier = (class_2960)dataContainer.getDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(!leftHanded ? class_1268.field_5808 : class_1268.field_5810));
            FirstPersonGenericItems.GenericItemPoseDefinition leftHandGenericItemPoseDefinition = FirstPersonGenericItems.getOrThrowFromIdentifier(leftHandGenericItemPoseIdentifier);
            FirstPersonGenericItems.GenericItemPoseDefinition rightHandGenericItemPoseDefinition = FirstPersonGenericItems.getOrThrowFromIdentifier(rightHandGenericItemPoseIdentifier);
            class_2960 leftHandPoseIdentifier = (class_2960)dataContainer.getDriverValue(FirstPersonDrivers.getHandPoseDriver(leftHanded ? class_1268.field_5808 : class_1268.field_5810));
            class_2960 rightHandPoseIdentifier = (class_2960)dataContainer.getDriverValue(FirstPersonDrivers.getHandPoseDriver(!leftHanded ? class_1268.field_5808 : class_1268.field_5810));
            FirstPersonHandPoses.HandPoseDefinition leftHandPose = FirstPersonHandPoses.getOrThrowFromIdentifier(leftHandPoseIdentifier);
            FirstPersonHandPoses.HandPoseDefinition rightHandPose = FirstPersonHandPoses.getOrThrowFromIdentifier(rightHandPoseIdentifier);
            ItemRenderType leftHandItemRenderType = leftHandPoseIdentifier == FirstPersonHandPoses.GENERIC_ITEM ? leftHandGenericItemPoseDefinition.itemRenderType() : leftHandPose.itemRenderType();
            ItemRenderType rightHandItemRenderType = rightHandPoseIdentifier == FirstPersonHandPoses.GENERIC_ITEM ? rightHandGenericItemPoseDefinition.itemRenderType() : rightHandPose.itemRenderType();
            class_1799 mainHandItem = FirstPersonPlayerRenderer.getItemStackInHandToRender(dataContainer, player, class_1268.field_5808);
            class_1799 offHandItem = FirstPersonPlayerRenderer.getItemStackInHandToRender(dataContainer, player, class_1268.field_5810);
            class_1799 rightHandItem = leftHanded ? offHandItem : mainHandItem;
            class_1799 leftHandItem = leftHanded ? mainHandItem : offHandItem;
            this.renderItem((class_1309)player, rightHandItem, class_811.field_4320, poseStack, rightItemPose, nodeCollector, combinedLight, class_1306.field_6183, !leftHanded ? class_1268.field_5808 : class_1268.field_5810, rightHandItemRenderType);
            this.renderItem((class_1309)player, leftHandItem, class_811.field_4323, poseStack, leftItemPose, nodeCollector, combinedLight, class_1306.field_6182, leftHanded ? class_1268.field_5808 : class_1268.field_5810, leftHandItemRenderType);
            poseStack.method_22909();
        }));
        this.minecraft.field_1773.method_72911().method_73002();
        this.minecraft.method_22940().method_23000().method_22993();
    }

    private static class_1799 getItemStackInHandToRender(AnimationDataContainer dataContainer, class_746 localPlayer, class_1268 hand) {
        class_1799 driverItem = (class_1799)dataContainer.getDriverValue(FirstPersonDrivers.getItemDriver(hand));
        class_1799 driverRenderedItem = (class_1799)dataContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(hand));
        class_1799 playerItem = localPlayer.method_5998(hand);
        if (!class_1799.method_7984((class_1799)playerItem, (class_1799)driverRenderedItem)) {
            return driverRenderedItem;
        }
        if (class_1799.method_31577((class_1799)playerItem, (class_1799)driverRenderedItem)) {
            return playerItem;
        }
        for (class_9336 dataComponent : playerItem.method_57353()) {
            if (dataComponent.comp_2443() == class_9334.field_49629) continue;
            if (!driverRenderedItem.method_57353().method_57832(dataComponent.comp_2443())) {
                return driverRenderedItem;
            }
            if (Objects.equals(driverRenderedItem.method_58694(dataComponent.comp_2443()), dataComponent.comp_2444())) continue;
            return driverRenderedItem;
        }
        return playerItem;
    }

    private void renderArm(class_742 abstractClientPlayer, class_591 playerModel, class_1306 arm, class_4587 poseStack, class_11659 nodeCollector, int combinedLight) {
        class_8685 skin = abstractClientPlayer.method_52814();
        boolean isUsingSlimArms = skin.comp_1629() == class_7920.field_41122;
        boolean leftArm = arm == class_1306.field_6182;
        class_2960 skinTextureLocation = skin.comp_1626().comp_3627();
        class_630 armModelPart = leftArm ? playerModel.field_27433 : playerModel.field_3401;
        class_630 sleeveModelPart = leftArm ? playerModel.field_3484 : playerModel.field_3486;
        class_1664 sleevePlayerModelPart = leftArm ? class_1664.field_7568 : class_1664.field_7570;
        poseStack.method_22903();
        if (isUsingSlimArms) {
            poseStack.method_46416(0.03125f * (float)(leftArm ? 1 : -1), 0.0f, 0.0f);
        }
        sleeveModelPart.field_3665 = abstractClientPlayer.method_74091(sleevePlayerModelPart);
        nodeCollector.method_73491(armModelPart, poseStack, class_12249.method_76000((class_2960)skinTextureLocation), combinedLight, class_4608.field_21444, null);
        poseStack.method_22909();
    }

    public void renderItem(class_1309 entity, class_1799 itemStack, class_811 displayContext, class_4587 poseStack, JointChannel jointChannel, class_11659 nodeCollector, int combinedLight, class_1306 side, class_1268 hand, ItemRenderType renderType) {
        if (!itemStack.method_7960()) {
            IS_RENDERING_LOCOMOTION_FIRST_PERSON = true;
            CURRENT_ITEM_INTERACTION_HAND = hand;
            poseStack.method_22903();
            jointChannel.transformPoseStack(poseStack, 16.0f);
            if (renderType.isMirrored() && side == class_1306.field_6182) {
                SHOULD_FLIP_ITEM_TRANSFORM = true;
            }
            switch (renderType) {
                case MAP: {
                    this.renderMap(nodeCollector, poseStack, itemStack, combinedLight);
                    break;
                }
                case THIRD_PERSON_ITEM: 
                case MIRRORED_THIRD_PERSON_ITEM: {
                    class_10444 itemStackRenderState = new class_10444();
                    this.itemModelResolver.method_65598(itemStackRenderState, itemStack, displayContext, entity.method_73183(), (class_11566)entity, entity.method_5628() + displayContext.ordinal());
                    itemStackRenderState.method_65604(poseStack, nodeCollector, combinedLight, class_4608.field_21444, 0);
                    break;
                }
                case BLOCK_STATE: {
                    FirstPersonBlockItemRenderer.submit(itemStack, poseStack, nodeCollector, combinedLight, side);
                }
            }
            SHOULD_FLIP_ITEM_TRANSFORM = false;
            IS_RENDERING_LOCOMOTION_FIRST_PERSON = false;
            poseStack.method_22909();
        }
    }

    private void renderMap(class_11659 nodeCollector, class_4587 poseStack, class_1799 itemStack, int combinedLight) {
        class_9209 mapId = (class_9209)itemStack.method_58694(class_9334.field_49646);
        assert (this.minecraft.field_1687 != null);
        class_22 mapItemSavedData = class_1806.method_7997((class_9209)mapId, (class_1937)this.minecraft.field_1687);
        class_1921 renderType = mapItemSavedData == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD;
        poseStack.method_22905(-1.0f, 1.0f, -1.0f);
        poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        poseStack.method_46416(-2.0f, -4.0f, -1.0f);
        poseStack.method_22905(0.125f, 0.125f, 0.125f);
        poseStack.method_22905(0.25f, 0.25f, 0.25f);
        nodeCollector.method_73483(poseStack, renderType, (pose, vertexConsumer) -> {
            vertexConsumer.method_56824(pose, -7.0f, 135.0f, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_60803(combinedLight);
            vertexConsumer.method_56824(pose, 135.0f, 135.0f, 0.0f).method_39415(-1).method_22913(1.0f, 1.0f).method_60803(combinedLight);
            vertexConsumer.method_56824(pose, 135.0f, -7.0f, 0.0f).method_39415(-1).method_22913(1.0f, 0.0f).method_60803(combinedLight);
            vertexConsumer.method_56824(pose, -7.0f, -7.0f, 0.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_60803(combinedLight);
        });
        if (mapItemSavedData != null) {
            class_330 mapRenderer = this.minecraft.method_61965();
            mapRenderer.method_62230(mapId, mapItemSavedData, this.mapRenderState);
            mapRenderer.method_1773(this.mapRenderState, poseStack, nodeCollector, false, combinedLight);
        }
    }

    private void renderBlock(class_11659 nodeCollector, class_4587 poseStack, class_2680 blockState, int combinedLight) {
        ((FirstPersonSingleBlockRenderer)class_310.method_1551().method_1541()).locomotion$submitSingleBlockWithEmission(blockState, poseStack, nodeCollector, combinedLight);
    }

    private class_2680 getDefaultBlockState(class_2248 block) {
        class_2680 blockState = block.method_9564();
        blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(8));
        blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12555, (Comparable)class_2738.field_12475);
        blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true));
        if (block instanceof class_2510) {
            blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043);
            blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043);
        } else {
            blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11035);
            blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035);
        }
        return blockState;
    }

    private void renderBedBlock(class_2680 blockState, class_4587 poseStack, class_4597 multiVersionRenderData, int combinedLight) {
        poseStack.method_46416(1.0f, -0.25f, 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)Math.PI));
    }

    private void renderDoorBlock(class_2680 blockState, class_4587 poseStack, class_4597 multiVersionRenderData, int combinedLight) {
    }

    private void renderFenceBlock(class_2680 blockState, class_4587 poseStack, class_4597 bufferSource, int combinedLight) {
        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true));
        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        this.blockRenderer.method_3353(blockState, poseStack, bufferSource, combinedLight, class_4608.field_21444);
    }

    private void renderWallBlock(class_2680 blockState, class_4587 poseStack, class_4597 bufferSource, int combinedLight) {
        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22179);
        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22179);
        this.blockRenderer.method_3353(blockState, poseStack, bufferSource, combinedLight, class_4608.field_21444);
    }

    private void renderUpperHalfBlock(class_2680 blockState, class_4587 poseStack, class_4597 bufferSource, int combinedLight) {
        poseStack.method_46416(0.0f, 1.0f, 0.0f);
        blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609);
        this.blockRenderer.method_3353(blockState, poseStack, bufferSource, combinedLight, class_4608.field_21444);
    }

    public void transformCamera(class_4587 poseStack) {
        if (this.minecraft.field_1690.method_31044().method_31034()) {
            this.jointAnimatorDispatcher.getInterpolatedFirstPersonPlayerPose().ifPresent(animationPose -> {
                JointChannel cameraPose = animationPose.getJointChannel("camera_jnt");
                Vector3f cameraRot = cameraPose.getEulerRotationZYX();
                cameraRot.z *= -1.0f;
                cameraPose.rotate(cameraRot, JointChannel.TransformSpace.LOCAL, JointChannel.TransformType.REPLACE);
                cameraPose.translate(cameraPose.getTranslation().mul(1.0f, 1.0f, -1.0f), JointChannel.TransformSpace.COMPONENT, JointChannel.TransformType.REPLACE);
                cameraPose.transformPoseStack(poseStack, 16.0f);
            });
        }
    }

    @NotNull
    public class_591 getModel() {
        assert (this.minecraft.field_1724 != null);
        return (class_591)this.entityRenderDispatcher.method_74405((class_742)this.minecraft.field_1724).method_4038();
    }
}

