/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.resource.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.trainguy9512.locomotion.animation.sequence.AnimationSequence;
import com.trainguy9512.locomotion.resource.FormatVersion;
import com.trainguy9512.locomotion.util.Interpolator;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Timeline;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class AnimationSequenceDeserializer
implements JsonDeserializer<AnimationSequence> {
    private static final String LENGTH_KEY = "length";
    private static final String JOINT_SKELETON_KEY = "joint_skeleton";
    private static final String JOINT_CHANNELS_KEY = "joint_channels";
    private static final String CUSTOM_ATTRIBUTES_KEY = "custom_attributes";
    private static final String TIME_MARKERS_KEY = "time_markers";
    private static final List<String> REQUIRED_KEYS = List.of("length", "joint_channels");

    public AnimationSequence deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject sequenceJsonObject = jsonElement.getAsJsonObject();
        FormatVersion version = FormatVersion.ofAssetJsonObject(sequenceJsonObject);
        if (version.isIncompatible()) {
            throw new JsonParseException("Animation sequence version is out of date for deserializer.");
        }
        for (String key : REQUIRED_KEYS) {
            if (sequenceJsonObject.has(key)) continue;
            throw new JsonParseException("Required key " + key + " not found in data.");
        }
        Optional potentialIdentifier = class_2960.method_29186((String)sequenceJsonObject.get(JOINT_SKELETON_KEY).getAsString()).result();
        if (!potentialIdentifier.isPresent()) {
            throw new JsonParseException("Joint skeleton resource location " + sequenceJsonObject.get(JOINT_SKELETON_KEY).getAsString() + " is invalid.");
        }
        class_2960 jointSkeletonLocation = ((class_2960)potentialIdentifier.get()).method_45134(string -> "skeletons/" + string + ".json");
        float sequenceLength = sequenceJsonObject.get(LENGTH_KEY).getAsFloat();
        AnimationSequence.Builder sequenceBuilder = AnimationSequence.builder(TimeSpan.ofSeconds(sequenceLength), jointSkeletonLocation);
        JsonObject jointChannelsJsonObject = sequenceJsonObject.getAsJsonObject(JOINT_CHANNELS_KEY);
        jointChannelsJsonObject.asMap().forEach((joint, jointElement) -> {
            JsonObject jointJsonObject = jointElement.getAsJsonObject();
            Timeline<Vector3f> translationTimeline = AnimationSequenceDeserializer.deserializeTimeline(context, jointJsonObject, "translation", Vector3f.class, Interpolator.VECTOR_FLOAT, sequenceLength);
            Timeline<Quaternionf> rotationTimeline = AnimationSequenceDeserializer.deserializeTimeline(context, jointJsonObject, "rotation", Quaternionf.class, Interpolator.QUATERNION, sequenceLength);
            Timeline<Vector3f> scaleTimeline = AnimationSequenceDeserializer.deserializeTimeline(context, jointJsonObject, "scale", Vector3f.class, Interpolator.VECTOR_FLOAT, sequenceLength);
            Timeline<Boolean> visibilityTimeline = AnimationSequenceDeserializer.deserializeTimeline(context, jointJsonObject, "visibility", Boolean.class, Interpolator.BOOLEAN_KEYFRAME, sequenceLength);
            sequenceBuilder.putJointTranslationTimeline((String)joint, translationTimeline);
            sequenceBuilder.putJointRotationTimeline((String)joint, rotationTimeline);
            sequenceBuilder.putJointScaleTimeline((String)joint, scaleTimeline);
            sequenceBuilder.putJointVisibilityTimeline((String)joint, visibilityTimeline);
        });
        JsonObject customAttributesJsonObject = sequenceJsonObject.getAsJsonObject(CUSTOM_ATTRIBUTES_KEY);
        customAttributesJsonObject.asMap().forEach((customAttribute, customAttributeTimelineElement) -> sequenceBuilder.putCustomAttributeTimeline((String)customAttribute, AnimationSequenceDeserializer.deserializeTimeline(context, customAttributesJsonObject, customAttribute, Float.class, Interpolator.FLOAT, sequenceLength)));
        if (sequenceJsonObject.has(TIME_MARKERS_KEY)) {
            Map timeMarkers = sequenceJsonObject.getAsJsonObject(TIME_MARKERS_KEY).asMap();
            timeMarkers.forEach((timeMarkerIdentifier, timeMarkerElement) -> {
                JsonArray times = timeMarkerElement.getAsJsonArray();
                times.forEach(time -> sequenceBuilder.putTimeMarker((String)timeMarkerIdentifier, TimeSpan.ofSeconds(time.getAsFloat())));
            });
        }
        return sequenceBuilder.build();
    }

    private static <X> Timeline<X> deserializeTimeline(JsonDeserializationContext context, JsonObject jsonObject, String identifier, Class<X> type, Interpolator<X> interpolator, float sequenceLength) {
        Timeline timeline = Timeline.of(interpolator, sequenceLength);
        jsonObject.getAsJsonObject(identifier).asMap().forEach((keyframeString, keyframeValueElement) -> {
            float keyframe = Float.parseFloat(keyframeString);
            timeline.addKeyframe(keyframe, context.deserialize(keyframeValueElement, (Type)type));
        });
        return timeline;
    }
}

