/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.util;

import net.minecraft.class_3532;

@FunctionalInterface
public interface Easing {
    public static final Easing LINEAR = time -> time;
    public static final Easing INSTANT = time -> 1.0f;
    public static final Easing SINE_IN = time -> (float)(1.0 - Math.cos((double)time * Math.PI / 2.0));
    public static final Easing SINE_OUT = Easing.invert(SINE_IN);
    public static final Easing SINE_IN_OUT = Easing.composeEaseInOut(SINE_IN);
    public static final Easing QUAD_IN = time -> time * time;
    public static final Easing QUAD_OUT = Easing.invert(QUAD_IN);
    public static final Easing QUAD_IN_OUT = Easing.composeEaseInOut(QUAD_IN);
    public static final Easing CUBIC_IN = time -> time * time * time;
    public static final Easing CUBIC_OUT = Easing.invert(CUBIC_IN);
    public static final Easing CUBIC_IN_OUT = Easing.composeEaseInOut(CUBIC_IN);
    public static final Easing QUART_IN = time -> time * time * time * time;
    public static final Easing QUART_OUT = Easing.invert(QUART_IN);
    public static final Easing QUART_IN_OUT = Easing.composeEaseInOut(QUART_IN);
    public static final Easing QUINT_IN = time -> time * time * time * time * time;
    public static final Easing QUINT_OUT = Easing.invert(QUINT_IN);
    public static final Easing QUINT_IN_OUT = Easing.composeEaseInOut(QUINT_IN);
    public static final Easing EXPONENTIAL_IN = time -> time == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * time - 10.0f);
    public static final Easing EXPONENTIAL_OUT = Easing.invert(EXPONENTIAL_IN);
    public static final Easing EXPONENTIAL_IN_OUT = Easing.composeEaseInOut(EXPONENTIAL_IN);
    public static final Easing CIRC_IN = time -> (float)Math.sqrt(1.0 - Math.pow(time - 1.0f, 2.0));
    public static final Easing CIRC_OUT = Easing.invert(CIRC_IN);
    public static final Easing CIRC_IN_OUT = Easing.composeEaseInOut(CIRC_IN);
    public static final Easing BACK_IN = CubicBezier.of(0.36f, 0.0f, 0.66f, -0.56f);
    public static final Easing BACK_OUT = Easing.invert(BACK_IN);
    public static final Easing BACK_IN_OUT = Easing.composeEaseInOut(BACK_IN);
    public static final Easing ELASTIC_IN = Elastic.of(10.0f, false);
    public static final Easing ELASTIC_OUT = Elastic.of(10.0f, true);
    public static final Easing ELASTIC_IN_OUT = Easing.composeEaseInOut(ELASTIC_IN);
    public static final Easing BOUNCE_IN = Easing::bounceEaseIn;
    public static final Easing BOUNCE_OUT = Easing.invert(BOUNCE_IN);
    public static final Easing BOUNCE_IN_OUT = Easing.composeEaseInOut(BOUNCE_IN);

    public float ease(float var1);

    private static float bounceEaseIn(float time) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (time < 1.0f / d1) {
            return n1 * time * time;
        }
        if (time < 2.0f / d1) {
            return n1 * (time -= 1.5f / d1) * time + 0.75f;
        }
        if (time < 2.5f / d1) {
            return n1 * (time -= 2.25f / d1) * time + 0.9375f;
        }
        return n1 * (time -= 2.625f / d1) * time + 0.984375f;
    }

    public static Easing invert(Easing easing) {
        return time -> 1.0f - easing.ease(1.0f - time);
    }

    public static Easing composeEaseInOut(Easing easeIn) {
        return time -> {
            if (time < 0.5f) {
                return easeIn.ease(time * 2.0f) / 2.0f;
            }
            return Easing.invert(easeIn).ease(time * 2.0f - 1.0f) / 2.0f + 0.5f;
        };
    }

    public static class CubicBezier
    implements Easing {
        float cx;
        float bx;
        float ax;
        float cy;
        float by;
        float ay;
        float startGradient;
        float endGradient;

        private CubicBezier(float p1x, float p1y, float p2x, float p2y) {
            this.cx = 3.0f * p1x;
            this.bx = 3.0f * (p2x - p1x) - this.cx;
            this.ax = 1.0f - this.cx - this.bx;
            this.cy = 3.0f * p1y;
            this.by = 3.0f * (p2y - p1y) - this.cy;
            this.ay = 1.0f - this.cy - this.by;
            this.startGradient = p1x > 0.0f ? p1y / p1x : (p1y == 0.0f && p2x > 0.0f ? p2y / p2x : 0.0f);
            this.endGradient = p2x < 1.0f ? (p2y - 1.0f) / (p2x - 1.0f) : (p2x == 1.0f && p1x < 1.0f ? (p1y - 1.0f) / (p1x - 1.0f) : 0.0f);
        }

        float sampleCurveX(float t) {
            return ((this.ax * t + this.bx) * t + this.cx) * t;
        }

        float sampleCurveY(float t) {
            return ((this.ay * t + this.by) * t + this.cy) * t;
        }

        float sampleCurveDerivativeX(float t) {
            return (3.0f * this.ax * t + 2.0f * this.bx) * t + this.cx;
        }

        float solveCurveX(float x, float epsilon) {
            float x2;
            float t2 = x;
            for (int i = 0; i < 8; ++i) {
                x2 = this.sampleCurveX(t2) - x;
                if (class_3532.method_15379((float)x2) < epsilon) {
                    return t2;
                }
                float d2 = this.sampleCurveDerivativeX(t2);
                if ((double)class_3532.method_15379((float)d2) < 1.0E-6) break;
                t2 -= x2 / d2;
            }
            float t0 = 0.0f;
            float t1 = 1.0f;
            t2 = x;
            while (t0 < t1) {
                x2 = this.sampleCurveX(t2);
                if (class_3532.method_15379((float)(x2 - x)) < epsilon) {
                    return t2;
                }
                if (x > x2) {
                    t0 = t2;
                } else {
                    t1 = t2;
                }
                t2 = (t1 - t0) * 0.5f + t0;
            }
            return t2;
        }

        float solve(float x, float epsilon) {
            if (x < 0.0f) {
                return 0.0f + this.startGradient * x;
            }
            if (x > 1.0f) {
                return 1.0f + this.endGradient * (x - 1.0f);
            }
            return this.sampleCurveY(this.solveCurveX(x, epsilon));
        }

        @Override
        public float ease(float time) {
            return this.solve(time, 0.01f);
        }

        public static CubicBezier of(float point1X, float point1Y, float point2X, float point2Y) {
            return new CubicBezier(point1X, point1Y, point2X, point2Y);
        }
    }

    public static class Elastic
    implements Easing {
        private final float bounceFactor;

        private Elastic(float bounceFactor) {
            this.bounceFactor = bounceFactor;
        }

        public static Easing of(float bounceFactor, boolean inverted) {
            Elastic elasticEasing = new Elastic(bounceFactor);
            if (inverted) {
                return Easing.invert(elasticEasing);
            }
            return elasticEasing;
        }

        @Override
        public float ease(float time) {
            if (time == 0.0f) {
                return 0.0f;
            }
            if (time == 1.0f) {
                return 1.0f;
            }
            float a = 2.0943952f;
            float b = (float)(-Math.pow(2.0, 10.0f * time - 10.0f));
            float c = this.bounceFactor * time - this.bounceFactor - 0.75f;
            float d = (float)((double)b * Math.sin(c * a));
            return d;
        }
    }
}

