/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.util;

import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@FunctionalInterface
public interface Interpolator<T> {
    public static final Interpolator<Float> FLOAT = (a, b, time) -> Float.valueOf(a.floatValue() + (b.floatValue() - a.floatValue()) * time);
    public static final Interpolator<Boolean> BOOLEAN_KEYFRAME = Interpolator.constantKeyframe();
    public static final Interpolator<Boolean> BOOLEAN_BLEND = Interpolator.constantBlend();
    public static final Interpolator<LocalSpacePose> LOCAL_SPACE_POSE = (a, b, time) -> a.interpolated((LocalSpacePose)b, time, LocalSpacePose.of(a));
    public static final Interpolator<Vector3f> VECTOR_FLOAT = (a, b, time) -> {
        if (time == 0.0f) {
            return new Vector3f((Vector3fc)a);
        }
        if (time == 1.0f) {
            return new Vector3f((Vector3fc)b);
        }
        if (a.equals(b)) {
            return new Vector3f((Vector3fc)a);
        }
        return a.lerp((Vector3fc)b, time, new Vector3f());
    };
    public static final Interpolator<Quaternionf> QUATERNION = (a, b, time) -> {
        if (time == 0.0f) {
            return new Quaternionf((Quaternionfc)a);
        }
        if (time == 1.0f) {
            return new Quaternionf((Quaternionfc)b);
        }
        if (a.equals(b)) {
            return new Quaternionf((Quaternionfc)a);
        }
        return a.slerp((Quaternionfc)b, time, new Quaternionf());
    };

    public T interpolate(T var1, T var2, float var3);

    public static <T> Interpolator<T> constantKeyframe() {
        return (a, b, time) -> b;
    }

    public static <T> Interpolator<T> constantBlend() {
        return (a, b, time) -> b;
    }
}

