/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.util;

import com.trainguy9512.locomotion.animation.joint.skeleton.BlendProfile;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;

public record Transition(TimeSpan duration, Easing easement, BlendProfile blendProfile) {
    public static final Transition INSTANT = Transition.builder(TimeSpan.ofTicks(1.0f)).setEasement(Easing.INSTANT).build();
    public static final Transition SINGLE_TICK = Transition.builder(TimeSpan.ofTicks(1.0f)).setEasement(Easing.LINEAR).build();

    public static Builder builder(TimeSpan duration) {
        return new Builder(duration);
    }

    public Transition withInverseEasing() {
        return new Transition(this.duration, Easing.invert(this.easement), this.blendProfile);
    }

    public static class Builder {
        private final TimeSpan duration;
        private Easing easement;
        private BlendProfile blendProfile;

        private Builder(TimeSpan duration) {
            this.duration = duration;
            this.easement = Easing.LINEAR;
            this.blendProfile = null;
        }

        public Builder setEasement(Easing easement) {
            this.easement = easement;
            return this;
        }

        public Builder setBlendProfile(BlendProfile blendProfile) {
            this.blendProfile = blendProfile;
            return this;
        }

        public Transition build() {
            return new Transition(this.duration, this.easement, this.blendProfile);
        }
    }
}

