/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.access.MatrixModelPart;
import com.trainguy9512.locomotion.animation.animator.JointAnimator;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorRegistry;
import com.trainguy9512.locomotion.animation.animator.entity.EntityJointAnimator;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.joint.skeleton.JointSkeleton;
import com.trainguy9512.locomotion.animation.pose.ComponentSpacePose;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.Pose;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;

public class JointAnimatorDispatcher {
    private static final JointAnimatorDispatcher INSTANCE = new JointAnimatorDispatcher();
    private final WeakHashMap<UUID, AnimationDataContainer> entityAnimationDataContainerStorage = new WeakHashMap();
    private AnimationDataContainer firstPersonPlayerDataContainer;
    private ComponentSpacePose interpolatedFirstPersonPlayerPose;

    public static JointAnimatorDispatcher getInstance() {
        return INSTANCE;
    }

    public void reInitializeData() {
        this.firstPersonPlayerDataContainer = null;
        this.entityAnimationDataContainerStorage.clear();
    }

    public <T extends Entity> void tickEntityJointAnimators(Iterable<T> entitiesForRendering) {
        entitiesForRendering.forEach(entity -> JointAnimatorRegistry.getThirdPersonJointAnimator(entity).ifPresent(jointAnimator -> this.getEntityAnimationDataContainer(entity).ifPresent(dataContainer -> this.tickJointAnimator((JointAnimator)jointAnimator, (Object)entity, (AnimationDataContainer)dataContainer))));
    }

    public void tickFirstPersonPlayerJointAnimator() {
        if (LocomotionMain.CONFIG.data().firstPersonPlayer.enableRenderer) {
            JointAnimatorRegistry.getFirstPersonPlayerJointAnimator().ifPresent(jointAnimator -> this.getFirstPersonPlayerDataContainer().ifPresent(dataContainer -> this.tickJointAnimator((JointAnimator)jointAnimator, (Object)Minecraft.getInstance().player, (AnimationDataContainer)dataContainer)));
        }
    }

    private <T> void tickJointAnimator(JointAnimator<T> jointAnimator, T dataReference, AnimationDataContainer dataContainer) {
        dataContainer.preTick();
        jointAnimator.extractAnimationData(dataReference, dataContainer, dataContainer.getMontageManager());
        dataContainer.tick();
        if (jointAnimator.getPoseCalulationFrequency() == JointAnimator.PoseCalculationFrequency.CALCULATE_ONCE_PER_TICK) {
            dataContainer.getDriver(dataContainer.getPerTickCalculatedPoseDriverKey()).setValue(dataContainer.computePose(1.0f));
        }
        dataContainer.postTick();
    }

    public <T extends Entity> Optional<AnimationDataContainer> getEntityAnimationDataContainer(T entity) {
        UUID uuid = entity.getUUID();
        if (!this.entityAnimationDataContainerStorage.containsKey(uuid)) {
            JointAnimatorRegistry.getThirdPersonJointAnimator(entity).ifPresent(jointAnimator -> this.entityAnimationDataContainerStorage.put(uuid, this.createDataContainer((JointAnimator<?>)jointAnimator)));
        }
        return Optional.ofNullable(this.entityAnimationDataContainerStorage.get(uuid));
    }

    public Optional<AnimationDataContainer> getFirstPersonPlayerDataContainer() {
        if (this.firstPersonPlayerDataContainer == null) {
            JointAnimatorRegistry.getFirstPersonPlayerJointAnimator().ifPresent(jointAnimator -> {
                this.firstPersonPlayerDataContainer = this.createDataContainer((JointAnimator<?>)jointAnimator);
            });
        }
        return Optional.ofNullable(this.firstPersonPlayerDataContainer);
    }

    public Optional<ComponentSpacePose> getInterpolatedFirstPersonPlayerPose() {
        return Optional.ofNullable(this.interpolatedFirstPersonPlayerPose);
    }

    public void calculateInterpolatedFirstPersonPlayerPose(JointAnimator<?> jointAnimator, AnimationDataContainer dataContainer, float partialTicks) {
        this.interpolatedFirstPersonPlayerPose = this.getInterpolatedAnimationPose(jointAnimator, dataContainer, partialTicks);
    }

    private AnimationDataContainer createDataContainer(JointAnimator<?> jointAnimator) {
        return AnimationDataContainer.of(jointAnimator);
    }

    public ComponentSpacePose getInterpolatedAnimationPose(JointAnimator<?> jointAnimator, AnimationDataContainer dataContainer, float partialTicks) {
        return switch (jointAnimator.getPoseCalulationFrequency()) {
            default -> throw new MatchException(null, null);
            case JointAnimator.PoseCalculationFrequency.CALCULATE_EVERY_FRAME -> dataContainer.computePose(partialTicks).convertedToComponentSpace();
            case JointAnimator.PoseCalculationFrequency.CALCULATE_ONCE_PER_TICK -> ((LocalSpacePose)dataContainer.getInterpolatedDriverValue(dataContainer.getPerTickCalculatedPoseDriverKey(), partialTicks)).convertedToComponentSpace();
        };
    }

    public <S extends EntityRenderState> void setupAnimWithAnimationPose(EntityModel<S> entityModel, S entityRenderState, Pose pose, EntityJointAnimator<?, S> entityJointAnimator) {
        entityModel.resetPose();
        JointSkeleton jointSkeleton = pose.getJointSkeleton();
        Function partLookup = entityModel.root().createPartLookup();
        jointSkeleton.getJoints().forEach(joint -> {
            ModelPart modelPart;
            String modelPartIdentifier = jointSkeleton.getJointConfiguration((String)joint).modelPartIdentifier();
            if (modelPartIdentifier != null && (modelPart = (ModelPart)partLookup.apply(modelPartIdentifier)) != null) {
                ((MatrixModelPart)modelPart).locomotion$setMatrix(pose.getJointChannel((String)joint).getTransform());
            }
        });
        entityJointAnimator.postProcessModelParts(entityModel, entityRenderState);
    }
}

