/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.google.common.collect.Maps;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonBrush;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonGenericItems;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonJointAnimator;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMace;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMining;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonShield;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonSpyglass;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonSword;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonTrident;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.BlendPosesFunction;
import com.trainguy9512.locomotion.animation.pose.function.EmptyPoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.MakeDynamicAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceReferencePoint;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageSlotFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateMachineFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.render.ItemRenderType;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public enum FirstPersonHandPose {
    EMPTY("empty", FirstPersonAnimationSequences.HAND_EMPTY_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    GENERIC_ITEM("generic_item", FirstPersonAnimationSequences.HAND_GENERIC_ITEM_2D_ITEM_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    TOOL("tool", FirstPersonAnimationSequences.HAND_TOOL_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    SWORD("sword", FirstPersonAnimationSequences.HAND_TOOL_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    SHIELD("shield", FirstPersonAnimationSequences.HAND_SHIELD_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    BOW("bow", FirstPersonAnimationSequences.HAND_BOW_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    CROSSBOW("crossbow", FirstPersonAnimationSequences.HAND_CROSSBOW_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    TRIDENT("trident", FirstPersonAnimationSequences.HAND_TRIDENT_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    BRUSH("brush", FirstPersonAnimationSequences.HAND_BRUSH_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    MACE("mace", FirstPersonAnimationSequences.HAND_MACE_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    SPYGLASS("spyglass", FirstPersonAnimationSequences.HAND_SPYGLASS_POSE, ItemRenderType.THIRD_PERSON_ITEM),
    MAP("map", FirstPersonAnimationSequences.HAND_MAP_SINGLE_HAND_POSE, ItemRenderType.MAP);

    private static final Logger LOGGER;
    public final String raisingState;
    public final String loweringState;
    public final String poseState;
    public final ResourceLocation basePoseLocation;
    public final ItemRenderType itemRenderType;
    public static final List<TagKey<Item>> TOOL_ITEM_TAGS;
    public static Map<ItemUseAnimation, FirstPersonHandPose> POSES_BY_USE_ANIMATION;
    public static final String HAND_POSE_DROPPING_LAST_ITEM_STATE = "dropping_last_item";
    public static final String HAND_POSE_USING_LAST_ITEM_STATE = "using_last_item";
    public static final String HAND_POSE_THROWING_TRIDENT_STATE = "throwing_trident";

    private FirstPersonHandPose(String handPoseStateIdentifier, ResourceLocation basePoseLocation, ItemRenderType itemRenderType) {
        this.raisingState = handPoseStateIdentifier + "_raise";
        this.loweringState = handPoseStateIdentifier + "_lower";
        this.poseState = handPoseStateIdentifier;
        this.basePoseLocation = basePoseLocation;
        this.itemRenderType = itemRenderType;
    }

    public static FirstPersonHandPose fromItemStack(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return EMPTY;
        }
        ItemUseAnimation useAnimation = itemStack.getUseAnimation();
        if (POSES_BY_USE_ANIMATION.containsKey(useAnimation)) {
            return POSES_BY_USE_ANIMATION.get(useAnimation);
        }
        if (itemStack.has(DataComponents.MAP_ID)) {
            return MAP;
        }
        if (itemStack.is(ItemTags.MACE_ENCHANTABLE)) {
            return MACE;
        }
        if (itemStack.is(Items.SHIELD)) {
            return SHIELD;
        }
        if (itemStack.is(ItemTags.SWORDS)) {
            return SWORD;
        }
        for (TagKey<Item> tag : TOOL_ITEM_TAGS) {
            if (!itemStack.is(tag)) continue;
            return TOOL;
        }
        return GENERIC_ITEM;
    }

    public static MontageConfiguration getToolMontage(OnTickDriverContainer driverContainer) {
        if (((ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.MAIN_HAND_ITEM)).is(ItemTags.AXES)) {
            return FirstPersonMontages.HAND_TOOL_ATTACK_AXE_MONTAGE;
        }
        return FirstPersonMontages.HAND_TOOL_ATTACK_PICKAXE_MONTAGE;
    }

    @Nullable
    public MontageConfiguration getAttackMontage(OnTickDriverContainer driverContainer) {
        if (this == SWORD) {
            return null;
        }
        if (this == TRIDENT) {
            return FirstPersonMontages.HAND_TRIDENT_JAB_MONTAGE;
        }
        if (this == MACE) {
            return FirstPersonMontages.HAND_MACE_ATTACK_MONTAGE;
        }
        if (((ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.MAIN_HAND_ITEM)).is(ItemTags.AXES)) {
            return FirstPersonMontages.HAND_TOOL_ATTACK_AXE_MONTAGE;
        }
        return FirstPersonMontages.HAND_TOOL_ATTACK_PICKAXE_MONTAGE;
    }

    public PoseFunction<LocalSpacePose> getMiningStateMachine(CachedPoseContainer cachedPoseContainer, InteractionHand interactionHand) {
        return switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> {
                switch (this.ordinal()) {
                    case 2: {
                        yield FirstPersonMining.makePickaxeMiningPoseFunction(cachedPoseContainer);
                    }
                }
                yield ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(this.basePoseLocation).build(), MakeDynamicAdditiveFunction.of(FirstPersonMining.makePickaxeMiningPoseFunction(cachedPoseContainer), SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_POSE).build()));
            }
            case InteractionHand.OFF_HAND -> SequenceEvaluatorFunction.builder(this.basePoseLocation).build();
        };
    }

    public static PoseFunction<LocalSpacePose> constructPoseFunction(CachedPoseContainer cachedPoseContainer, InteractionHand interactionHand) {
        StateMachineFunction.Builder handPoseStateMachineBuilder = switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> StateMachineFunction.builder(evaluationState -> ((FirstPersonHandPose)((Object)((Object)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.MAIN_HAND_POSE)))).poseState);
            case InteractionHand.OFF_HAND -> StateMachineFunction.builder(evaluationState -> ((FirstPersonHandPose)((Object)((Object)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.OFF_HAND_POSE)))).poseState);
        };
        handPoseStateMachineBuilder.resetsUponRelevant(true);
        StateAlias.Builder fromLoweringAliasBuilder = StateAlias.builder(Set.of(FirstPersonHandPose.EMPTY.loweringState));
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, GENERIC_ITEM, FirstPersonGenericItems.constructPoseFunction(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(context -> FirstPersonGenericItems.getOrThrowFromIdentifier((ResourceLocation)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(interactionHand), 1.0f)).basePoseAnimationSequence()).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(context -> FirstPersonGenericItems.getOrThrowFromIdentifier((ResourceLocation)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.getGenericItemPoseDriver(interactionHand), 1.0f)).basePoseAnimationSequence()).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, TOOL, TOOL.getMiningStateMachine(cachedPoseContainer, interactionHand), SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build(), SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_RAISE).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, SWORD, FirstPersonSword.handSwordPoseFunction(cachedPoseContainer, interactionHand), SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_LOWER).build(), SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_RAISE).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, SHIELD, FirstPersonShield.constructShieldPoseFunction(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_SHIELD_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_SHIELD_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, BOW, BOW.getMiningStateMachine(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_BOW_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_BOW_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, CROSSBOW, CROSSBOW.getMiningStateMachine(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_CROSSBOW_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_CROSSBOW_RAISE).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, TRIDENT, FirstPersonTrident.handTridentPoseFunction(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, BRUSH, FirstPersonBrush.handBrushPoseFunction(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_BRUSH_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_BRUSH_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, MACE, FirstPersonMace.handMacePoseFunction(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_MACE_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_MACE_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, SPYGLASS, FirstPersonSpyglass.handSpyglassPoseFunction(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_SPYGLASS_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_SPYGLASS_POSE).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, MAP, MAP.getMiningStateMachine(cachedPoseContainer, interactionHand), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonHandPose.MAP.basePoseLocation).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_LOWER).isAdditive(true, SequenceReferencePoint.BEGINNING)).build()), ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonHandPose.MAP.basePoseLocation).build(), ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_GENERIC_ITEM_RAISE).isAdditive(true, SequenceReferencePoint.END)).build()), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build(), Transition.builder(TimeSpan.of60FramesPerSecond(6.0f)).setEasement(Easing.SINE_IN_OUT).build());
        FirstPersonHandPose.addStatesForHandPose(handPoseStateMachineBuilder, fromLoweringAliasBuilder, interactionHand, EMPTY, switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> EMPTY.getMiningStateMachine(cachedPoseContainer, interactionHand);
            case InteractionHand.OFF_HAND -> SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_LOWERED).build();
        }, switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_LOWER).build();
            case InteractionHand.OFF_HAND -> SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_LOWERED).build();
        }, switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_RAISE).build();
            case InteractionHand.OFF_HAND -> SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_LOWERED).build();
        }, switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> Transition.builder(TimeSpan.of60FramesPerSecond(7.0f)).setEasement(Easing.SINE_IN_OUT).build();
            case InteractionHand.OFF_HAND -> Transition.INSTANT;
        }, switch (interactionHand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> Transition.builder(TimeSpan.of60FramesPerSecond(18.0f)).setEasement(Easing.SINE_IN_OUT).build();
            case InteractionHand.OFF_HAND -> Transition.INSTANT;
        });
        handPoseStateMachineBuilder.addStateAlias(fromLoweringAliasBuilder.build()).defineState(StateDefinition.builder(HAND_POSE_DROPPING_LAST_ITEM_STATE, ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_POSE).build(), MakeDynamicAdditiveFunction.of(SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_USE).build(), SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_POSE).build()))).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(HAND_POSE_USING_LAST_ITEM_STATE, ApplyAdditiveFunction.of(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_EMPTY_POSE).build(), MakeDynamicAdditiveFunction.of(SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_USE).build(), SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.HAND_TOOL_POSE).build()))).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(HAND_POSE_THROWING_TRIDENT_STATE, SequencePlayerFunction.builder(FirstPersonAnimationSequences.HAND_TRIDENT_RELEASE_THROW).build()).addOutboundTransition(StateTransition.builder(FirstPersonHandPose.EMPTY.raisingState).isTakenOnAnimationFinished(0.0f).setTiming(Transition.builder(TimeSpan.ofTicks(1.0f)).build()).build()).resetsPoseFunctionUponEntry(true).build()).addStateAlias(StateAlias.builder(Set.of(HAND_POSE_DROPPING_LAST_ITEM_STATE, HAND_POSE_USING_LAST_ITEM_STATE)).addOutboundTransition(StateTransition.builder(FirstPersonHandPose.EMPTY.poseState).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.ofSeconds(0.1f)).setEasement(Easing.SINE_IN_OUT).build()).build()).addOutboundTransition(StateTransition.builder(FirstPersonHandPose.EMPTY.poseState).isTakenIfTrue(context -> FirstPersonHandPose.shouldCancelLastItemAnimation(context, interactionHand)).setTiming(Transition.builder(TimeSpan.ofSeconds(0.05f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build());
        BlendPosesFunction pose = handPoseStateMachineBuilder.build();
        pose = BlendPosesFunction.builder(pose).addBlendInput(EmptyPoseFunction.of(), functionEvaluationState -> Float.valueOf(1.0f - LocomotionMain.CONFIG.data().firstPersonPlayer.cameraShakeItemInteractionIntensity), FirstPersonJointAnimator.CAMERA_MASK).build();
        return pose;
    }

    private static boolean shouldCancelLastItemAnimation(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getHasUsedItemDriver(interactionHand))).booleanValue() && context.timeElapsedInCurrentState().inTicks() > 2.0f) {
            return true;
        }
        if (interactionHand == InteractionHand.MAIN_HAND) {
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.HAS_ATTACKED)).booleanValue()) {
                return true;
            }
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_MINING)).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasItemChanged(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        ItemStack itemCurrentTick;
        ItemStack itemPreviousTick = (ItemStack)context.driverContainer().getDriverValue(FirstPersonDrivers.getRenderedItemDriver(interactionHand));
        if (!itemPreviousTick.is((itemCurrentTick = (ItemStack)context.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))).getItem())) {
            return true;
        }
        for (TypedDataComponent dataComponent : itemCurrentTick.getComponents()) {
            if (dataComponent.type() == DataComponents.DAMAGE) continue;
            if (!itemPreviousTick.getComponents().has(dataComponent.type())) {
                return true;
            }
            if (Objects.equals(itemPreviousTick.get(dataComponent.type()), dataComponent.value())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNewItemEmpty(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        return ((ItemStack)context.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))).isEmpty();
    }

    private static boolean isOldItemEmpty(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        return ((ItemStack)context.driverContainer().getDriverValue(FirstPersonDrivers.getRenderedItemDriver(interactionHand))).isEmpty();
    }

    private static boolean hasSelectedHotbarSlotChanged(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        return interactionHand == InteractionHand.MAIN_HAND && context.driverContainer().getDriver(FirstPersonDrivers.HOTBAR_SLOT).hasValueChanged();
    }

    private static boolean areAnyTwoHandedOverridesActive(StateTransition.TransitionContext context) {
        return !Objects.equals(context.driverContainer().getDriverValue(FirstPersonDrivers.CURRENT_TWO_HANDED_OVERRIDE_STATE), "normal");
    }

    private static boolean shouldTakeHardSwitchTransition(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        if (FirstPersonHandPose.areAnyTwoHandedOverridesActive(context)) {
            return false;
        }
        if (context.driverContainer().getDriver(FirstPersonDrivers.getUsingItemDriver(interactionHand)).getPreviousValue().booleanValue()) {
            ItemUseAnimation useAnimation = context.driverContainer().getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(interactionHand)).getPreviousValue().getUseAnimation();
            if (useAnimation == ItemUseAnimation.EAT) {
                return false;
            }
            if (useAnimation == ItemUseAnimation.DRINK) {
                return false;
            }
        }
        if (FirstPersonHandPose.hasItemChanged(context, interactionHand)) {
            return true;
        }
        return FirstPersonHandPose.hasSelectedHotbarSlotChanged(context, interactionHand) && (!FirstPersonHandPose.isNewItemEmpty(context, interactionHand) || !FirstPersonHandPose.isOldItemEmpty(context, interactionHand));
    }

    private static boolean shouldTakeDropLastItemTransition(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        if (interactionHand != InteractionHand.MAIN_HAND) {
            return false;
        }
        if (!FirstPersonHandPose.isNewItemEmpty(context, interactionHand)) {
            return false;
        }
        return context.driverContainer().getDriver(FirstPersonDrivers.HAS_DROPPED_ITEM).hasBeenTriggered();
    }

    private static boolean shouldTakeUseLastItemTransition(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        if (!FirstPersonHandPose.isNewItemEmpty(context, interactionHand)) {
            return false;
        }
        if (FirstPersonHandPose.isOldItemEmpty(context, interactionHand)) {
            return false;
        }
        if (context.driverContainer().getDriver(FirstPersonDrivers.getHasUsedItemDriver(interactionHand)).hasBeenTriggered()) {
            return true;
        }
        return interactionHand == InteractionHand.MAIN_HAND && context.driverContainer().getDriver(FirstPersonDrivers.HAS_ATTACKED).hasBeenTriggered();
    }

    private static boolean shouldTakeThrowTridentTransition(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        if (!FirstPersonHandPose.isNewItemEmpty(context, interactionHand)) {
            return false;
        }
        if (FirstPersonHandPose.isOldItemEmpty(context, interactionHand)) {
            return false;
        }
        if (FirstPersonHandPose.hasSelectedHotbarSlotChanged(context, interactionHand)) {
            return false;
        }
        if (context.driverContainer().getDriver(FirstPersonDrivers.HAS_SWAPPED_ITEMS).hasBeenTriggered()) {
            return false;
        }
        return context.driverContainer().getDriver(FirstPersonDrivers.getRenderedItemDriver(interactionHand)).getCurrentValue().getUseAnimation() == ItemUseAnimation.SPEAR;
    }

    private static boolean shouldSkipRaiseAnimation(StateTransition.TransitionContext context, InteractionHand interactionHand) {
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getUsingItemDriver(interactionHand))).booleanValue()) {
            return true;
        }
        if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.getHasUsedItemDriver(interactionHand))).booleanValue()) {
            return true;
        }
        if (interactionHand == InteractionHand.MAIN_HAND) {
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_MINING)).booleanValue()) {
                return true;
            }
            if (((Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.HAS_ATTACKED)).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private static void clearMontagesInAttackSlot(PoseFunction.FunctionEvaluationState evaluationState, InteractionHand interactionHand) {
        evaluationState.montageManager().interruptMontagesInSlot(FirstPersonMontages.getAttackSlot(interactionHand), Transition.INSTANT);
    }

    public static void addStatesForHandPose(StateMachineFunction.Builder stateMachineBuilder, StateAlias.Builder fromLoweringAliasBuilder, InteractionHand interactionHand, FirstPersonHandPose handPose, PoseFunction<LocalSpacePose> posePoseFunction, PoseFunction<LocalSpacePose> loweringPoseFunction, PoseFunction<LocalSpacePose> raisingPoseFunction, Transition poseToLoweringTiming, Transition raisingToPoseTiming) {
        stateMachineBuilder.defineState(StateDefinition.builder(handPose.poseState, MontageSlotFunction.of(posePoseFunction, interactionHand == InteractionHand.MAIN_HAND ? "main_hand_attack" : "off_hand_attack")).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(handPose.loweringState, loweringPoseFunction).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(handPose.raisingState, MontageSlotFunction.of(raisingPoseFunction, interactionHand == InteractionHand.MAIN_HAND ? "main_hand_attack" : "off_hand_attack")).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(handPose.poseState).isTakenOnAnimationFinished(1.0f).setTiming(raisingToPoseTiming).build()).addOutboundTransition(StateTransition.builder(handPose.poseState).isTakenIfTrue(context -> FirstPersonHandPose.shouldSkipRaiseAnimation(context, interactionHand)).setTiming(Transition.builder(TimeSpan.ofTicks(3.0f)).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(handPose.poseState, handPose.raisingState)).addOutboundTransition(StateTransition.builder(handPose.loweringState).isTakenIfTrue(context -> FirstPersonHandPose.shouldTakeHardSwitchTransition(context, interactionHand)).setTiming(poseToLoweringTiming).setPriority(50).build()).addOutboundTransition(StateTransition.builder(HAND_POSE_DROPPING_LAST_ITEM_STATE).isTakenIfTrue(context -> FirstPersonHandPose.shouldTakeDropLastItemTransition(context, interactionHand)).setPriority(80).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).build()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), interactionHand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPose.clearMontagesInAttackSlot(evaluationState, interactionHand)).build()).addOutboundTransition(StateTransition.builder(HAND_POSE_USING_LAST_ITEM_STATE).isTakenIfTrue(context -> FirstPersonHandPose.shouldTakeUseLastItemTransition(context, interactionHand)).setPriority(70).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).build()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), interactionHand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPose.clearMontagesInAttackSlot(evaluationState, interactionHand)).build()).addOutboundTransition(StateTransition.builder(HAND_POSE_THROWING_TRIDENT_STATE).isTakenIfTrue(context -> FirstPersonHandPose.shouldTakeThrowTridentTransition(context, interactionHand)).setPriority(60).setTiming(Transition.builder(TimeSpan.ofTicks(1.0f)).build()).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), interactionHand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPose.clearMontagesInAttackSlot(evaluationState, interactionHand)).build()).build());
        fromLoweringAliasBuilder.addOriginatingState(handPose.loweringState).addOutboundTransition(StateTransition.builder(handPose.raisingState).setTiming(Transition.INSTANT).isTakenIfTrue(StateTransition.MOST_RELEVANT_ANIMATION_PLAYER_IS_FINISHING.and(context -> FirstPersonHandPose.fromItemStack((ItemStack)context.driverContainer().getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand))) == handPose)).bindToOnTransitionTaken(evaluationState -> FirstPersonDrivers.updateRenderedItemIfNoTwoHandOverrides(evaluationState.driverContainer(), interactionHand)).bindToOnTransitionTaken(evaluationState -> FirstPersonHandPose.clearMontagesInAttackSlot(evaluationState, interactionHand)).build());
    }

    static {
        LOGGER = LogManager.getLogger((String)"Locomotion/FPJointAnimator/HandPose");
        TOOL_ITEM_TAGS = List.of(ItemTags.PICKAXES, ItemTags.AXES, ItemTags.SHOVELS, ItemTags.HOES);
        POSES_BY_USE_ANIMATION = Maps.newHashMap();
        POSES_BY_USE_ANIMATION.put(ItemUseAnimation.BRUSH, BRUSH);
        POSES_BY_USE_ANIMATION.put(ItemUseAnimation.SPEAR, TRIDENT);
        POSES_BY_USE_ANIMATION.put(ItemUseAnimation.CROSSBOW, CROSSBOW);
        POSES_BY_USE_ANIMATION.put(ItemUseAnimation.BOW, BOW);
        POSES_BY_USE_ANIMATION.put(ItemUseAnimation.SPYGLASS, SPYGLASS);
    }
}

