/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.JointAnimator;
import com.trainguy9512.locomotion.animation.animator.entity.LivingEntityJointAnimator;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPose;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonItemUpdateAnimations;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMovement;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonShield;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonSpyglass;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonTwoHandedActions;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonUseAnimations;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.driver.VariableDriver;
import com.trainguy9512.locomotion.animation.joint.JointChannel;
import com.trainguy9512.locomotion.animation.joint.skeleton.BlendMask;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.BlendPosesFunction;
import com.trainguy9512.locomotion.animation.pose.function.EmptyPoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.JointTransformerFunction;
import com.trainguy9512.locomotion.animation.pose.function.MakeDynamicAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.MirrorFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FirstPersonJointAnimator
implements LivingEntityJointAnimator<LocalPlayer, AvatarRenderState> {
    private static final Logger LOGGER = LogManager.getLogger((String)"Locomotion/FPJointAnimator");
    public static final String ROOT_JOINT = "root_jnt";
    public static final String CAMERA_JOINT = "camera_jnt";
    public static final String ARM_BUFFER_JOINT = "arm_buffer_jnt";
    public static final String RIGHT_ARM_BUFFER_JOINT = "arm_R_buffer_jnt";
    public static final String RIGHT_ARM_JOINT = "arm_R_jnt";
    public static final String RIGHT_HAND_JOINT = "hand_R_jnt";
    public static final String RIGHT_ITEM_JOINT = "item_R_jnt";
    public static final String LEFT_ARM_BUFFER_JOINT = "arm_L_buffer_jnt";
    public static final String LEFT_ARM_JOINT = "arm_L_jnt";
    public static final String LEFT_HAND_JOINT = "hand_L_jnt";
    public static final String LEFT_ITEM_JOINT = "item_L_jnt";
    public static final String IS_USING_PROPERTY_ATTRIBUTE = "is_using_property";
    public static final String USE_DURATION_PROPERTY_ATTRIBUTE = "use_duration_property";
    public static final String CROSSBOW_PULL_PROPERTY_ATTRIBUTE = "crossbow_pull_property";
    public static final Set<String> RIGHT_SIDE_JOINTS = Set.of("arm_R_buffer_jnt", "arm_R_jnt", "hand_R_jnt", "item_R_jnt");
    public static final Set<String> LEFT_SIDE_JOINTS = Set.of("arm_L_buffer_jnt", "arm_L_jnt", "hand_L_jnt", "item_L_jnt");
    public static final BlendMask LEFT_SIDE_MASK = BlendMask.builder().defineForMultipleJoints(LEFT_SIDE_JOINTS, 1.0f).build();
    public static final BlendMask RIGHT_SIDE_MASK = BlendMask.builder().defineForMultipleJoints(RIGHT_SIDE_JOINTS, 1.0f).build();
    public static final BlendMask CAMERA_MASK = BlendMask.builder().defineForJoint("camera_jnt", 1.0f).build();
    public static final BlendMask ARMS_ONLY_MASK = BlendMask.builder().defineForJoint("arm_R_buffer_jnt", 1.0f).defineForJoint("arm_R_jnt", 1.0f).defineForJoint("arm_L_buffer_jnt", 1.0f).defineForJoint("arm_L_jnt", 1.0f).build();
    public static final String MAIN_HAND_POSE_CACHE = "main_hand_pose";
    public static final String OFF_HAND_POSE_CACHE = "off_hand_pose";

    @Override
    public void postProcessModelParts(EntityModel<AvatarRenderState> entityModel, AvatarRenderState entityRenderState) {
    }

    @Override
    public ResourceLocation getJointSkeleton() {
        return ResourceLocation.fromNamespaceAndPath((String)"locomotion", (String)"skeletons/entity/player/first_person.json");
    }

    @Override
    public JointAnimator.PoseCalculationFrequency getPoseCalulationFrequency() {
        return JointAnimator.PoseCalculationFrequency.CALCULATE_EVERY_FRAME;
    }

    @Override
    public PoseFunction<LocalSpacePose> constructPoseFunction(CachedPoseContainer cachedPoseContainer) {
        PoseFunction<LocalSpacePose> mainHandPose = FirstPersonHandPose.constructPoseFunction(cachedPoseContainer, InteractionHand.MAIN_HAND);
        PoseFunction<LocalSpacePose> offHandPose = FirstPersonHandPose.constructPoseFunction(cachedPoseContainer, InteractionHand.OFF_HAND);
        cachedPoseContainer.register(MAIN_HAND_POSE_CACHE, mainHandPose, true);
        cachedPoseContainer.register(OFF_HAND_POSE_CACHE, MirrorFunction.of(offHandPose), true);
        ApplyAdditiveFunction composedCameraPoseFunction = ApplyAdditiveFunction.of(cachedPoseContainer.getOrThrow(MAIN_HAND_POSE_CACHE), MakeDynamicAdditiveFunction.of(cachedPoseContainer.getOrThrow(OFF_HAND_POSE_CACHE), EmptyPoseFunction.of(false)));
        PoseFunction<LocalSpacePose> pose = BlendPosesFunction.builder(cachedPoseContainer.getOrThrow(MAIN_HAND_POSE_CACHE)).addBlendInput(cachedPoseContainer.getOrThrow(OFF_HAND_POSE_CACHE), evaluationState -> Float.valueOf(1.0f), LEFT_SIDE_MASK).addBlendInput(composedCameraPoseFunction, evaluationState -> Float.valueOf(1.0f), CAMERA_MASK).build();
        pose = FirstPersonTwoHandedActions.constructPoseFunction(pose, cachedPoseContainer);
        pose = FirstPersonShield.constructWithHandsOffsetByShield(cachedPoseContainer, pose);
        pose = FirstPersonMovement.constructWithMovementAnimations(pose, cachedPoseContainer);
        pose = BlendPosesFunction.builder(pose).addBlendInput(EmptyPoseFunction.of(), functionEvaluationState -> Float.valueOf(1.0f - LocomotionMain.CONFIG.data().firstPersonPlayer.cameraShakeMasterIntensity), CAMERA_MASK).build();
        pose = MirrorFunction.of(pose, context -> Minecraft.getInstance().options.mainHand().get() == HumanoidArm.LEFT);
        pose = JointTransformerFunction.localOrParentSpaceBuilder(pose, ARM_BUFFER_JOINT).setTranslation(context -> ((Vector3f)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.MOVEMENT_DIRECTION_OFFSET, context.partialTicks())).mul(1.5f, new Vector3f()), JointChannel.TransformType.ADD, JointChannel.TransformSpace.COMPONENT).setRotationEuler(context -> {
            Vector3f main_rotation = (Vector3f)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.CAMERA_ROTATION_DAMPING, context.partialTicks());
            float z_rotation = ((Float)context.driverContainer().getInterpolatedDriverValue(FirstPersonDrivers.CAMERA_Z_ROTATION_DAMPING, context.partialTicks())).floatValue();
            return new Vector3f(main_rotation.x, main_rotation.y, z_rotation).mul(-0.15f, -0.15f, -0.08f, new Vector3f());
        }, JointChannel.TransformType.ADD, JointChannel.TransformSpace.COMPONENT).setWeight(interpolationContext -> Float.valueOf(LocomotionMain.CONFIG.data().firstPersonPlayer.enableCameraRotationDamping ? 1.0f : 0.0f)).build();
        pose = FirstPersonSpyglass.getHiddenArmsSpyglassPose(pose);
        return pose;
    }

    @Override
    public void extractAnimationData(LocalPlayer player, OnTickDriverContainer driverContainer, MontageManager montageManager) {
        this.extractMovementPoseData(player, driverContainer);
        this.extractItemData(player, driverContainer);
        driverContainer.getDriver(FirstPersonDrivers.HOTBAR_SLOT).setValue(player.getInventory().getSelectedSlot());
        this.handleMontagesFromTriggerDrivers(player, driverContainer, montageManager);
        this.extractInteractionHandData(player, driverContainer, montageManager);
        this.extractDampedCameraData(player, driverContainer, montageManager);
    }

    public void extractMovementPoseData(LocalPlayer player, OnTickDriverContainer driverContainer) {
        driverContainer.getDriver(FirstPersonDrivers.MODIFIED_WALK_SPEED).setValue(Float.valueOf(player.walkAnimation.speed()));
        driverContainer.getDriver(FirstPersonDrivers.HORIZONTAL_MOVEMENT_SPEED).setValue(Float.valueOf(new Vector3f((float)(player.getX() - player.xo), 0.0f, (float)(player.getZ() - player.zo)).length()));
        driverContainer.getDriver(FirstPersonDrivers.VERTICAL_MOVEMENT_SPEED).setValue(Float.valueOf((float)(player.getY() - player.yo)));
        driverContainer.getDriver(FirstPersonDrivers.IS_IN_RIPTIDE).setValue(player.isAutoSpinAttack());
        driverContainer.getDriver(FirstPersonDrivers.IS_MOVING).setValue(player.input.keyPresses.forward() || player.input.keyPresses.backward() || player.input.keyPresses.left() || player.input.keyPresses.right());
        driverContainer.getDriver(FirstPersonDrivers.IS_ON_GROUND).setValue(player.onGround());
        driverContainer.getDriver(FirstPersonDrivers.IS_JUMPING).setValue(player.input.keyPresses.jump());
        driverContainer.getDriver(FirstPersonDrivers.IS_CROUCHING).setValue(player.isCrouching());
        driverContainer.getDriver(FirstPersonDrivers.IS_UNDERWATER).setValue(player.isUnderWater() || player.isInWater() && !player.onGround());
        driverContainer.getDriver(FirstPersonDrivers.IS_PASSENGER).setValue(player.isPassenger());
        driverContainer.getDriver(FirstPersonDrivers.HAS_SCREEN_OPEN).setValue(Minecraft.getInstance().screen != null);
        boolean isSwimmingUnderwater = player.getPose() == Pose.SWIMMING && player.isInWater() && (Boolean)driverContainer.getDriverValue(FirstPersonDrivers.IS_USING_MAIN_HAND_ITEM) == false && (Boolean)driverContainer.getDriverValue(FirstPersonDrivers.IS_USING_OFF_HAND_ITEM) == false && !player.isAutoSpinAttack();
        driverContainer.getDriver(FirstPersonDrivers.IS_SWIMMING_UNDERWATER).setValue(isSwimmingUnderwater);
    }

    public void extractItemData(LocalPlayer player, OnTickDriverContainer driverContainer) {
        for (InteractionHand interactionHand : InteractionHand.values()) {
            VariableDriver<ItemStack> itemDriver = driverContainer.getDriver(FirstPersonDrivers.getItemDriver(interactionHand));
            VariableDriver<ItemStack> itemCopyReferenceDriver = driverContainer.getDriver(FirstPersonDrivers.getItemCopyReferenceDriver(interactionHand));
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            itemDriver.setValue(itemInHand);
            itemCopyReferenceDriver.setValue(itemInHand.copy());
        }
    }

    public void handleMontagesFromTriggerDrivers(LocalPlayer player, OnTickDriverContainer driverContainer, MontageManager montageManager) {
        driverContainer.getDriver(FirstPersonDrivers.HAS_DROPPED_ITEM).runAndConsumeIfTriggered(() -> montageManager.playMontage(FirstPersonMontages.USE_MAIN_HAND_MONTAGE));
        driverContainer.getDriver(FirstPersonDrivers.HAS_ATTACKED).runAndConsumeIfTriggered(() -> FirstPersonMontages.playAttackMontage(driverContainer, montageManager));
        if (driverContainer.getDriver(FirstPersonDrivers.IS_MINING).getCurrentValue().booleanValue()) {
            montageManager.interruptMontagesInSlot("main_hand_attack", Transition.builder(TimeSpan.ofTicks(2.0f)).build());
        }
        driverContainer.getDriver(FirstPersonDrivers.HAS_BLOCKED_ATTACK).runAndConsumeIfTriggered(() -> montageManager.playMontage(FirstPersonMontages.SHIELD_BLOCK_IMPACT_MONTAGE));
        driverContainer.getDriver(FirstPersonDrivers.LAST_USED_SWING_TIME).setValue(player.swingTime);
        driverContainer.getDriver(FirstPersonDrivers.HAS_SWAPPED_ITEMS).runAndConsumeIfTriggered(() -> {});
    }

    public void extractInteractionHandData(LocalPlayer dataReference, OnTickDriverContainer driverContainer, MontageManager montageManager) {
        for (InteractionHand interactionHand : InteractionHand.values()) {
            ItemStack itemInHand = (ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand));
            ItemStack renderedItemInHand = (ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(interactionHand));
            FirstPersonUseAnimations.playUseAnimationIfTriggered(driverContainer, montageManager, interactionHand);
            FirstPersonItemUpdateAnimations.testForAndPlayItemUpdateAnimations(driverContainer, montageManager, interactionHand);
            driverContainer.getDriver(FirstPersonDrivers.getUsingItemDriver(interactionHand)).setValue(false);
            if (dataReference.isUsingItem() && dataReference.getUsedItemHand() == interactionHand) {
                driverContainer.getDriver(FirstPersonDrivers.getUsingItemDriver(interactionHand)).setValue(true);
                montageManager.interruptMontagesInSlot(FirstPersonMontages.getAttackSlot(interactionHand), Transition.builder(TimeSpan.ofSeconds(0.1f)).setEasement(Easing.SINE_IN_OUT).build());
                driverContainer.getDriver(FirstPersonDrivers.LAST_USED_HAND).setValue(interactionHand);
                driverContainer.getDriver(FirstPersonDrivers.PROJECTILE_ITEM).setValue(dataReference.getProjectile(itemInHand));
                if (itemInHand.getUseAnimation() == ItemUseAnimation.CROSSBOW) {
                    float chargeTime = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)itemInHand, (LivingEntity)dataReference, (float)1.25f);
                    float chargeSpeedMultiplier = 1.25f / chargeTime;
                    driverContainer.getDriver(FirstPersonDrivers.CROSSBOW_RELOAD_SPEED).setValue(Float.valueOf(chargeSpeedMultiplier));
                }
            }
            ItemStack renderedItem = (ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(interactionHand));
            boolean isItemOnCooldown = dataReference.getCooldowns().isOnCooldown(renderedItem);
            driverContainer.getDriver(FirstPersonDrivers.getItemOnCooldownDriver(interactionHand)).setValue(isItemOnCooldown);
        }
    }

    public void extractDampedCameraData(LocalPlayer dataReference, OnTickDriverContainer driverContainer, MontageManager montageManager) {
        Vector3f velocity = new Vector3f((float)(dataReference.getX() - dataReference.xo), (float)(dataReference.getY() - dataReference.yo), (float)(dataReference.getZ() - dataReference.zo));
        velocity.mul(1.0f, 0.0f, 1.0f).mul(dataReference.isSprinting() ? 4.0f : 3.0f).min((Vector3fc)new Vector3f(1.0f)).max((Vector3fc)new Vector3f(-1.0f));
        driverContainer.getDriver(FirstPersonDrivers.DAMPED_VELOCITY).setValue(velocity);
        Vector3f dampedVelocity = new Vector3f((Vector3fc)driverContainer.getDriverValue(FirstPersonDrivers.DAMPED_VELOCITY));
        Quaternionf rotation = new Quaternionf().rotationYXZ((float)Math.PI - dataReference.getYRot() * ((float)Math.PI / 180), -dataReference.getXRot() * ((float)Math.PI / 180), 0.0f);
        Vector3f movementDirection = new Vector3f(dampedVelocity.dot((Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)rotation)), dampedVelocity.dot((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)rotation)), dampedVelocity.dot((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)rotation)));
        if (((Boolean)driverContainer.getDriverValue(FirstPersonDrivers.IS_PASSENGER)).booleanValue()) {
            movementDirection.set(0.0f);
        }
        driverContainer.getDriver(FirstPersonDrivers.MOVEMENT_DIRECTION_OFFSET).setValue(movementDirection);
        driverContainer.getDriver(FirstPersonDrivers.CAMERA_ROTATION_DAMPING).setValue(new Vector3f(dataReference.getXRot(), dataReference.getYRot(), dataReference.getYRot()).mul((float)Math.PI / 180));
        driverContainer.getDriver(FirstPersonDrivers.CAMERA_Z_ROTATION_DAMPING).setValue(Float.valueOf(((Vector3f)driverContainer.getDriverValue(FirstPersonDrivers.CAMERA_ROTATION_DAMPING)).y));
        driverContainer.getDriver(FirstPersonDrivers.CAMERA_ROTATION_X).setValue(Float.valueOf(dataReference.getXRot()));
    }
}

