/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonAnimationSequences;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonJointAnimator;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMap;
import com.trainguy9512.locomotion.animation.pose.LocalSpacePose;
import com.trainguy9512.locomotion.animation.pose.function.ApplyAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.BlendPosesFunction;
import com.trainguy9512.locomotion.animation.pose.function.BlendedSequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.MakeDynamicAdditiveFunction;
import com.trainguy9512.locomotion.animation.pose.function.PoseFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequenceEvaluatorFunction;
import com.trainguy9512.locomotion.animation.pose.function.SequencePlayerFunction;
import com.trainguy9512.locomotion.animation.pose.function.cache.CachedPoseContainer;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateAlias;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateDefinition;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateMachineFunction;
import com.trainguy9512.locomotion.animation.pose.function.statemachine.StateTransition;
import com.trainguy9512.locomotion.util.Easing;
import com.trainguy9512.locomotion.util.TimeSpan;
import com.trainguy9512.locomotion.util.Transition;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class FirstPersonMovement {
    public static String ADDITIVE_CROUCH_POSE_CACHE = "additive_crouch_pose";
    public static String MOVEMENT_WITHOUT_OVERRIDES_CACHE = "movement_without_overrides";
    public static final String OVERRIDING_MOVEMENT_IDLE_STATE = "idle";
    public static final String OVERRIDING_MOVEMENT_SWIMMING_STATE = "swimming";
    public static final String WALKING_IDLE_STATE = "idle";
    public static final String WALKING_WALKING_STATE = "walking";
    public static final String WALKING_STOPPING_STATE = "stopping";
    public static final String CROUCHING_STANDING_STATE = "standing";
    public static final String CROUCHING_CROUCH_IN_STATE = "crouch_in";
    public static final String CROUCHING_CROUCHING_STATE = "crouching";
    public static final String CROUCHING_CROUCH_OUT_STATE = "crouch_out";
    public static final String FALLING_STANDING_STATE = "standing";
    public static final String FALLING_STANDING_TO_FALLING_STATE = "standing_to_falling";
    public static final String FALLING_FALLING_STATE = "falling";
    public static final String FALLING_JUMP_STATE = "jump";
    public static final String FALLING_LAND_STATE = "land";
    public static final String FALLING_SOFT_LAND_STATE = "soft_land";
    public static final String UNDERWATER_IDLE_STATE = "idle";
    public static final String UNDERWATER_TREADING_STATE = "treading";
    public static final String UNDERWATER_LAND_STATE = "land";
    public static final String UNDERWATER_ON_GROUND_STATE = "on_ground";
    public static final String MOUNT_STANDING_STATE = "standing";
    public static final String MOUNT_MOUNT_ENTER_STATE = "mount_enter";
    public static final String MOUNT_MOUNTED_STATE = "mounted";

    public static PoseFunction<LocalSpacePose> constructWithMovementAnimations(PoseFunction<LocalSpacePose> inputPose, CachedPoseContainer cachedPoseContainer) {
        PoseFunction<LocalSpacePose> additiveMovement = FirstPersonMovement.constructAdditiveMovementPoseFunction(cachedPoseContainer);
        ApplyAdditiveFunction inputWithAdditiveMovement = ApplyAdditiveFunction.of(inputPose, additiveMovement);
        cachedPoseContainer.register(MOVEMENT_WITHOUT_OVERRIDES_CACHE, inputWithAdditiveMovement, true);
        PoseFunction<LocalSpacePose> inputWithAdditiveMovementCache = cachedPoseContainer.getOrThrow(MOVEMENT_WITHOUT_OVERRIDES_CACHE);
        PoseFunction<LocalSpacePose> additiveWithOverridingMovement = FirstPersonMovement.constructWithOverridingMovementAnimations(inputWithAdditiveMovementCache);
        BlendPosesFunction cacheWithOverridesMasked = BlendPosesFunction.builder(inputWithAdditiveMovementCache).addBlendInput(additiveWithOverridingMovement, evaluationState -> Float.valueOf(1.0f), FirstPersonJointAnimator.ARMS_ONLY_MASK).build();
        return cacheWithOverridesMasked;
    }

    public static boolean isJumpingAndCanBypassJumpAnimation(StateTransition.TransitionContext context) {
        return FirstPersonMovement.isJumping(context) && context.timeElapsedInCurrentState().in60FramesPerSecond() < 12.0f;
    }

    public static boolean isJumping(StateTransition.TransitionContext context) {
        boolean isJumping = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_JUMPING);
        boolean isGrounded = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_ON_GROUND);
        boolean wasJustGrounded = context.driverContainer().getDriver(FirstPersonDrivers.IS_ON_GROUND).getPreviousValue();
        return isJumping && !isGrounded && wasJustGrounded;
    }

    public static boolean isWalking(StateTransition.TransitionContext context) {
        return (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_MOVING);
    }

    public static boolean isNotWalking(StateTransition.TransitionContext context) {
        return !FirstPersonMovement.isWalking(context);
    }

    public static boolean isCancellingWalk(StateTransition.TransitionContext context) {
        return FirstPersonMovement.isNotWalking(context) && !StateTransition.CURRENT_TRANSITION_FINISHED.test(context);
    }

    public static boolean isEasingOutOfWalk(StateTransition.TransitionContext context) {
        return FirstPersonMovement.isNotWalking(context) && StateTransition.CURRENT_TRANSITION_FINISHED.test(context);
    }

    public static boolean isCrouching(StateTransition.TransitionContext context) {
        return (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_CROUCHING);
    }

    public static boolean isNotCrouching(StateTransition.TransitionContext context) {
        return !FirstPersonMovement.isCrouching(context);
    }

    public static PoseFunction<LocalSpacePose> constructAdditiveMovementPoseFunction(CachedPoseContainer cachedPoseContainer) {
        cachedPoseContainer.register(ADDITIVE_CROUCH_POSE_CACHE, FirstPersonMovement.constructAdditiveCrouchStateMachine(), true);
        PoseFunction<LocalSpacePose> pose = FirstPersonMovement.constructWalkingStateMachine();
        pose = FirstPersonMovement.constructWithCrouchPose(cachedPoseContainer, pose);
        pose = FirstPersonMovement.constructWithFallingStateMachine(cachedPoseContainer, pose);
        pose = FirstPersonMovement.constructWithUnderwaterStateMachine(pose);
        pose = FirstPersonMovement.constructWithMountStateMachine(pose);
        pose = FirstPersonMap.blendAdditiveMovementIfHoldingMap(pose);
        SequenceEvaluatorFunction additiveReferencePose = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build();
        MakeDynamicAdditiveFunction additivePose = MakeDynamicAdditiveFunction.of(pose, additiveReferencePose);
        return additivePose;
    }

    private static boolean isDiveSwimming(StateTransition.TransitionContext context) {
        return (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_SWIMMING_UNDERWATER);
    }

    private static boolean isNoLongerSwimming(StateTransition.TransitionContext context) {
        return !FirstPersonMovement.isDiveSwimming(context);
    }

    private static String getOverridingMovementEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        return "idle";
    }

    public static PoseFunction<LocalSpacePose> constructWithOverridingMovementAnimations(PoseFunction<LocalSpacePose> inputPose) {
        SequencePlayerFunction swimmingPoseFunction = ((SequencePlayerFunction.Builder)((SequencePlayerFunction.Builder)((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.OVERRIDING_MOVEMENT_SWIMMING).setPlayRate(1.2f)).setResetStartTimeOffset(TimeSpan.of30FramesPerSecond(39.0f))).setLooping(true)).build();
        PoseFunction<LocalSpacePose> overridingMovementStateMachine = StateMachineFunction.builder(FirstPersonMovement::getOverridingMovementEntryState).resetsUponRelevant(true).defineState(StateDefinition.builder("idle", inputPose).resetsPoseFunctionUponEntry(false).addOutboundTransition(StateTransition.builder(OVERRIDING_MOVEMENT_SWIMMING_STATE).isTakenIfTrue(FirstPersonMovement::isDiveSwimming).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.4f)).setEasement(Easing.CUBIC_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(OVERRIDING_MOVEMENT_SWIMMING_STATE, swimmingPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder("idle").isTakenIfTrue(FirstPersonMovement::isNoLongerSwimming).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.6f)).setEasement(Easing.QUART_IN_OUT).build()).build()).build()).build();
        return overridingMovementStateMachine;
    }

    private static String getWalkingEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        boolean isMoving = (Boolean)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.IS_MOVING);
        return isMoving ? WALKING_WALKING_STATE : "idle";
    }

    public static PoseFunction<LocalSpacePose> constructWalkingStateMachine() {
        BlendPosesFunction idleAnimationPlayer = BlendPosesFunction.builder(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build()).addBlendInput(((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_IDLE).setLooping(true)).build(), evaluationState -> Float.valueOf(0.8f)).build();
        SequencePlayerFunction stoppingPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_WALK_TO_STOP).setPlayRate(0.6f)).build();
        BlendedSequencePlayerFunction walkingPoseFunction = ((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)BlendedSequencePlayerFunction.builder(FirstPersonDrivers.MODIFIED_WALK_SPEED).setResetStartTimeOffset(TimeSpan.of30FramesPerSecond(5.0f))).addEntry(0.0f, FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE, 0.5f)).addEntry(0.5f, FirstPersonAnimationSequences.GROUND_MOVEMENT_WALKING, 2.0f)).addEntry(0.86f, FirstPersonAnimationSequences.GROUND_MOVEMENT_WALKING, 2.25f)).addEntry(1.0f, FirstPersonAnimationSequences.GROUND_MOVEMENT_WALKING, 3.5f)).build();
        PoseFunction<LocalSpacePose> walkingStateMachine = StateMachineFunction.builder(FirstPersonMovement::getWalkingEntryState).resetsUponRelevant(true).defineState(StateDefinition.builder("idle", idleAnimationPlayer).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(WALKING_WALKING_STATE).isTakenIfTrue(FirstPersonMovement::isWalking).setTiming(Transition.builder(TimeSpan.ofSeconds(0.3f)).setEasement(Easing.EXPONENTIAL_OUT).build()).build()).build()).defineState(StateDefinition.builder(WALKING_WALKING_STATE, walkingPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(WALKING_STOPPING_STATE).isTakenIfTrue(FirstPersonMovement::isEasingOutOfWalk).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.SINE_IN_OUT).build()).build()).addOutboundTransition(StateTransition.builder("idle").isTakenIfTrue(FirstPersonMovement::isCancellingWalk).setTiming(Transition.builder(TimeSpan.ofSeconds(0.3f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(WALKING_STOPPING_STATE, stoppingPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder("idle").isTakenOnAnimationFinished(0.0f).setTiming(Transition.builder(TimeSpan.ofSeconds(1.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).addOutboundTransition(StateTransition.builder(WALKING_WALKING_STATE).isTakenIfTrue(StateTransition.CURRENT_TRANSITION_FINISHED.and(FirstPersonMovement::isWalking)).setTiming(Transition.builder(TimeSpan.ofSeconds(0.3f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).build();
        return walkingStateMachine;
    }

    private static String getCrouchingEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        boolean isCrouching = (Boolean)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.IS_CROUCHING);
        return isCrouching ? CROUCHING_CROUCHING_STATE : "standing";
    }

    public static PoseFunction<LocalSpacePose> constructAdditiveCrouchStateMachine() {
        SequenceEvaluatorFunction standingPoseFunction = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build();
        SequenceEvaluatorFunction crouchPoseFunction = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_CROUCH_OUT).evaluatesPoseAt(TimeSpan.ZERO).build();
        SequencePlayerFunction crouchInPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_CROUCH_IN).setPlayRate(0.8f)).build();
        SequencePlayerFunction crouchOutPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_CROUCH_OUT).setPlayRate(0.9f)).build();
        PoseFunction<LocalSpacePose> crouchStateMachine = StateMachineFunction.builder(FirstPersonMovement::getCrouchingEntryState).resetsUponRelevant(true).defineState(StateDefinition.builder("standing", standingPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CROUCHING_CROUCH_IN_STATE).isTakenIfTrue(FirstPersonMovement::isCrouching).setTiming(Transition.SINGLE_TICK).setPriority(80).build()).build()).defineState(StateDefinition.builder(CROUCHING_CROUCH_IN_STATE, crouchInPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CROUCHING_CROUCHING_STATE).isTakenOnAnimationFinished(0.0f).setTiming(Transition.builder(TimeSpan.ofSeconds(1.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).addOutboundTransition(StateTransition.builder(CROUCHING_CROUCH_OUT_STATE).isTakenIfTrue(FirstPersonMovement::isNotCrouching).setPriority(60).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(CROUCHING_CROUCHING_STATE, crouchPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(CROUCHING_CROUCH_OUT_STATE).isTakenIfTrue(FirstPersonMovement::isNotCrouching).setTiming(Transition.SINGLE_TICK).setPriority(80).build()).build()).defineState(StateDefinition.builder(CROUCHING_CROUCH_OUT_STATE, crouchOutPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder("standing").isTakenOnAnimationFinished(0.0f).setTiming(Transition.builder(TimeSpan.ofSeconds(1.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).addOutboundTransition(StateTransition.builder(CROUCHING_CROUCH_IN_STATE).isTakenIfTrue(FirstPersonMovement::isCrouching).setPriority(60).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).build();
        MakeDynamicAdditiveFunction additiveCrouchPose = MakeDynamicAdditiveFunction.of(crouchStateMachine, standingPoseFunction);
        return additiveCrouchPose;
    }

    public static PoseFunction<LocalSpacePose> constructWithCrouchPose(CachedPoseContainer cachedPoseContainer, PoseFunction<LocalSpacePose> inputPose) {
        PoseFunction<LocalSpacePose> additiveCrouchPose = cachedPoseContainer.getOrThrow(ADDITIVE_CROUCH_POSE_CACHE);
        ApplyAdditiveFunction inputWithAdditiveCrouchPose = ApplyAdditiveFunction.of(inputPose, additiveCrouchPose);
        return inputWithAdditiveCrouchPose;
    }

    private static String getFallingEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        boolean isGrounded = (Boolean)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.IS_ON_GROUND);
        return isGrounded ? "standing" : FALLING_FALLING_STATE;
    }

    public static PoseFunction<LocalSpacePose> constructWithFallingStateMachine(CachedPoseContainer cachedPoseContainer, PoseFunction<LocalSpacePose> standingPose) {
        PoseFunction<LocalSpacePose> jumpPoseFunction = SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_JUMP).build();
        BlendedSequencePlayerFunction fallingPoseFunction = ((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)BlendedSequencePlayerFunction.builder(FirstPersonDrivers.VERTICAL_MOVEMENT_SPEED).addEntry(0.5f, FirstPersonAnimationSequences.GROUND_MOVEMENT_FALLING_UP)).addEntry(-0.0f, FirstPersonAnimationSequences.GROUND_MOVEMENT_FALLING_IN_PLACE)).addEntry(-1.0f, FirstPersonAnimationSequences.GROUND_MOVEMENT_FALLING_DOWN)).build();
        PoseFunction<LocalSpacePose> landPoseFunction = SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_LAND).build();
        PoseFunction<LocalSpacePose> softLandPoseFunction = BlendPosesFunction.builder(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build()).addBlendInput(((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_LAND).setPlayRate(1.0f)).build(), evaluationState -> Float.valueOf(0.5f)).build();
        PoseFunction<LocalSpacePose> standingToFallingPoseFunction = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build();
        jumpPoseFunction = FirstPersonMovement.constructWithCrouchPose(cachedPoseContainer, jumpPoseFunction);
        landPoseFunction = FirstPersonMovement.constructWithCrouchPose(cachedPoseContainer, landPoseFunction);
        softLandPoseFunction = FirstPersonMovement.constructWithCrouchPose(cachedPoseContainer, softLandPoseFunction);
        standingToFallingPoseFunction = FirstPersonMovement.constructWithCrouchPose(cachedPoseContainer, standingToFallingPoseFunction);
        PoseFunction<LocalSpacePose> fallingStateMachine = StateMachineFunction.builder(FirstPersonMovement::getFallingEntryState).resetsUponRelevant(true).defineState(StateDefinition.builder("standing", standingPose).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(FALLING_STANDING_TO_FALLING_STATE, standingToFallingPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(FALLING_FALLING_STATE).isTakenIfTrue(StateTransition.ALWAYS_TRUE).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.SINE_OUT).build()).build()).build()).defineState(StateDefinition.builder(FALLING_FALLING_STATE, fallingPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder("land").isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.IS_ON_GROUND)).setTiming(Transition.SINGLE_TICK).setPriority(50).build()).addOutboundTransition(StateTransition.builder(FALLING_SOFT_LAND_STATE).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.IS_ON_GROUND).and(StateTransition.CURRENT_TRANSITION_FINISHED.negate())).setTiming(Transition.SINGLE_TICK).setPriority(60).build()).addOutboundTransition(StateTransition.builder("standing").isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.IS_ON_GROUND).and(StateTransition.CURRENT_TRANSITION_FINISHED.negate()).and(StateTransition.takeIfTimeInStateLessThan(TimeSpan.ofSeconds(0.1f)))).setTiming(Transition.builder(TimeSpan.ofSeconds(0.4f)).setEasement(Easing.CUBIC_OUT).build()).setPriority(70).build()).addOutboundTransition(StateTransition.builder(FALLING_JUMP_STATE).isTakenIfTrue(FirstPersonMovement::isJumping).setTiming(Transition.SINGLE_TICK).setPriority(80).build()).build()).defineState(StateDefinition.builder(FALLING_JUMP_STATE, jumpPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(FALLING_FALLING_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(19.0f)).setEasement(Easing.CUBIC_OUT).build()).build()).addOutboundTransition(StateTransition.builder(FALLING_FALLING_STATE).isTakenIfTrue(StateTransition.CURRENT_TRANSITION_FINISHED.and(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.IS_ON_GROUND))).setTiming(Transition.SINGLE_TICK).build()).build()).defineState(StateDefinition.builder("land", landPoseFunction).resetsPoseFunctionUponEntry(true).build()).defineState(StateDefinition.builder(FALLING_SOFT_LAND_STATE, softLandPoseFunction).resetsPoseFunctionUponEntry(true).build()).addStateAlias(StateAlias.builder(Set.of("land", FALLING_SOFT_LAND_STATE)).addOutboundTransition(StateTransition.builder("standing").isTakenIfTrue(StateTransition.MOST_RELEVANT_ANIMATION_PLAYER_HAS_FINISHED.and(FirstPersonMovement::isNotWalking)).setTiming(Transition.builder(TimeSpan.ofSeconds(1.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).addOutboundTransition(StateTransition.builder("standing").isTakenIfTrue(FirstPersonMovement::isWalking).setTiming(Transition.builder(TimeSpan.ofSeconds(0.5f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(60).build()).addOutboundTransition(StateTransition.builder(FALLING_FALLING_STATE).isTakenIfTrue(FirstPersonMovement::isJumpingAndCanBypassJumpAnimation).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.SINE_OUT).build()).setPriority(70).build()).build()).addStateAlias(StateAlias.builder(Set.of("land", FALLING_SOFT_LAND_STATE, "standing")).addOutboundTransition(StateTransition.builder(FALLING_JUMP_STATE).isTakenIfTrue(FirstPersonMovement::isJumping).setTiming(Transition.SINGLE_TICK).setPriority(60).build()).addOutboundTransition(StateTransition.builder(FALLING_STANDING_TO_FALLING_STATE).isTakenIfTrue(StateTransition.takeIfBooleanDriverTrue(FirstPersonDrivers.IS_ON_GROUND).negate()).setTiming(Transition.builder(TimeSpan.ofTicks(2.0f)).setEasement(Easing.SINE_IN_OUT).build()).setPriority(50).build()).build()).build();
        return fallingStateMachine;
    }

    private static String getUnderwaterEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        boolean onGround = (Boolean)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.IS_ON_GROUND);
        return onGround ? UNDERWATER_ON_GROUND_STATE : "idle";
    }

    private static boolean isUnderWater(StateTransition.TransitionContext context) {
        return (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_UNDERWATER);
    }

    private static boolean isNoLongerUnderWater(StateTransition.TransitionContext context) {
        return !FirstPersonMovement.isUnderWater(context);
    }

    private static boolean isOnGround(StateTransition.TransitionContext context) {
        boolean isGrounded = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_ON_GROUND);
        boolean isDiveSwimming = (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_SWIMMING_UNDERWATER);
        return isGrounded && !isDiveSwimming;
    }

    private static boolean isNoLongerOnGround(StateTransition.TransitionContext context) {
        return !FirstPersonMovement.isOnGround(context);
    }

    public static PoseFunction<LocalSpacePose> constructWithUnderwaterStateMachine(PoseFunction<LocalSpacePose> inputPose) {
        ResourceLocation groundMovementSwimmingSequence = FirstPersonAnimationSequences.GROUND_MOVEMENT_SWIMMING_IDLE;
        BlendedSequencePlayerFunction treadingUnderwaterPoseFunction = ((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)BlendedSequencePlayerFunction.builder(FirstPersonDrivers.VERTICAL_MOVEMENT_SPEED).setResetStartTimeOffset(TimeSpan.of30FramesPerSecond(5.0f))).addEntry(-0.05f, groundMovementSwimmingSequence, 0.5f)).addEntry(0.0f, groundMovementSwimmingSequence, 1.0f)).addEntry(0.1f, groundMovementSwimmingSequence, 1.5f)).addEntry(0.3f, groundMovementSwimmingSequence, 2.0f)).build();
        BlendPosesFunction landUnderwaterPoseFunction = BlendPosesFunction.builder(SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build()).addBlendInput(((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_LAND).setPlayRate(0.7f)).build(), evaluationState -> Float.valueOf(0.4f)).build();
        BlendedSequencePlayerFunction onGroundUnderwaterPoseFunction = ((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)((BlendedSequencePlayerFunction.Builder)BlendedSequencePlayerFunction.builder(FirstPersonDrivers.MODIFIED_WALK_SPEED).setResetStartTimeOffset(TimeSpan.of30FramesPerSecond(5.0f))).addEntry(0.0f, FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE, 0.1f)).addEntry(0.3f, FirstPersonAnimationSequences.GROUND_MOVEMENT_WALKING, 0.8f)).build();
        PoseFunction<LocalSpacePose> underwaterStateMachine = StateMachineFunction.builder(FirstPersonMovement::getUnderwaterEntryState).resetsUponRelevant(true).defineState(StateDefinition.builder("idle", inputPose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(UNDERWATER_TREADING_STATE).isTakenIfTrue(FirstPersonMovement::isUnderWater).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.4f)).setEasement(Easing.CUBIC_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(UNDERWATER_TREADING_STATE, treadingUnderwaterPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder("land").isTakenIfTrue(FirstPersonMovement::isOnGround).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.CUBIC_OUT).build()).build()).build()).defineState(StateDefinition.builder("land", landUnderwaterPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(UNDERWATER_ON_GROUND_STATE).isTakenOnAnimationFinished(1.0f).setCanInterruptOtherTransitions(true).setTiming(Transition.builder(TimeSpan.ofSeconds(0.4f)).setEasement(Easing.CUBIC_IN_OUT).build()).build()).addOutboundTransition(StateTransition.builder(UNDERWATER_TREADING_STATE).isTakenIfTrue(FirstPersonMovement::isNoLongerOnGround).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.CUBIC_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(UNDERWATER_ON_GROUND_STATE, onGroundUnderwaterPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(UNDERWATER_TREADING_STATE).isTakenIfTrue(FirstPersonMovement::isNoLongerOnGround).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.CUBIC_IN_OUT).build()).build()).build()).addStateAlias(StateAlias.builder(Set.of(UNDERWATER_TREADING_STATE, UNDERWATER_ON_GROUND_STATE, "land")).addOutboundTransition(StateTransition.builder("idle").isTakenIfTrue(FirstPersonMovement::isNoLongerUnderWater).setCanInterruptOtherTransitions(false).setTiming(Transition.builder(TimeSpan.ofSeconds(0.6f)).setEasement(Easing.CUBIC_IN_OUT).build()).build()).build()).build();
        return underwaterStateMachine;
    }

    private static String getMountEntryState(PoseFunction.FunctionEvaluationState evaluationState) {
        boolean isPassenger = (Boolean)evaluationState.driverContainer().getDriverValue(FirstPersonDrivers.IS_PASSENGER);
        return isPassenger ? MOUNT_MOUNTED_STATE : "standing";
    }

    private static boolean isPassenger(StateTransition.TransitionContext context) {
        return (Boolean)context.driverContainer().getDriverValue(FirstPersonDrivers.IS_PASSENGER);
    }

    private static boolean isNotPassenger(StateTransition.TransitionContext context) {
        return !FirstPersonMovement.isPassenger(context);
    }

    public static PoseFunction<LocalSpacePose> constructWithMountStateMachine(PoseFunction<LocalSpacePose> inputPose) {
        SequencePlayerFunction mountEnterPoseFunction = ((SequencePlayerFunction.Builder)SequencePlayerFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_MOUNT_ENTER).setResetStartTimeOffset(TimeSpan.of60FramesPerSecond(6.0f))).build();
        SequenceEvaluatorFunction mountedPoseFunction = SequenceEvaluatorFunction.builder(FirstPersonAnimationSequences.GROUND_MOVEMENT_POSE).build();
        PoseFunction<LocalSpacePose> mountStateMachine = StateMachineFunction.builder(FirstPersonMovement::getMountEntryState).defineState(StateDefinition.builder("standing", inputPose).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(MOUNT_MOUNT_ENTER_STATE).isTakenIfTrue(FirstPersonMovement::isPassenger).setTiming(Transition.builder(TimeSpan.of60FramesPerSecond(4.0f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(MOUNT_MOUNT_ENTER_STATE, mountEnterPoseFunction).resetsPoseFunctionUponEntry(true).addOutboundTransition(StateTransition.builder(MOUNT_MOUNTED_STATE).isTakenOnAnimationFinished(1.0f).setTiming(Transition.builder(TimeSpan.ofSeconds(0.2f)).setEasement(Easing.SINE_IN_OUT).build()).build()).build()).defineState(StateDefinition.builder(MOUNT_MOUNTED_STATE, mountedPoseFunction).resetsPoseFunctionUponEntry(true).build()).addStateAlias(StateAlias.builder(Set.of(MOUNT_MOUNTED_STATE, MOUNT_MOUNT_ENTER_STATE)).addOutboundTransition(StateTransition.builder("standing").isTakenIfTrue(FirstPersonMovement::isNotPassenger).setTiming(Transition.builder(TimeSpan.ofSeconds(0.4f)).setEasement(Easing.EXPONENTIAL_OUT).build()).build()).build()).build();
        return mountStateMachine;
    }
}

