/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.animator.entity.firstperson;

import com.google.common.collect.BiMap;
import com.trainguy9512.locomotion.LocomotionMain;
import com.trainguy9512.locomotion.animation.animator.JointAnimatorDispatcher;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonDrivers;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonHandPose;
import com.trainguy9512.locomotion.animation.animator.entity.firstperson.FirstPersonMontages;
import com.trainguy9512.locomotion.animation.data.AnimationDataContainer;
import com.trainguy9512.locomotion.animation.data.OnTickDriverContainer;
import com.trainguy9512.locomotion.animation.driver.TriggerDriver;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageConfiguration;
import com.trainguy9512.locomotion.animation.pose.function.montage.MontageManager;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FirstPersonUseAnimations {
    private static final Set<UseAnimationRule> USE_ANIMATION_RULES = new HashSet<UseAnimationRule>();
    private static final List<Block> TILLABLES;
    private static final List<Block> FLATTENABLES;

    private static boolean shouldPlayAxeScrape(UseAnimationConditionContext context) {
        if (!context.currentItem.is(ItemTags.AXES) || !context.isTargetingBlock()) {
            return false;
        }
        if (WeatheringCopper.getPrevious((BlockState)context.lastTargetedBlock()).isPresent()) {
            return true;
        }
        if (((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)context.lastTargetedBlock().getBlock()) != null) {
            return true;
        }
        if (context.lastTargetedBlock().getBlock().asItem().getDefaultInstance().is(ItemTags.LOGS)) {
            return true;
        }
        return context.lastTargetedBlock().getBlock() == Blocks.BAMBOO_BLOCK;
    }

    private static boolean shouldPlayHoeTill(UseAnimationConditionContext context) {
        if (!context.currentItem.is(ItemTags.HOES) || !context.isTargetingBlock()) {
            return false;
        }
        return TILLABLES.contains(context.lastTargetedBlock().getBlock());
    }

    private static boolean shouldPlayShovelFlatten(UseAnimationConditionContext context) {
        if (!context.currentItem.is(ItemTags.SHOVELS) || !context.isTargetingBlock()) {
            return false;
        }
        return FLATTENABLES.contains(context.lastTargetedBlock().getBlock());
    }

    private static boolean shouldPlayShearsUse(UseAnimationConditionContext context) {
        return context.currentItem.is(Items.SHEARS) && context.useAnimationType() == UseAnimationType.INTERACT_ENTITY;
    }

    public static void register(UseAnimationRule useAnimationRule) {
        USE_ANIMATION_RULES.add(useAnimationRule);
    }

    public static void playUseAnimationIfTriggered(OnTickDriverContainer driverContainer, MontageManager montageManager, InteractionHand interactionHand) {
        boolean swingTimeIsOne;
        TriggerDriver hasUsedItemDriver = driverContainer.getDriver(FirstPersonDrivers.getHasUsedItemDriver(interactionHand));
        TriggerDriver hasAttackedDriver = driverContainer.getDriver(FirstPersonDrivers.HAS_ATTACKED);
        int swingTime = (Integer)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_SWING_TIME);
        InteractionHand lastUsedHand = (InteractionHand)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_HAND);
        boolean bl = swingTimeIsOne = swingTime == 1;
        if (lastUsedHand != interactionHand) {
            return;
        }
        boolean shouldPlayUseAnimationThisTick = hasUsedItemDriver.hasBeenTriggeredAndNotConsumed();
        if (!shouldPlayUseAnimationThisTick) {
            return;
        }
        hasUsedItemDriver.consume();
        ItemStack renderedItem = (ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.getRenderedItemDriver(interactionHand));
        ItemStack actualItem = (ItemStack)driverContainer.getDriverValue(FirstPersonDrivers.getItemDriver(interactionHand));
        UseAnimationType useAnimationType = (UseAnimationType)((Object)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USE_TYPE));
        BlockState lastTargetedBlock = (BlockState)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_TARGET_BLOCK_STATE);
        EntityType lastTargetedEntity = (EntityType)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_TARGET_ENTITY);
        boolean lastSwingFromClient = (Boolean)driverContainer.getDriverValue(FirstPersonDrivers.LAST_USED_SWING_FROM_CLIENT);
        UseAnimationConditionContext context = new UseAnimationConditionContext(useAnimationType, actualItem, useAnimationType == UseAnimationType.USE_ITEM_ON_BLOCK, useAnimationType == UseAnimationType.INTERACT_ENTITY || useAnimationType == UseAnimationType.INTERACT_AT_ENTITY, lastTargetedBlock, lastTargetedEntity, lastSwingFromClient);
        List<UseAnimationRule> sortedUseAnimationRules = USE_ANIMATION_RULES.stream().sorted(Comparator.comparingInt(UseAnimationRule::evaluationPriority).reversed()).toList();
        for (UseAnimationRule rule : sortedUseAnimationRules) {
            if (!rule.shouldChooseUseAnimation.test(context)) continue;
            LocomotionMain.DEBUG_LOGGER.info("Playing use animation \"{}\"", (Object)rule.identifier);
            montageManager.playMontage(rule.montageProvider.apply(interactionHand));
            if (FirstPersonHandPose.fromItemStack(renderedItem) == FirstPersonHandPose.fromItemStack(actualItem)) {
                FirstPersonDrivers.updateRenderedItem(driverContainer, interactionHand);
            }
            return;
        }
    }

    public static void triggerUseAnimation(InteractionHand hand, UseAnimationType useAnimationType, InteractionResult.SwingSource swingSource) {
        Optional<AnimationDataContainer> optional = JointAnimatorDispatcher.getInstance().getFirstPersonPlayerDataContainer();
        if (optional.isEmpty()) {
            return;
        }
        AnimationDataContainer dataContainer = optional.get();
        dataContainer.getDriver(FirstPersonDrivers.getHasUsedItemDriver(hand)).trigger();
        dataContainer.getDriver(FirstPersonDrivers.LAST_USE_TYPE).setValue(useAnimationType);
        dataContainer.getDriver(FirstPersonDrivers.LAST_USED_HAND).setValue(hand);
        dataContainer.getDriver(FirstPersonDrivers.LAST_USED_SWING_FROM_CLIENT).setValue(swingSource == InteractionResult.SwingSource.CLIENT);
    }

    public static void updateUseAnimationHitResults(AnimationDataContainer dataContainer) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        assert (hitResult != null);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (Minecraft.getInstance().level != null) {
                BlockState blockState = Minecraft.getInstance().level.getBlockState(blockHitResult.getBlockPos());
                dataContainer.getDriver(FirstPersonDrivers.LAST_USED_TARGET_BLOCK_STATE).setValue(blockState);
            }
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            EntityType entityType = entityHitResult.getEntity().getType();
            dataContainer.getDriver(FirstPersonDrivers.LAST_USED_TARGET_ENTITY).setValue(entityType);
        }
    }

    static {
        FirstPersonUseAnimations.register(UseAnimationRule.of(LocomotionMain.makeResourceLocation("default"), FirstPersonMontages::getUseAnimationMontage, UseAnimationConditionContext::swingFromClient, 0));
        FirstPersonUseAnimations.register(UseAnimationRule.of(LocomotionMain.makeResourceLocation("axe_scrape"), FirstPersonMontages::getAxeScrapeMontage, FirstPersonUseAnimations::shouldPlayAxeScrape, 10));
        FirstPersonUseAnimations.register(UseAnimationRule.of(LocomotionMain.makeResourceLocation("hoe_till"), FirstPersonMontages::getHoeTillMontage, FirstPersonUseAnimations::shouldPlayHoeTill, 20));
        FirstPersonUseAnimations.register(UseAnimationRule.of(LocomotionMain.makeResourceLocation("shovel_flatten"), FirstPersonMontages::getShovelFlattenMontage, FirstPersonUseAnimations::shouldPlayShovelFlatten, 30));
        FirstPersonUseAnimations.register(UseAnimationRule.of(LocomotionMain.makeResourceLocation("shears_use"), FirstPersonMontages::getShearsUseMontage, FirstPersonUseAnimations::shouldPlayShearsUse, 40));
        TILLABLES = List.of(Blocks.GRASS_BLOCK, Blocks.DIRT_PATH, Blocks.DIRT, Blocks.COARSE_DIRT, Blocks.ROOTED_DIRT);
        FLATTENABLES = List.of(Blocks.GRASS_BLOCK, Blocks.DIRT, Blocks.PODZOL, Blocks.COARSE_DIRT, Blocks.MYCELIUM, Blocks.ROOTED_DIRT);
    }

    public record UseAnimationConditionContext(UseAnimationType useAnimationType, ItemStack currentItem, boolean isTargetingBlock, boolean isTargetingEntity, BlockState lastTargetedBlock, EntityType<?> lastTargetedEntity, boolean swingFromClient) {
        public boolean isTargetingBlockOrEntity() {
            return this.isTargetingBlock || this.isTargetingEntity;
        }
    }

    public static enum UseAnimationType {
        INTERACT_ENTITY,
        INTERACT_AT_ENTITY,
        USE_ITEM,
        USE_ITEM_ON_BLOCK;

    }

    public record UseAnimationRule(ResourceLocation identifier, Function<InteractionHand, MontageConfiguration> montageProvider, Predicate<UseAnimationConditionContext> shouldChooseUseAnimation, int evaluationPriority) {
        public static UseAnimationRule of(ResourceLocation identifier, Function<InteractionHand, MontageConfiguration> montageProvider, Predicate<UseAnimationConditionContext> shouldChooseUseAnimation, int evaluationPriority) {
            return new UseAnimationRule(identifier, montageProvider, shouldChooseUseAnimation, evaluationPriority);
        }
    }
}

