/*
 * Decompiled with CFR 0.152.
 */
package com.trainguy9512.locomotion.animation.joint;

import com.mojang.blaze3d.vertex.PoseStack;
import com.trainguy9512.locomotion.util.Interpolator;
import net.minecraft.client.model.geom.PartPose;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class JointChannel {
    private final Matrix4f transform;
    private boolean visibility;
    public static final JointChannel ZERO = JointChannel.ofPartPose(PartPose.ZERO);
    private static final Quaternionf QUATERNION_CACHE = new Quaternionf();
    private static final Vector3f VECTOR_CACHE = new Vector3f();

    private JointChannel(Matrix4f transform, boolean visibility) {
        this.transform = transform;
        this.visibility = visibility;
    }

    public static JointChannel of(Matrix4f transform, boolean visibility) {
        return new JointChannel(new Matrix4f((Matrix4fc)transform), visibility);
    }

    public static JointChannel of(JointChannel jointChannel) {
        return JointChannel.of(jointChannel.transform, jointChannel.visibility);
    }

    public static JointChannel ofPartPose(PartPose partPose) {
        return JointChannel.ofTranslationRotationScaleEuler(new Vector3f(partPose.x(), partPose.y(), partPose.z()), new Vector3f(partPose.xRot(), partPose.yRot(), partPose.zRot()), new Vector3f(partPose.xScale(), partPose.yScale(), partPose.zScale()), true);
    }

    public static JointChannel ofTranslationRotationScaleEuler(Vector3f translation, Vector3f rotationEuler, Vector3f scale, boolean visibility) {
        return JointChannel.ofTranslationRotationScaleQuaternion(translation, new Quaternionf().rotationZYX(rotationEuler.z(), rotationEuler.y(), rotationEuler.x()), scale, visibility);
    }

    public static JointChannel ofTranslationRotationScaleQuaternion(Vector3f translation, Quaternionf rotation, Vector3f scale, boolean visibility) {
        return JointChannel.of(new Matrix4f().translationRotateScale((Vector3fc)translation, (Quaternionfc)rotation, (Vector3fc)scale), visibility);
    }

    public Matrix4f getTransform() {
        return new Matrix4f((Matrix4fc)this.transform);
    }

    public boolean getVisibility() {
        return this.visibility;
    }

    public Vector3f getTranslation() {
        return this.transform.getTranslation(new Vector3f());
    }

    public Quaternionf getRotation() {
        return this.transform.getNormalizedRotation(new Quaternionf());
    }

    public Vector3f getEulerRotationZYX() {
        return this.transform.getEulerAnglesZYX(new Vector3f());
    }

    public Vector3f getScale() {
        return this.transform.getScale(new Vector3f());
    }

    public PartPose asPartPose() {
        Vector3f rotation = this.getEulerRotationZYX();
        Vector3f translation = this.getTranslation();
        return PartPose.offsetAndRotation((float)translation.x(), (float)translation.y(), (float)translation.z(), (float)rotation.x(), (float)rotation.y(), (float)rotation.z());
    }

    public void setIdentity() {
        this.transform.identity();
    }

    public void translate(Vector3f translation, TransformSpace transformSpace, TransformType transformType) {
        switch (transformType.ordinal()) {
            case 2: {
                if (translation.x() == 0.0f && translation.y() == 0.0f && translation.z() == 0.0f) break;
                switch (transformSpace.ordinal()) {
                    case 2: {
                        this.transform.translate((Vector3fc)translation);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.transform.translateLocal((Vector3fc)translation);
                    }
                }
                break;
            }
            case 1: {
                this.transform.setTranslation((Vector3fc)translation);
            }
        }
    }

    public void rotate(Quaternionf rotation, TransformSpace transformSpace, TransformType transformType) {
        switch (transformType.ordinal()) {
            case 2: {
                switch (transformSpace.ordinal()) {
                    case 2: {
                        this.transform.rotate((Quaternionfc)rotation);
                        break;
                    }
                    case 0: 
                    case 1: {
                        Quaternionf currentRotation = this.transform.getUnnormalizedRotation(new Quaternionf());
                        rotation.mul((Quaternionfc)currentRotation, currentRotation);
                        this.transform.translationRotateScale((Vector3fc)this.getTranslation(), (Quaternionfc)currentRotation, (Vector3fc)this.getScale());
                    }
                }
                break;
            }
            case 1: {
                this.transform.translationRotateScale((Vector3fc)this.getTranslation(), (Quaternionfc)rotation, (Vector3fc)this.getScale());
            }
        }
    }

    public void scale(Vector3f scale, TransformSpace transformSpace, TransformType transformType) {
        switch (transformType.ordinal()) {
            case 2: {
                switch (transformSpace.ordinal()) {
                    case 2: {
                        this.transform.scale((Vector3fc)scale);
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.transform.scaleLocal(scale.x, scale.y, scale.z);
                    }
                }
                break;
            }
            case 1: {
                Matrix4f matrix4f = new Matrix4f().identity();
                matrix4f.translationRotateScale((Vector3fc)this.getTranslation(), (Quaternionfc)this.getRotation(), (Vector3fc)scale);
                this.transform.set((Matrix4fc)matrix4f);
            }
        }
    }

    public void rotate(Vector3f rotationEuler, TransformSpace transformSpace, TransformType transformType) {
        this.rotate(new Quaternionf().rotationXYZ(rotationEuler.x(), rotationEuler.y(), rotationEuler.z()), transformSpace, transformType);
    }

    public void multiply(JointChannel other, TransformSpace transformSpace, TransformType transformType) {
        this.multiply(other.transform, transformSpace, transformType);
    }

    public void multiply(Matrix4f transform, TransformSpace transformSpace, TransformType transformType) {
        switch (transformType.ordinal()) {
            case 2: {
                switch (transformSpace.ordinal()) {
                    case 0: 
                    case 1: {
                        this.transform.mul((Matrix4fc)transform);
                        break;
                    }
                    case 2: {
                        transform.mul((Matrix4fc)this.transform, this.transform);
                    }
                }
                break;
            }
            case 1: {
                this.transform.set((Matrix4fc)transform);
            }
        }
    }

    public void invert() {
        this.transform.invert();
    }

    public JointChannel mirrored() {
        Vector3f mirroredTranslation = this.getTranslation().mul(-1.0f, 1.0f, 1.0f);
        Vector3f mirroredRotation = this.transform.getUnnormalizedRotation(QUATERNION_CACHE).getEulerAnglesZYX(VECTOR_CACHE).mul(1.0f, -1.0f, -1.0f);
        return JointChannel.ofTranslationRotationScaleEuler(mirroredTranslation, mirroredRotation, this.getScale(), this.visibility);
    }

    public JointChannel interpolate(JointChannel other, float weight, JointChannel destination) {
        Vector3f translation = this.transform.getTranslation(new Vector3f());
        Quaternionf rotation = this.transform.getUnnormalizedRotation(new Quaternionf());
        Vector3f scale = this.transform.getScale(new Vector3f());
        Vector3f otherTranslation = other.transform.getTranslation(new Vector3f());
        Quaternionf otherRotation = other.transform.getUnnormalizedRotation(new Quaternionf());
        Vector3f otherScale = other.transform.getScale(new Vector3f());
        translation.lerp((Vector3fc)otherTranslation, weight);
        rotation.slerp((Quaternionfc)otherRotation, weight);
        scale.lerp((Vector3fc)otherScale, weight);
        boolean visibility = Interpolator.BOOLEAN_BLEND.interpolate(this.visibility, other.visibility, weight);
        destination.transform.translationRotateScale((Vector3fc)translation, (Quaternionfc)rotation, (Vector3fc)scale);
        destination.visibility = visibility;
        return destination;
    }

    public JointChannel interpolate(JointChannel other, float weight) {
        return this.interpolate(other, weight, this);
    }

    public void transformPoseStack(PoseStack poseStack, float transformMultiplier) {
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)this.transform);
        poseStack.mulPose((Matrix4fc)matrix4f.setTranslation((Vector3fc)this.getTranslation().div((Vector3fc)new Vector3f(transformMultiplier))));
    }

    public void transformPoseStack(PoseStack poseStack) {
        this.transformPoseStack(poseStack, 1.0f);
    }

    public static enum TransformType {
        IGNORE,
        REPLACE,
        ADD;

    }

    public static enum TransformSpace {
        COMPONENT,
        PARENT,
        LOCAL;

    }
}

